/*
 * Decompiled with CFR 0.152.
 */
package org.jsefa.csv.lowlevel;

import org.jsefa.csv.lowlevel.CsvLowLevelSerializer;
import org.jsefa.csv.lowlevel.config.CsvLowLevelConfiguration;
import org.jsefa.csv.lowlevel.config.EscapeMode;
import org.jsefa.csv.lowlevel.config.QuoteMode;
import org.jsefa.rbf.lowlevel.RbfLowLevelSerializerImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsvLowLevelSerializerImpl
extends RbfLowLevelSerializerImpl<CsvLowLevelConfiguration>
implements CsvLowLevelSerializer {
    private int fieldCount;
    private int specialRecordDelimiter;

    public CsvLowLevelSerializerImpl(CsvLowLevelConfiguration config) {
        super(config);
        this.specialRecordDelimiter = config.getSpecialRecordDelimiter() != null ? (int)config.getSpecialRecordDelimiter().charValue() : -1;
    }

    @Override
    protected void afterOpen() {
        this.fieldCount = 0;
    }

    @Override
    public void writeField(String value, QuoteMode quoteMode) {
        if (this.fieldCount > 0) {
            this.writeChar(((CsvLowLevelConfiguration)this.getConfiguration()).getFieldDelimiter());
        }
        this.encodeAndWrite(value, quoteMode);
        ++this.fieldCount;
    }

    @Override
    protected void beforeFinishRecord() {
        if (((CsvLowLevelConfiguration)this.getConfiguration()).getUseDelimiterAfterLastField()) {
            this.writeChar(((CsvLowLevelConfiguration)this.getConfiguration()).getFieldDelimiter());
        }
        this.fieldCount = 0;
    }

    private void encodeAndWrite(String value, QuoteMode quoteMode) {
        if (value.length() == 0) {
            return;
        }
        switch (quoteMode) {
            case ALWAYS: {
                this.encodeAndWriteUsingQuotes(value);
                break;
            }
            case ON_DEMAND: {
                this.encodeAndWriteUsingQuotesOnDemand(value);
                break;
            }
            case NEVER: {
                this.encodeAndWriteUsingEscapeCharacter(value);
                break;
            }
            default: {
                throw new UnsupportedOperationException("The quote mode is not supported: " + (Object)((Object)quoteMode));
            }
        }
    }

    private void encodeAndWriteUsingQuotes(String value) {
        char quoteChar = ((CsvLowLevelConfiguration)this.getConfiguration()).getQuoteCharacter();
        char escapeCharacter = ((CsvLowLevelConfiguration)this.getConfiguration()).getEscapeCharacter();
        if (((CsvLowLevelConfiguration)this.getConfiguration()).getQuoteCharacterEscapeMode().equals((Object)EscapeMode.DOUBLING)) {
            escapeCharacter = quoteChar;
        }
        this.writeChar(quoteChar);
        int index = 0;
        while (index < value.length()) {
            char currentChar;
            if ((currentChar = value.charAt(index++)) == quoteChar) {
                this.writeChar(escapeCharacter);
            }
            this.writeChar(currentChar);
        }
        this.writeChar(((CsvLowLevelConfiguration)this.getConfiguration()).getQuoteCharacter());
    }

    private void encodeAndWriteUsingQuotesOnDemand(String value) {
        if (this.needsQuotes(value)) {
            this.encodeAndWriteUsingQuotes(value);
        } else {
            this.writeString(value);
        }
    }

    private void encodeAndWriteUsingEscapeCharacter(String value) {
        int index = 0;
        while (index < value.length()) {
            char currentChar;
            if ((currentChar = value.charAt(index++)) == ((CsvLowLevelConfiguration)this.getConfiguration()).getEscapeCharacter() || currentChar == ((CsvLowLevelConfiguration)this.getConfiguration()).getFieldDelimiter() || currentChar == this.specialRecordDelimiter) {
                this.writeChar(((CsvLowLevelConfiguration)this.getConfiguration()).getEscapeCharacter());
                this.writeChar(currentChar);
                continue;
            }
            if (currentChar == '\n') {
                this.writeChar(((CsvLowLevelConfiguration)this.getConfiguration()).getEscapeCharacter());
                this.writeChar(110);
                continue;
            }
            this.writeChar(currentChar);
        }
    }

    private boolean needsQuotes(String value) {
        if (value.charAt(0) == ((CsvLowLevelConfiguration)this.getConfiguration()).getQuoteCharacter()) {
            return true;
        }
        for (int i = 0; i < value.length(); ++i) {
            char currentChar = value.charAt(i);
            if (currentChar != ((CsvLowLevelConfiguration)this.getConfiguration()).getEscapeCharacter() && currentChar != ((CsvLowLevelConfiguration)this.getConfiguration()).getFieldDelimiter()) continue;
            return true;
        }
        return value.contains(((CsvLowLevelConfiguration)this.getConfiguration()).getLineBreak());
    }
}

