/*
 * Decompiled with CFR 0.152.
 */
package org.jsefa.csv.lowlevel.config;

import org.jsefa.common.config.InitialConfiguration;
import org.jsefa.csv.lowlevel.config.EscapeMode;
import org.jsefa.rbf.lowlevel.config.RbfLowLevelConfiguration;

public final class CsvLowLevelConfiguration
extends RbfLowLevelConfiguration {
    private Character fieldDelimiter;
    private Character quoteCharacter;
    private EscapeMode quoteCharacterEscapeMode;
    private Boolean useDelimiterAfterLastField;
    private Character escapeCharacter;

    public CsvLowLevelConfiguration() {
    }

    private CsvLowLevelConfiguration(CsvLowLevelConfiguration other) {
        super(other);
        this.setFieldDelimiter(other.getFieldDelimiter());
        this.setUseDelimiterAfterLastField(other.getUseDelimiterAfterLastField());
        this.setQuoteCharacter(other.getQuoteCharacter());
        this.setQuoteCharacterEscapeMode(other.getQuoteCharacterEscapeMode());
        this.setEscapeCharacter(other.getEscapeCharacter());
    }

    public CsvLowLevelConfiguration createCopy() {
        return new CsvLowLevelConfiguration(this);
    }

    public char getFieldDelimiter() {
        if (this.fieldDelimiter == null) {
            this.fieldDelimiter = (Character)InitialConfiguration.get("jsefa:csv:lowlevel:fieldDelimiter", Character.valueOf(';'));
        }
        return this.fieldDelimiter.charValue();
    }

    public char getQuoteCharacter() {
        if (this.quoteCharacter == null) {
            this.quoteCharacter = (Character)InitialConfiguration.get("jsefa:csv:lowlevel:quoteCharacter", Character.valueOf('\"'));
        }
        return this.quoteCharacter.charValue();
    }

    public EscapeMode getQuoteCharacterEscapeMode() {
        if (this.quoteCharacterEscapeMode == null) {
            this.quoteCharacterEscapeMode = (EscapeMode)((Object)InitialConfiguration.get("jsefa:csv:lowlevel:quoteCharacterEscapeMode", (Object)Defaults.DEFAULT_QUOTE_CHARACTER_ESCAPE_MODE));
        }
        return this.quoteCharacterEscapeMode;
    }

    public boolean getUseDelimiterAfterLastField() {
        if (this.useDelimiterAfterLastField == null) {
            this.useDelimiterAfterLastField = (Boolean)InitialConfiguration.get("jsefa:csv:lowlevel:useDelimiterAfterLastField", false);
        }
        return this.useDelimiterAfterLastField;
    }

    public char getEscapeCharacter() {
        if (this.escapeCharacter == null) {
            this.escapeCharacter = (Character)InitialConfiguration.get("jsefa:csv:lowlevel:escapeCharacter", Character.valueOf('\\'));
        }
        return this.escapeCharacter.charValue();
    }

    public void setFieldDelimiter(char fieldDelimiter) {
        this.fieldDelimiter = Character.valueOf(fieldDelimiter);
    }

    public void setQuoteCharacter(char quoteCharacter) {
        this.quoteCharacter = Character.valueOf(quoteCharacter);
    }

    public void setEscapeCharacter(char escapeCharacter) {
        this.escapeCharacter = Character.valueOf(escapeCharacter);
    }

    public void setUseDelimiterAfterLastField(boolean useDelimiterAfterLastField) {
        this.useDelimiterAfterLastField = useDelimiterAfterLastField;
    }

    public void setQuoteCharacterEscapeMode(EscapeMode quoteCharacterEscapeMode) {
        this.quoteCharacterEscapeMode = quoteCharacterEscapeMode;
    }

    public static interface Defaults {
        public static final char DEFAULT_ESCAPE_CHARACTER = '\\';
        public static final char DEFAULT_FIELD_DELIMITER = ';';
        public static final char DEFAULT_QUOTE_CHARACTER = '\"';
        public static final EscapeMode DEFAULT_QUOTE_CHARACTER_ESCAPE_MODE = EscapeMode.DOUBLING;
        public static final boolean DEFAULT_USE_DELIMITER_AFTER_LAST_FIELD = false;
    }
}

