/*
 * Decompiled with CFR 0.152.
 */
package org.jsefa.flr;

import java.lang.reflect.Method;
import org.jsefa.IOFactory;
import org.jsefa.IOFactoryException;
import org.jsefa.common.config.InitialConfiguration;
import org.jsefa.common.util.ReflectionUtil;
import org.jsefa.flr.FlrDeserializer;
import org.jsefa.flr.FlrIOFactoryImpl;
import org.jsefa.flr.FlrSerializer;
import org.jsefa.flr.annotation.FlrEntryPointFactory;
import org.jsefa.flr.annotation.FlrTypeMappingFactory;
import org.jsefa.flr.config.FlrConfiguration;
import org.jsefa.rbf.mapping.RbfTypeMappingRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FlrIOFactory
implements IOFactory {
    public static FlrIOFactory createFactory(FlrConfiguration config) {
        Class factoryClass = (Class)InitialConfiguration.get("jsefa:flr:ioFactoryClass", FlrIOFactoryImpl.class);
        Method createMethod = ReflectionUtil.getMethod(factoryClass, "createFactory", FlrConfiguration.class);
        if (createMethod == null) {
            throw new IOFactoryException("Failed to create a FlrIOFactory. The factory " + factoryClass + " does not contain the required static createFactory method.");
        }
        try {
            return (FlrIOFactory)ReflectionUtil.callMethod(null, createMethod, config);
        }
        catch (Exception e) {
            throw new IOFactoryException("Failed to create a FlrIOFactory", e);
        }
    }

    public static FlrIOFactory createFactory(Class<?> ... objectTypes) {
        return FlrIOFactory.createFactory(new FlrConfiguration(), objectTypes);
    }

    public static FlrIOFactory createFactory(FlrConfiguration config, Class<?> ... objectTypes) {
        FlrConfiguration newConfig = config.createCopy();
        try {
            FlrTypeMappingFactory typeMappingFactory = new FlrTypeMappingFactory((RbfTypeMappingRegistry)newConfig.getTypeMappingRegistry(), newConfig.getSimpleTypeConverterProvider(), newConfig.getValidatorProvider(), newConfig.getObjectAccessorProvider(), newConfig.getDefaultPadCharacter());
            newConfig.getEntryPoints().addAll(FlrEntryPointFactory.createEntryPoints(typeMappingFactory, objectTypes));
            return FlrIOFactory.createFactory(newConfig);
        }
        catch (IOFactoryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOFactoryException("Failed to create an FlrIOFactory", e);
        }
    }

    @Override
    public abstract FlrSerializer createSerializer();

    @Override
    public abstract FlrDeserializer createDeserializer();
}

