/*
 * Decompiled with CFR 0.152.
 */
package org.jsefa.flr;

import java.util.Collection;
import java.util.Map;
import org.jsefa.IOFactoryException;
import org.jsefa.flr.FlrDeserializer;
import org.jsefa.flr.FlrDeserializerImpl;
import org.jsefa.flr.FlrIOFactory;
import org.jsefa.flr.FlrSerializer;
import org.jsefa.flr.FlrSerializerImpl;
import org.jsefa.flr.config.FlrConfiguration;
import org.jsefa.flr.lowlevel.FlrLowLevelIOFactory;
import org.jsefa.flr.lowlevel.config.FlrLowLevelConfiguration;
import org.jsefa.rbf.RbfIOFactory;
import org.jsefa.rbf.mapping.RbfEntryPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FlrIOFactoryImpl
extends FlrIOFactory {
    private final RbfIOFactory<FlrConfiguration, FlrSerializer, FlrDeserializer> rbfIOFactory;
    private final FlrLowLevelIOFactory lowLevelIOFactory;

    public static FlrIOFactory createFactory(FlrConfiguration config) {
        return new FlrIOFactoryImpl(config);
    }

    FlrIOFactoryImpl(FlrConfiguration config) {
        this.rbfIOFactory = this.createRbfIOFactory(config);
        if (this.rbfIOFactory.withPrefixes()) {
            this.assertEqualPrefixLength(config.getEntryPoints());
        }
        this.lowLevelIOFactory = FlrLowLevelIOFactory.createFactory((FlrLowLevelConfiguration)config.getLowLevelConfiguration());
    }

    @Override
    public FlrSerializer createSerializer() {
        return (FlrSerializer)this.rbfIOFactory.createSerializer();
    }

    @Override
    public FlrDeserializer createDeserializer() {
        return (FlrDeserializer)this.rbfIOFactory.createDeserializer();
    }

    private void assertEqualPrefixLength(Collection<RbfEntryPoint> entryPoints) {
        int length = ((String)entryPoints.iterator().next().getDesignator()).length();
        for (RbfEntryPoint entryPoint : entryPoints) {
            if (((String)entryPoint.getDesignator()).length() == length) continue;
            throw new IOFactoryException("The prefix " + (String)entryPoint.getDesignator() + " has not the length " + length);
        }
    }

    private RbfIOFactory<FlrConfiguration, FlrSerializer, FlrDeserializer> createRbfIOFactory(FlrConfiguration config) {
        return new RbfIOFactory<FlrConfiguration, FlrSerializer, FlrDeserializer>(config){

            @Override
            protected FlrSerializer createSerializer(FlrConfiguration config, Map<Class<?>, RbfEntryPoint> entryPointsByObjectType) {
                return new FlrSerializerImpl(config, entryPointsByObjectType, FlrIOFactoryImpl.this.lowLevelIOFactory.createSerializer());
            }

            @Override
            protected FlrDeserializer createDeserializer(FlrConfiguration config, RbfEntryPoint entryPoint) {
                return new FlrDeserializerImpl(config, entryPoint, FlrIOFactoryImpl.this.lowLevelIOFactory.createDeserializer());
            }

            @Override
            protected FlrDeserializer createDeserializer(FlrConfiguration config, Map<String, RbfEntryPoint> entryPointsByPrefix) {
                return new FlrDeserializerImpl(config, entryPointsByPrefix, FlrIOFactoryImpl.this.lowLevelIOFactory.createDeserializer());
            }
        };
    }
}

