/*
 * Decompiled with CFR 0.152.
 */
package org.jsefa.flr.annotation;

import java.util.ArrayList;
import java.util.Collection;
import org.jsefa.flr.annotation.FlrDataType;
import org.jsefa.flr.annotation.FlrTypeMappingFactory;
import org.jsefa.rbf.mapping.RbfEntryPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FlrEntryPointFactory {
    public static Collection<RbfEntryPoint> createEntryPoints(FlrTypeMappingFactory typeMappingFactory, Class<?> ... objectTypes) {
        ArrayList<RbfEntryPoint> entryPoints = new ArrayList<RbfEntryPoint>(objectTypes.length);
        for (Class<?> objectType : objectTypes) {
            Object dataTypeName = typeMappingFactory.createIfAbsent((Class)objectType);
            String prefix = FlrEntryPointFactory.getAnnotatedPrefix(objectType, objectType.getSimpleName());
            entryPoints.add(new RbfEntryPoint((String)dataTypeName, prefix, null));
        }
        return entryPoints;
    }

    private static String getAnnotatedPrefix(Class<?> objectType, String defaultName) {
        return objectType.getAnnotation(FlrDataType.class).defaultPrefix();
    }

    private FlrEntryPointFactory() {
    }
}

