/*
 * Decompiled with CFR 0.152.
 */
package org.jsefa.flr.annotation;

import java.lang.reflect.Field;
import org.jsefa.common.accessor.ObjectAccessorProvider;
import org.jsefa.common.annotation.AnnotationException;
import org.jsefa.common.converter.SimpleTypeConverter;
import org.jsefa.common.converter.provider.SimpleTypeConverterProvider;
import org.jsefa.common.mapping.TypeMapping;
import org.jsefa.common.validator.provider.ValidatorProvider;
import org.jsefa.flr.annotation.FlrDataType;
import org.jsefa.flr.annotation.FlrField;
import org.jsefa.flr.annotation.FlrSubRecord;
import org.jsefa.flr.annotation.FlrSubRecordList;
import org.jsefa.flr.mapping.FlrSimpleTypeMapping;
import org.jsefa.rbf.annotation.RbfAnnotations;
import org.jsefa.rbf.annotation.RbfTypeMappingFactory;
import org.jsefa.rbf.mapping.RbfTypeMappingRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FlrTypeMappingFactory
extends RbfTypeMappingFactory {
    private static final RbfAnnotations ANNOTATIONS = new RbfAnnotations(FlrDataType.class, FlrField.class, FlrSubRecord.class, FlrSubRecordList.class);
    private char defaultPadCharacter;

    public FlrTypeMappingFactory(RbfTypeMappingRegistry typeMappingRegistry, SimpleTypeConverterProvider simpleTypeConverterProvider, ValidatorProvider validatorProvider, ObjectAccessorProvider objectAccessorProvider, char defaultPadCharacter) {
        super(typeMappingRegistry, simpleTypeConverterProvider, validatorProvider, objectAccessorProvider, ANNOTATIONS);
        this.defaultPadCharacter = defaultPadCharacter;
    }

    @Override
    protected TypeMapping<String> createSimpleTypeMapping(Class<?> objectType, String dataTypeName, SimpleTypeConverter converter, Field field) {
        FlrField fieldAnnotation = field.getAnnotation(FlrField.class);
        if (fieldAnnotation.length() <= 0) {
            throw new AnnotationException("Field length of field " + field.getName() + " of class " + field.getDeclaringClass().getName() + " must be > 0");
        }
        char padCharacter = fieldAnnotation.padCharacter();
        if (padCharacter == '\u0001') {
            padCharacter = this.defaultPadCharacter;
        }
        return new FlrSimpleTypeMapping(objectType, dataTypeName, converter, fieldAnnotation.length(), padCharacter, fieldAnnotation.align());
    }
}

