/*
 * Decompiled with CFR 0.152.
 */
package org.jsefa.rbf;

import java.io.Writer;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import org.jsefa.SerializationException;
import org.jsefa.common.config.ValidationMode;
import org.jsefa.common.mapping.SimpleTypeMapping;
import org.jsefa.common.mapping.TypeMapping;
import org.jsefa.common.util.ReflectionUtil;
import org.jsefa.common.validator.ValidationException;
import org.jsefa.common.validator.ValidationResult;
import org.jsefa.common.validator.Validator;
import org.jsefa.rbf.RbfSerializer;
import org.jsefa.rbf.config.RbfConfiguration;
import org.jsefa.rbf.lowlevel.RbfLowLevelSerializer;
import org.jsefa.rbf.mapping.RbfComplexTypeMapping;
import org.jsefa.rbf.mapping.RbfEntryPoint;
import org.jsefa.rbf.mapping.RbfListTypeMapping;
import org.jsefa.rbf.mapping.RbfNodeMapping;
import org.jsefa.rbf.mapping.RbfNodeType;
import org.jsefa.rbf.mapping.RbfTypeMappingRegistry;
import org.jsefa.rbf.mapping.RecordDescriptor;
import org.jsefa.rbf.mapping.RecordMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RbfSerializerImpl<L extends RbfLowLevelSerializer>
implements RbfSerializer {
    private final RbfTypeMappingRegistry typeMappingRegistry;
    private final Map<Class<?>, RbfEntryPoint> entryPoints;
    private final boolean withPrefix;
    private final IdentityHashMap<Object, Object> complexObjectsOnPath;
    private L lowLevelSerializer;
    private boolean validate;

    protected RbfSerializerImpl(RbfConfiguration<?> config, Map<Class<?>, RbfEntryPoint> entryPoints, L lowLevelSerializer) {
        this.typeMappingRegistry = (RbfTypeMappingRegistry)config.getTypeMappingRegistry();
        this.entryPoints = entryPoints;
        this.withPrefix = ((String)entryPoints.values().iterator().next().getDesignator()).length() > 0;
        this.complexObjectsOnPath = new IdentityHashMap();
        this.lowLevelSerializer = lowLevelSerializer;
        this.validate = config.getValidationMode().equals((Object)ValidationMode.SERIALIZATION) || config.getValidationMode().equals((Object)ValidationMode.BOTH);
    }

    @Override
    public final void open(Writer writer) {
        this.complexObjectsOnPath.clear();
        try {
            this.getLowLevelSerializer().open(writer);
        }
        catch (Exception e) {
            throw new SerializationException("Error while opening the serialization stream", e);
        }
    }

    @Override
    public final void write(Object object) {
        if (object == null) {
            return;
        }
        try {
            RbfEntryPoint entryPoint = this.getEntryPoint(object.getClass());
            if (this.validate) {
                this.assertValueIsValid(object, entryPoint);
            }
            if (this.withPrefix) {
                this.writePrefix((String)entryPoint.getDesignator());
            }
            this.writeValue(object, this.getTypeMapping((String)entryPoint.getDataTypeName()));
            this.getLowLevelSerializer().finishRecord();
        }
        catch (SerializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SerializationException(e);
        }
    }

    @Override
    public void flush() {
        try {
            this.lowLevelSerializer.flush();
        }
        catch (Exception e) {
            throw new SerializationException("Error while flushing the serialization stream");
        }
    }

    @Override
    public final void close(boolean closeWriter) {
        try {
            this.getLowLevelSerializer().close(closeWriter);
        }
        catch (Exception e) {
            throw new SerializationException("Error while closing the serialization stream", e);
        }
    }

    public L getLowLevelSerializer() {
        return this.lowLevelSerializer;
    }

    protected abstract void writeSimpleValue(Object var1, SimpleTypeMapping<?> var2);

    protected abstract void writePrefix(String var1);

    private void writeValue(Object object, TypeMapping<?> typeMapping) {
        if (typeMapping instanceof SimpleTypeMapping) {
            this.writeSimpleValue(object, (SimpleTypeMapping)typeMapping);
        } else if (typeMapping instanceof RbfComplexTypeMapping) {
            this.writeComplexValue(object, (RbfComplexTypeMapping)typeMapping);
        } else {
            throw new UnsupportedOperationException("Unknown type mapping type");
        }
    }

    private void writeComplexValue(Object object, RbfComplexTypeMapping typeMapping) {
        if (this.complexObjectsOnPath.containsKey(object)) {
            throw new SerializationException("Cycle detected while serializing " + object);
        }
        if (object != null) {
            this.complexObjectsOnPath.put(object, object);
        }
        this.writeFields(object, typeMapping);
        if (object != null) {
            this.writeSubRecords(object, typeMapping);
            this.complexObjectsOnPath.remove(object);
        }
    }

    private void writeFields(Object object, RbfComplexTypeMapping typeMapping) {
        for (String fieldName : typeMapping.getFieldNames(RbfNodeType.FIELD)) {
            Object fieldValue = null;
            if (object != null) {
                fieldValue = typeMapping.getObjectAccessor().getValue(object, fieldName);
            }
            RbfNodeMapping nodeMapping = (RbfNodeMapping)typeMapping.getNodeMapping(fieldName, Object.class);
            String fieldDataTypeName = (String)nodeMapping.getDataTypeName();
            this.writeValue(fieldValue, this.getTypeMapping(fieldDataTypeName));
        }
    }

    private void writeSubRecords(Object object, RbfComplexTypeMapping typeMapping) {
        for (String fieldName : typeMapping.getFieldNames(RbfNodeType.RECORD)) {
            Object fieldValue = typeMapping.getObjectAccessor().getValue(object, fieldName);
            if (fieldValue == null) continue;
            RecordMapping recordMapping = (RecordMapping)typeMapping.getNodeMapping(fieldName, Object.class);
            TypeMapping<?> subRecordTypeMapping = this.getTypeMapping((String)recordMapping.getDataTypeName());
            if (subRecordTypeMapping instanceof RbfComplexTypeMapping) {
                this.getLowLevelSerializer().finishRecord();
                this.writePrefix(((RecordDescriptor)recordMapping.getNodeDescriptor()).getPrefix());
                this.writeValue(fieldValue, subRecordTypeMapping);
                continue;
            }
            if (!(subRecordTypeMapping instanceof RbfListTypeMapping)) continue;
            RbfListTypeMapping listTypeMapping = (RbfListTypeMapping)subRecordTypeMapping;
            for (Object listItem : (Collection)fieldValue) {
                this.getLowLevelSerializer().finishRecord();
                RecordMapping itemRecordMapping = (RecordMapping)listTypeMapping.getNodeMapping(listItem.getClass());
                this.writePrefix(((RecordDescriptor)itemRecordMapping.getNodeDescriptor()).getPrefix());
                this.writeValue(listItem, this.getTypeMapping((String)itemRecordMapping.getDataTypeName()));
            }
        }
    }

    private TypeMapping<?> getTypeMapping(String dataTypeName) {
        TypeMapping<String> typeMapping = this.typeMappingRegistry.get(dataTypeName);
        if (typeMapping == null) {
            throw new SerializationException("Unknown data type name: " + dataTypeName);
        }
        return typeMapping;
    }

    private RbfEntryPoint getEntryPoint(Class<?> originalObjectType) {
        RbfEntryPoint entryPoint = ReflectionUtil.getNearest(originalObjectType, this.entryPoints);
        if (entryPoint == null) {
            throw new SerializationException("The following class was not registered for serialization: " + originalObjectType);
        }
        return entryPoint;
    }

    private void assertValueIsValid(Object object, RbfEntryPoint entryPoint) {
        ValidationResult result;
        Validator validator = entryPoint.getValidator();
        if (validator != null && !(result = validator.validate(object)).isValid()) {
            throw new ValidationException(result);
        }
    }
}

