/*
 * Decompiled with CFR 0.152.
 */
package org.jsefa.xml;

import java.io.Reader;
import java.util.Collection;
import java.util.Map;
import org.jsefa.DeserializationException;
import org.jsefa.ObjectPathElement;
import org.jsefa.common.accessor.ObjectAccessor;
import org.jsefa.common.config.ValidationMode;
import org.jsefa.common.lowlevel.InputPosition;
import org.jsefa.common.mapping.TypeMapping;
import org.jsefa.common.validator.ValidationException;
import org.jsefa.common.validator.ValidationResult;
import org.jsefa.common.validator.Validator;
import org.jsefa.xml.XmlDeserializer;
import org.jsefa.xml.config.XmlConfiguration;
import org.jsefa.xml.lowlevel.XmlLowLevelDeserializer;
import org.jsefa.xml.lowlevel.model.Attribute;
import org.jsefa.xml.lowlevel.model.ElementEnd;
import org.jsefa.xml.lowlevel.model.ElementStart;
import org.jsefa.xml.lowlevel.model.TextContent;
import org.jsefa.xml.lowlevel.model.XmlItem;
import org.jsefa.xml.lowlevel.model.XmlItemType;
import org.jsefa.xml.mapping.AttributeDescriptor;
import org.jsefa.xml.mapping.AttributeMapping;
import org.jsefa.xml.mapping.ElementDescriptor;
import org.jsefa.xml.mapping.ElementMapping;
import org.jsefa.xml.mapping.TextContentDescriptor;
import org.jsefa.xml.mapping.TextContentMapping;
import org.jsefa.xml.mapping.XmlComplexTypeMapping;
import org.jsefa.xml.mapping.XmlListTypeMapping;
import org.jsefa.xml.mapping.XmlMapTypeMapping;
import org.jsefa.xml.mapping.XmlNodeMapping;
import org.jsefa.xml.mapping.XmlSimpleTypeMapping;
import org.jsefa.xml.mapping.XmlTypeMappingRegistry;
import org.jsefa.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XmlDeserializerImpl
implements XmlDeserializer {
    private final XmlTypeMappingRegistry typeMappingRegistry;
    private final Map<ElementDescriptor, ElementMapping> entryElementMappings;
    private final XmlLowLevelDeserializer lowLevelDeserializer;
    private ElementMapping currentEntryElementMapping;
    private boolean validate;

    XmlDeserializerImpl(XmlConfiguration config, Map<ElementDescriptor, ElementMapping> entryElementMappings, XmlLowLevelDeserializer lowLevelDeserializer) {
        this.typeMappingRegistry = (XmlTypeMappingRegistry)config.getTypeMappingRegistry();
        this.entryElementMappings = entryElementMappings;
        this.lowLevelDeserializer = lowLevelDeserializer;
        this.validate = config.getValidationMode().equals((Object)ValidationMode.DESERIALIZATION) || config.getValidationMode().equals((Object)ValidationMode.BOTH);
    }

    @Override
    public void open(Reader reader) {
        this.open(reader, null);
    }

    @Override
    public void open(Reader reader, String baseURI) {
        this.currentEntryElementMapping = null;
        try {
            this.lowLevelDeserializer.open(reader, baseURI);
        }
        catch (Exception e) {
            throw new DeserializationException("Error while opening the deserialization stream");
        }
    }

    @Override
    public boolean hasNext() {
        try {
            if (!this.lowLevelDeserializer.hasNext()) {
                return false;
            }
            if (this.currentEntryElementMapping == null) {
                return this.moveToNextEntryElement();
            }
            return true;
        }
        catch (DeserializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DeserializationException(e).setInputPosition(this.getInputPosition());
        }
    }

    @Override
    public <T> T next() {
        try {
            if (!this.hasNext()) {
                T t = null;
                return t;
            }
            Object result = this.deserializeElement((QName)this.currentEntryElementMapping.getDataTypeName());
            if (this.validate && result != null) {
                this.assertValueIsValid(result, this.currentEntryElementMapping);
            }
            Object object = result;
            return (T)object;
        }
        catch (DeserializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DeserializationException(e).setInputPosition(this.getInputPosition());
        }
        finally {
            this.currentEntryElementMapping = null;
        }
    }

    @Override
    public void close(boolean closeReader) {
        try {
            this.lowLevelDeserializer.close(closeReader);
        }
        catch (Exception e) {
            throw new DeserializationException("Error while closing the deserialization stream");
        }
    }

    @Override
    public InputPosition getInputPosition() {
        return this.lowLevelDeserializer.getInputPosition();
    }

    private Object deserializeElement(QName dataTypeName) {
        TypeMapping<QName> typeMapping = this.typeMappingRegistry.get(dataTypeName);
        if (typeMapping instanceof XmlSimpleTypeMapping) {
            return this.deserializeSimpleElement((XmlSimpleTypeMapping)typeMapping);
        }
        if (typeMapping instanceof XmlComplexTypeMapping) {
            return this.deserializeComplexElement((XmlComplexTypeMapping)typeMapping);
        }
        if (typeMapping instanceof XmlListTypeMapping) {
            return this.deserializeListElement((XmlListTypeMapping)typeMapping);
        }
        if (typeMapping instanceof XmlMapTypeMapping) {
            return this.deserializeMapElement((XmlMapTypeMapping)typeMapping);
        }
        throw new IllegalArgumentException("Argument dataTypeName maps to a type mapping with unknown type: " + typeMapping.getClass());
    }

    private Object deserializeSimpleElement(XmlSimpleTypeMapping simpleTypeMapping) {
        return simpleTypeMapping.getSimpleTypeConverter().fromString(this.getText());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object deserializeComplexElement(XmlComplexTypeMapping typeMapping) {
        Object value;
        ObjectAccessor objectAccessor = typeMapping.getObjectAccessor();
        Object object = objectAccessor.createObject();
        ElementStart elementStart = (ElementStart)this.getCurrentXmlItem();
        for (Attribute attribute : elementStart.getAttributes()) {
            AttributeDescriptor attributeDescriptor = new AttributeDescriptor(attribute.getName());
            AttributeMapping attributeMapping = (AttributeMapping)typeMapping.getNodeMapping(attributeDescriptor);
            try {
                XmlSimpleTypeMapping attributeTypeMapping;
                Object value2;
                if (attributeMapping == null || (value2 = (attributeTypeMapping = this.getSimpleTypeMapping((QName)attributeMapping.getDataTypeName())).getSimpleTypeConverter().fromString(attribute.getValue())) == null) continue;
                objectAccessor.setValue(object, attributeMapping.getFieldDescriptor().getName(), value2);
            }
            catch (Exception e) {
                throw this.createException(e, typeMapping, attributeMapping.getFieldDescriptor().getName());
            }
        }
        if (typeMapping.isTextContentAllowed()) {
            TextContentMapping textContentMapping = (TextContentMapping)typeMapping.getNodeMapping(TextContentDescriptor.getInstance());
            XmlSimpleTypeMapping textContentTypeMapping = this.getSimpleTypeMapping((QName)textContentMapping.getDataTypeName());
            String fieldName = textContentMapping.getFieldDescriptor().getName();
            try {
                value = this.deserializeSimpleElement(textContentTypeMapping);
                if (value == null) return object;
                objectAccessor.setValue(object, fieldName, value);
                return object;
            }
            catch (Exception e) {
                throw this.createException(e, typeMapping, fieldName);
            }
        } else {
            int childDepth = this.getCurrentDepth() + 1;
            while (this.moveToNextElement(childDepth)) {
                ElementMapping childElementMapping = (ElementMapping)typeMapping.getNodeMapping(this.getCurrentElementDescriptor());
                if (childElementMapping == null) continue;
                String fieldName = childElementMapping.getFieldDescriptor().getName();
                try {
                    Object currentValue;
                    value = this.deserializeElement((QName)childElementMapping.getDataTypeName());
                    if (value == null) continue;
                    if (value instanceof Collection) {
                        currentValue = (Collection)objectAccessor.getValue(object, fieldName);
                        if (currentValue != null) {
                            currentValue.addAll((Collection)value);
                            continue;
                        }
                        objectAccessor.setValue(object, fieldName, value);
                        continue;
                    }
                    if (value instanceof Map) {
                        currentValue = (Map)objectAccessor.getValue(object, fieldName);
                        if (currentValue != null) {
                            currentValue.putAll((Map)value);
                            continue;
                        }
                        objectAccessor.setValue(object, fieldName, value);
                        continue;
                    }
                    objectAccessor.setValue(object, fieldName, value);
                }
                catch (Exception e) {
                    throw this.createException(e, typeMapping, fieldName);
                }
            }
        }
        return object;
    }

    private Collection<Object> deserializeListElement(XmlListTypeMapping typeMapping) {
        Collection listValue = (Collection)typeMapping.getObjectAccessor().createObject();
        if (typeMapping.isImplicit()) {
            XmlNodeMapping listItemNodeMapping = (XmlNodeMapping)typeMapping.getNodeMapping(this.getCurrentElementDescriptor());
            listValue.add(this.deserializeElement((QName)listItemNodeMapping.getDataTypeName()));
        } else {
            int childDepth = this.getCurrentDepth() + 1;
            while (this.moveToNextElement(childDepth)) {
                XmlNodeMapping listItemNodeMapping = (XmlNodeMapping)typeMapping.getNodeMapping(this.getCurrentElementDescriptor());
                if (listItemNodeMapping == null) continue;
                listValue.add(this.deserializeElement((QName)listItemNodeMapping.getDataTypeName()));
            }
        }
        return listValue;
    }

    private Map<?, ?> deserializeMapElement(XmlMapTypeMapping typeMapping) {
        Map map = (Map)typeMapping.getObjectAccessor().createObject();
        if (typeMapping.isImplicit()) {
            XmlNodeMapping valueNodeMapping = (XmlNodeMapping)typeMapping.getValueNodeMapping(this.getCurrentElementDescriptor());
            map.put(this.deserializeMapKey(typeMapping), this.deserializeElement((QName)valueNodeMapping.getDataTypeName()));
        } else {
            int childDepth = this.getCurrentDepth() + 1;
            while (this.moveToNextElement(childDepth)) {
                XmlNodeMapping valueNodeMapping = (XmlNodeMapping)typeMapping.getValueNodeMapping(this.getCurrentElementDescriptor());
                if (valueNodeMapping == null) continue;
                map.put(this.deserializeMapKey(typeMapping), this.deserializeElement((QName)valueNodeMapping.getDataTypeName()));
            }
        }
        return map;
    }

    private Object deserializeMapKey(XmlMapTypeMapping typeMapping) {
        ElementStart elementStart = (ElementStart)this.getCurrentXmlItem();
        QName keyName = ((AttributeDescriptor)((AttributeMapping)typeMapping.getKeyNodeMapping()).getNodeDescriptor()).getName();
        for (Attribute attribute : elementStart.getAttributes()) {
            if (!keyName.equals(attribute.getName())) continue;
            XmlSimpleTypeMapping attributeTypeMapping = this.getSimpleTypeMapping((QName)((AttributeMapping)typeMapping.getKeyNodeMapping()).getDataTypeName());
            return attributeTypeMapping.getSimpleTypeConverter().fromString(attribute.getValue());
        }
        throw new DeserializationException("No attribute " + keyName + " serving as key for map entry found");
    }

    private ElementDescriptor getCurrentElementDescriptor() {
        ElementStart elementStart = (ElementStart)this.getCurrentXmlItem();
        return new ElementDescriptor(elementStart.getName(), elementStart.getDataTypeName());
    }

    private String getText() {
        this.moveToNextXmlItem();
        if (this.getCurrentXmlItemType() == XmlItemType.TEXT_CONTENT) {
            return ((TextContent)this.getCurrentXmlItem()).getText();
        }
        return "";
    }

    private void moveToNextXmlItem() {
        this.lowLevelDeserializer.moveToNext();
    }

    private boolean moveToNextElement() {
        while (this.lowLevelDeserializer.hasNext()) {
            this.moveToNextXmlItem();
            if (this.getCurrentXmlItemType() != XmlItemType.ELEMENT_START) continue;
            return true;
        }
        return false;
    }

    private boolean moveToNextElement(int elementDepth) {
        while (this.lowLevelDeserializer.hasNext()) {
            this.moveToNextXmlItem();
            if (this.getCurrentXmlItemType() == XmlItemType.ELEMENT_START) {
                if (this.getCurrentDepth() != elementDepth) continue;
                return true;
            }
            if (this.getCurrentXmlItemType() != XmlItemType.ELEMENT_END || ((ElementEnd)this.getCurrentXmlItem()).getDepth() >= elementDepth) continue;
            return false;
        }
        return false;
    }

    private boolean moveToNextEntryElement() {
        this.currentEntryElementMapping = null;
        while (this.moveToNextElement()) {
            this.currentEntryElementMapping = this.entryElementMappings.get(this.getCurrentElementDescriptor());
            if (this.currentEntryElementMapping == null) continue;
            return true;
        }
        return false;
    }

    private void assertValueIsValid(Object object, XmlNodeMapping nodeMapping) {
        ValidationResult result;
        Validator validator = nodeMapping.getValidator();
        if (validator != null && !(result = validator.validate(object)).isValid()) {
            throw new ValidationException(result);
        }
    }

    private <T extends XmlItem> T getCurrentXmlItem() {
        return (T)this.lowLevelDeserializer.current();
    }

    private XmlItemType getCurrentXmlItemType() {
        return this.lowLevelDeserializer.currentType();
    }

    private int getCurrentDepth() {
        return this.lowLevelDeserializer.currentDepth();
    }

    private XmlSimpleTypeMapping getSimpleTypeMapping(QName dataTypeName) {
        return (XmlSimpleTypeMapping)this.typeMappingRegistry.get(dataTypeName);
    }

    private DeserializationException createException(Exception cause, TypeMapping<?> typeMapping, String fieldName) {
        ObjectPathElement elem = new ObjectPathElement(typeMapping.getObjectType(), fieldName);
        if (cause instanceof DeserializationException) {
            return ((DeserializationException)cause).add(elem);
        }
        return new DeserializationException(cause).setInputPosition(this.getInputPosition()).add(elem);
    }
}

