/*
 * Decompiled with CFR 0.152.
 */
package org.jsefa.xml;

import java.util.HashMap;
import java.util.Map;
import org.jsefa.IOFactoryException;
import org.jsefa.common.mapping.TypeMapping;
import org.jsefa.common.validator.Validator;
import org.jsefa.common.validator.traversal.TraversingValidatorFactory;
import org.jsefa.xml.XmlDeserializer;
import org.jsefa.xml.XmlDeserializerImpl;
import org.jsefa.xml.XmlIOFactory;
import org.jsefa.xml.XmlSerializer;
import org.jsefa.xml.XmlSerializerImpl;
import org.jsefa.xml.config.XmlConfiguration;
import org.jsefa.xml.lowlevel.XmlLowLevelIOFactory;
import org.jsefa.xml.mapping.ElementDescriptor;
import org.jsefa.xml.mapping.ElementMapping;
import org.jsefa.xml.mapping.ElementMappingsBuilder;
import org.jsefa.xml.mapping.XmlEntryPoint;
import org.jsefa.xml.mapping.XmlTypeMappingRegistry;
import org.jsefa.xml.mapping.XmlTypeMappingUtil;
import org.jsefa.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlIOFactoryImpl
extends XmlIOFactory {
    private final XmlConfiguration config;
    private final Map<ElementDescriptor, ElementMapping> entryElementMappingsByElementDescriptor;
    private final Map<Class<?>, ElementMapping> entryElementMappingsByObjectType;
    private final XmlLowLevelIOFactory lowLevelIOFactory;

    public static XmlIOFactory createFactory(XmlConfiguration config) {
        return new XmlIOFactoryImpl(config);
    }

    XmlIOFactoryImpl(XmlConfiguration config) {
        this.config = config;
        this.entryElementMappingsByElementDescriptor = this.createEntryElementMappingsByElementDescriptor();
        this.entryElementMappingsByObjectType = this.createEntryElementMappingsByObjectType();
        this.lowLevelIOFactory = XmlLowLevelIOFactory.createFactory(config.getLowLevelConfiguration());
    }

    @Override
    public XmlSerializer createSerializer() {
        return new XmlSerializerImpl(this.config, this.entryElementMappingsByObjectType, this.lowLevelIOFactory.createSerializer());
    }

    @Override
    public XmlDeserializer createDeserializer() {
        return new XmlDeserializerImpl(this.config, this.entryElementMappingsByElementDescriptor, this.lowLevelIOFactory.createDeserializer());
    }

    private Map<ElementDescriptor, ElementMapping> createEntryElementMappingsByElementDescriptor() {
        ElementMappingsBuilder elementMappingsBuilder = new ElementMappingsBuilder();
        TraversingValidatorFactory deepValidatorFactory = new TraversingValidatorFactory(this.config.getTypeMappingRegistry(), this.config.getObjectAccessorProvider());
        for (XmlEntryPoint entryPoint : this.config.getEntryPoints()) {
            TypeMapping typeMapping = ((XmlTypeMappingRegistry)this.config.getTypeMappingRegistry()).get(entryPoint.getDataTypeName());
            if (typeMapping == null) {
                throw new IOFactoryException("Unknown data type: " + entryPoint.getDataTypeName());
            }
            ElementDescriptor elementDescriptor = new ElementDescriptor((QName)entryPoint.getDesignator(), (QName)entryPoint.getDataTypeName());
            Validator validator = deepValidatorFactory.create(entryPoint.getDataTypeName(), entryPoint.getValidator());
            elementMappingsBuilder.addMapping((QName)entryPoint.getDataTypeName(), elementDescriptor, typeMapping.getObjectType(), null, validator, null);
        }
        return XmlTypeMappingUtil.createNodeMappingsByNodeDescriptorMap(elementMappingsBuilder.getResult());
    }

    private Map<Class<?>, ElementMapping> createEntryElementMappingsByObjectType() {
        HashMap elementMappings = new HashMap();
        for (ElementMapping elementMapping : this.entryElementMappingsByElementDescriptor.values()) {
            elementMappings.put(elementMapping.getObjectType(), elementMapping);
        }
        return elementMappings;
    }
}

