/*
 * Decompiled with CFR 0.152.
 */
package org.jsefa.xml;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsefa.xml.XmlEncodingException;

public final class XmlReaderFactory {
    private static final String UTF_16BE = "UTF-16BE";
    private static final String UTF_16LE = "UTF-16LE";
    private static final String UTF_8 = "UTF-8";
    private static final EncodingPattern[] BOM_PATTERNS = new EncodingPattern[]{new EncodingPattern(new int[]{0, 0, 254, 255}, "UCS-4, big-endian machine", null), new EncodingPattern(new int[]{255, 254, 0, 0}, "UCS-4, little-endian machine", null), new EncodingPattern(new int[]{0, 0, 255, 254}, "UCS-4, unusual octet order (2143)", null), new EncodingPattern(new int[]{254, 255, 0, 0}, "UCS-4, unusual octet order (3412)", null), new EncodingPattern(new int[]{254, 255}, "UTF-16, big-endian", "UTF-16BE"), new EncodingPattern(new int[]{255, 254}, "UTF-16, little-endian", "UTF-16LE"), new EncodingPattern(new int[]{239, 187, 191}, "UTF-8", "UTF-8")};
    private static final EncodingPattern[] CONTENT_PATTERNS = new EncodingPattern[]{new EncodingPattern(new int[]{0, 0, 0, 60}, "32 bit, big-endian", null), new EncodingPattern(new int[]{60, 0, 0, 0}, "32 bit, little-endian", null), new EncodingPattern(new int[]{0, 0, 60, 0}, "32 bit, unusual octet order (2143)", null), new EncodingPattern(new int[]{0, 60, 0, 0}, "32 bit, unusual octet order (3412)", null), new EncodingPattern(new int[]{0, 60, 0, 63}, "16 bit, big-endian", "UTF-16BE"), new EncodingPattern(new int[]{60, 0, 63, 0}, "16 bit, little-endian", "UTF-16LE"), new EncodingPattern(new int[]{60, 63, 120, 109}, "8 bit, ASCII conform", "UTF-8"), new EncodingPattern(new int[]{76, 111, 167, 148}, "8 bit, ASCII conform", null)};
    private static final Pattern XML_DECL_ENCODING_PATTERN = Pattern.compile("<\\?xml.*encoding\\s*=\\s*((?:\"[^\"]*\")|(?:'[^']*')).*\\?>");

    public static Reader create(File file) {
        try {
            return XmlReaderFactory.create(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new XmlEncodingException(e);
        }
    }

    public static Reader create(InputStream inputStream) {
        PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream, 128);
        String encodingFamily = XmlReaderFactory.getEncodingFamily(BOM_PATTERNS, pushbackInputStream);
        if (encodingFamily == null) {
            encodingFamily = XmlReaderFactory.getEncodingFamily(CONTENT_PATTERNS, pushbackInputStream);
        }
        String encoding = null;
        if (encodingFamily == null) {
            encoding = UTF_8;
        } else {
            encoding = XmlReaderFactory.getEncodingFromXmlDecl(pushbackInputStream, encodingFamily);
            if (encoding == null) {
                encoding = encodingFamily;
            }
        }
        try {
            return new InputStreamReader((InputStream)pushbackInputStream, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new XmlEncodingException(e);
        }
    }

    private static String getEncodingFamily(EncodingPattern[] patterns, PushbackInputStream inputStream) {
        byte[] buffer = XmlReaderFactory.readBytesAhead(inputStream, 4);
        for (int i = 0; i < patterns.length; ++i) {
            if (!patterns[i].matches(buffer)) continue;
            if (patterns[i].encodingFamily == null) {
                throw new XmlEncodingException("Unsupported: " + patterns[i].getDescription());
            }
            return patterns[i].getEncodingFamily();
        }
        return null;
    }

    private static String getEncodingFromXmlDecl(PushbackInputStream inputStream, String encodingFamily) {
        String content = XmlReaderFactory.readStringAhead(inputStream, 128, encodingFamily);
        Matcher m = XML_DECL_ENCODING_PATTERN.matcher(content);
        if (m.find()) {
            String encoding = m.group(1).toUpperCase();
            return encoding.substring(1, encoding.length() - 1);
        }
        return null;
    }

    private static String readStringAhead(PushbackInputStream inputStream, int lengthInBytes, String encoding) {
        byte[] bytes = XmlReaderFactory.readBytesAhead(inputStream, lengthInBytes);
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(bytes, 0, lengthInBytes), encoding));
            StringBuilder result = new StringBuilder();
            String line = reader.readLine();
            while (line != null) {
                result.append(line);
                result.append("\n");
                line = reader.readLine();
            }
            reader.close();
            return result.toString();
        }
        catch (IOException e) {
            throw new XmlEncodingException(e);
        }
    }

    private static byte[] readBytesAhead(PushbackInputStream inputStream, int size) {
        byte[] buffer = new byte[size];
        int bytesLeft = size;
        int totalBytesRead = 0;
        try {
            int bytesRead = inputStream.read(buffer, totalBytesRead, bytesLeft);
            while (bytesRead != -1 && bytesLeft > 0) {
                bytesRead = inputStream.read(buffer, totalBytesRead += bytesRead, bytesLeft -= bytesRead);
            }
            if (totalBytesRead > 0) {
                inputStream.unread(buffer, 0, totalBytesRead);
            }
            return buffer;
        }
        catch (IOException e) {
            throw new XmlEncodingException(e);
        }
    }

    private XmlReaderFactory() {
    }

    private static final class EncodingPattern {
        private int[] pattern;
        private String description;
        private String encodingFamily;

        public EncodingPattern(int[] pattern, String description, String encodingFamily) {
            this.pattern = pattern;
            this.description = description;
            this.encodingFamily = encodingFamily;
        }

        public boolean matches(byte[] input) {
            for (int i = 0; i < this.pattern.length; ++i) {
                if (this.pattern[i] == (input[i] & 0xFF)) continue;
                return false;
            }
            return true;
        }

        public String getDescription() {
            return this.description;
        }

        public String getEncodingFamily() {
            return this.encodingFamily;
        }
    }
}

