/*
 * Decompiled with CFR 0.152.
 */
package org.jsefa.xml.annotation;

import java.util.Collection;
import java.util.HashMap;
import org.jsefa.common.annotation.ValidatorFactory;
import org.jsefa.common.validator.Validator;
import org.jsefa.xml.annotation.NamespaceManagerFactory;
import org.jsefa.xml.annotation.XmlDataType;
import org.jsefa.xml.annotation.XmlTypeMappingFactory;
import org.jsefa.xml.mapping.XmlEntryPoint;
import org.jsefa.xml.mapping.XmlTypeMappingRegistry;
import org.jsefa.xml.namespace.NamespaceManager;
import org.jsefa.xml.namespace.QName;
import org.jsefa.xml.namespace.QNameParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XmlEntryPointFactory {
    private final XmlTypeMappingFactory typeMappingFactory;
    private final ValidatorFactory validatorFactory;

    public XmlEntryPointFactory(XmlTypeMappingFactory typeMappingFactory, ValidatorFactory validatorFactory) {
        this.typeMappingFactory = typeMappingFactory;
        this.validatorFactory = validatorFactory;
    }

    public Collection<XmlEntryPoint> createEntryPoints(Class<?> ... objectTypes) {
        HashMap entryPoints = new HashMap();
        XmlTypeMappingRegistry registry = (XmlTypeMappingRegistry)this.typeMappingFactory.getTypeMappingRegistry();
        for (Class<?> rootObjectType : objectTypes) {
            Object rootDataTypeName = this.typeMappingFactory.createIfAbsent((Class)rootObjectType);
            QName elementName = this.getAnnotatedElementName(rootObjectType, rootObjectType.getSimpleName());
            for (QName qName : registry.getDataTypeNameTreeElements(rootDataTypeName)) {
                Class<?> objectType = registry.get(qName).getObjectType();
                Validator validator = this.validatorFactory.createContextualValidator(objectType, null, null, XmlDataType.class);
                entryPoints.put(objectType, new XmlEntryPoint(qName, elementName, validator));
            }
        }
        return entryPoints.values();
    }

    private QName getAnnotatedElementName(Class<?> objectType, String defaultName) {
        NamespaceManager namespaceManager = NamespaceManagerFactory.create(objectType);
        String name = null;
        if (objectType.isAnnotationPresent(XmlDataType.class)) {
            name = objectType.getAnnotation(XmlDataType.class).defaultElementName();
        }
        if (name != null && name.length() != 0) {
            return QNameParser.parse(name, true, namespaceManager);
        }
        return QNameParser.parse(defaultName, true, namespaceManager);
    }
}

