/*
 * Decompiled with CFR 0.152.
 */
package org.jsefa.xml.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jsefa.common.accessor.ObjectAccessorProvider;
import org.jsefa.common.annotation.AnnotatedFieldsProvider;
import org.jsefa.common.annotation.AnnotationDataProvider;
import org.jsefa.common.annotation.AnnotationException;
import org.jsefa.common.annotation.TypeMappingFactory;
import org.jsefa.common.converter.SimpleTypeConverter;
import org.jsefa.common.converter.provider.SimpleTypeConverterProvider;
import org.jsefa.common.mapping.FieldDescriptor;
import org.jsefa.common.mapping.TypeMapping;
import org.jsefa.common.mapping.TypeMappingException;
import org.jsefa.common.validator.Validator;
import org.jsefa.common.validator.provider.ValidatorProvider;
import org.jsefa.xml.annotation.DefaultName;
import org.jsefa.xml.annotation.ListItem;
import org.jsefa.xml.annotation.NamespaceManagerFactory;
import org.jsefa.xml.annotation.XmlAttribute;
import org.jsefa.xml.annotation.XmlDataType;
import org.jsefa.xml.annotation.XmlElement;
import org.jsefa.xml.annotation.XmlElementList;
import org.jsefa.xml.annotation.XmlElementMap;
import org.jsefa.xml.annotation.XmlTextContent;
import org.jsefa.xml.lowlevel.TextMode;
import org.jsefa.xml.mapping.AttributeDescriptor;
import org.jsefa.xml.mapping.AttributeMapping;
import org.jsefa.xml.mapping.ElementDescriptor;
import org.jsefa.xml.mapping.ElementMapping;
import org.jsefa.xml.mapping.ElementMappingsBuilder;
import org.jsefa.xml.mapping.TextContentDescriptor;
import org.jsefa.xml.mapping.TextContentMapping;
import org.jsefa.xml.mapping.XmlComplexTypeMapping;
import org.jsefa.xml.mapping.XmlListTypeMapping;
import org.jsefa.xml.mapping.XmlMapTypeMapping;
import org.jsefa.xml.mapping.XmlSimpleTypeMapping;
import org.jsefa.xml.mapping.XmlTypeMappingRegistry;
import org.jsefa.xml.mapping.support.XmlDataTypeDefaultNameRegistry;
import org.jsefa.xml.namespace.NamespaceManager;
import org.jsefa.xml.namespace.QName;
import org.jsefa.xml.namespace.QNameParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XmlTypeMappingFactory
extends TypeMappingFactory<QName, XmlTypeMappingRegistry> {
    private static final String DEFAULT_DATA_TYPE_NAMES_URI = "http://www.jsefa.org/xml/types/defaults/object-types";
    private XmlDataTypeDefaultNameRegistry dataTypeDefaultNameRegistry;

    public XmlTypeMappingFactory(XmlTypeMappingRegistry typeMappingRegistry, SimpleTypeConverterProvider simpleTypeConverterProvider, ValidatorProvider validatorProvider, ObjectAccessorProvider objectAccessorProvider, XmlDataTypeDefaultNameRegistry dataTypeDefaultNameRegistry) {
        super(typeMappingRegistry, simpleTypeConverterProvider, validatorProvider, objectAccessorProvider);
        this.dataTypeDefaultNameRegistry = dataTypeDefaultNameRegistry;
    }

    @Override
    public QName createIfAbsent(Class<?> objectType) {
        return this.createIfAbsent(objectType, null, null);
    }

    @Override
    protected QName getAnnotatedDataTypeName(Annotation annotation, Class<?> annotationContextClass) {
        return this.getAnnotatedDataTypeName(annotation, NamespaceManagerFactory.create(annotationContextClass));
    }

    private QName createIfAbsent(Class<?> objectType, Field field, Annotation annotation) {
        if (this.hasSimpleType(objectType)) {
            return this.createSimpleTypeMappingIfAbsent(objectType, field, annotation);
        }
        if (this.hasComplexType(objectType)) {
            return this.createComplexTypeMappingIfAbsent(objectType);
        }
        throw new TypeMappingException("Unknown data type for class " + objectType.getName());
    }

    private QName createSimpleTypeMappingIfAbsent(Class<?> objectType, Field field, Annotation annotation) {
        QName dataTypeName = this.createSimpleDataTypeName(objectType, field, annotation);
        if (this.prepareToCreate(objectType, dataTypeName)) {
            SimpleTypeConverter converter = this.createSimpleTypeConverter(objectType, field, annotation);
            ((XmlTypeMappingRegistry)this.getTypeMappingRegistry()).register(new XmlSimpleTypeMapping(dataTypeName, objectType, converter));
        }
        return dataTypeName;
    }

    private QName createComplexTypeMappingIfAbsent(Class<?> objectType) {
        NamespaceManager namespaceManager = NamespaceManagerFactory.create(objectType);
        QName dataTypeName = this.createComplexDataTypeName(objectType, namespaceManager);
        if (this.prepareToCreate(objectType, dataTypeName)) {
            for (Class<?> subObjectType : objectType.getAnnotation(XmlDataType.class).subObjectTypes()) {
                QName subDataTypeName = this.createComplexDataTypeName(subObjectType, NamespaceManagerFactory.create(subObjectType));
                ((XmlTypeMappingRegistry)this.getTypeMappingRegistry()).registerSubtypeRelation(dataTypeName, subDataTypeName);
            }
            for (Class<?> subObjectType : objectType.getAnnotation(XmlDataType.class).subObjectTypes()) {
                this.createComplexTypeMappingIfAbsent(subObjectType);
            }
            ArrayList nodeMappings = new ArrayList();
            nodeMappings.addAll(this.createAttributeMappings(objectType, namespaceManager));
            TextContentMapping textContentMapping = this.createTextContentMapping(objectType);
            if (textContentMapping != null) {
                nodeMappings.add(textContentMapping);
            }
            nodeMappings.addAll(this.createElementMappings(objectType, namespaceManager));
            Validator validator = this.getValidatorFactory().createValidator(objectType, XmlElement.class, XmlElementList.class, XmlElementMap.class, XmlTextContent.class, XmlAttribute.class);
            XmlComplexTypeMapping mapping = new XmlComplexTypeMapping(objectType, dataTypeName, this.getObjectAccessorProvider().get(objectType), nodeMappings, validator);
            ((XmlTypeMappingRegistry)this.getTypeMappingRegistry()).register(mapping);
        }
        return dataTypeName;
    }

    private QName createListTypeMappingIfAbsent(Field field, NamespaceManager namespaceManager) {
        QName dataTypeName = this.createCollectionDataTypeName(field);
        if (this.prepareToCreate(Collection.class, dataTypeName)) {
            XmlElementList xmlElementList = field.getAnnotation(XmlElementList.class);
            if (xmlElementList == null || xmlElementList.items().length == 0) {
                throw new AnnotationException("No XmlElementList annotation with proper content found");
            }
            ElementMappingsBuilder elementMappingsBuilder = new ElementMappingsBuilder();
            this.addElementMappingsForCollectionItemsOrMapValues(elementMappingsBuilder, field, null, xmlElementList.items(), namespaceManager);
            XmlListTypeMapping listMapping = new XmlListTypeMapping(dataTypeName, xmlElementList.implicit(), elementMappingsBuilder.getResult(), this.getObjectAccessorProvider().get(field.getType()));
            ((XmlTypeMappingRegistry)this.getTypeMappingRegistry()).register(listMapping);
        }
        return dataTypeName;
    }

    private QName createMapTypeMappingIfAbsent(Field field, NamespaceManager namespaceManager) {
        QName dataTypeName = this.createMapDataTypeName(field);
        if (this.prepareToCreate(Map.class, dataTypeName)) {
            XmlElementMap xmlElementMap = field.getAnnotation(XmlElementMap.class);
            if (xmlElementMap == null || xmlElementMap.values().length == 0) {
                throw new AnnotationException("No XmlElementMap annotation with proper content found");
            }
            AttributeMapping mapKeyMapping = this.createAttributeMapping(this.createForMapKeyIfAbsent(field, xmlElementMap.key(), namespaceManager), field, xmlElementMap.key(), namespaceManager);
            ElementMappingsBuilder elementMappingsBuilder = new ElementMappingsBuilder();
            this.addElementMappingsForCollectionItemsOrMapValues(elementMappingsBuilder, field, null, xmlElementMap.values(), namespaceManager);
            XmlMapTypeMapping mapMapping = new XmlMapTypeMapping(dataTypeName, xmlElementMap.implicit(), mapKeyMapping, elementMappingsBuilder.getResult(), this.getObjectAccessorProvider().get(field.getType()));
            ((XmlTypeMappingRegistry)this.getTypeMappingRegistry()).register(mapMapping);
        }
        return dataTypeName;
    }

    private Collection<AttributeMapping> createAttributeMappings(Class<?> objectType, NamespaceManager namespaceManager) {
        ArrayList<AttributeMapping> result = new ArrayList<AttributeMapping>();
        for (Field field : AnnotatedFieldsProvider.getAnnotatedFields(objectType, XmlAttribute.class)) {
            XmlAttribute xmlAttribute = field.getAnnotation(XmlAttribute.class);
            QName dataTypeName = this.getAnnotatedDataTypeName((Annotation)xmlAttribute, namespaceManager);
            if (dataTypeName == null) {
                dataTypeName = this.createSimpleTypeMappingIfAbsent(field.getType(), field, xmlAttribute);
            } else {
                this.assertTypeMappingExists(dataTypeName);
            }
            result.add(this.createAttributeMapping(dataTypeName, field, xmlAttribute, namespaceManager));
        }
        return result;
    }

    private AttributeMapping createAttributeMapping(QName dataTypeName, Field field, Annotation annotation, NamespaceManager namespaceManager) {
        AttributeDescriptor attributeDescriptor = this.createAttributeDescriptor(annotation, field.getName(), namespaceManager);
        Class<?> normalizedObjectType = ((XmlTypeMappingRegistry)this.getTypeMappingRegistry()).get(dataTypeName).getObjectType();
        AttributeMapping attributeMapping = new AttributeMapping(dataTypeName, attributeDescriptor, normalizedObjectType, new FieldDescriptor(field.getName(), this.getNormalizedFieldType(field, dataTypeName)), this.getValidatorFactory().createContextualValidator(normalizedObjectType, field, annotation, XmlDataType.class));
        return attributeMapping;
    }

    private TextContentMapping createTextContentMapping(Class<?> objectType) {
        TextContentMapping textContentMapping = null;
        Field textContentField = this.getTextContentField(objectType);
        if (textContentField != null) {
            if (AnnotatedFieldsProvider.getSortedAnnotatedFields(objectType, XmlElement.class, XmlElementList.class, XmlElementMap.class).size() > 0) {
                throw new AnnotationException("No element declarations allowed if a text content declaration exists");
            }
            XmlTextContent xmlTextContent = textContentField.getAnnotation(XmlTextContent.class);
            QName fieldDataTypeName = this.createSimpleTypeMappingIfAbsent(textContentField.getType(), textContentField, xmlTextContent);
            TextContentDescriptor textContentDescriptor = TextContentDescriptor.getInstance();
            TextMode textMode = this.getTextModeFromField(textContentField);
            Class<?> normalizedObjectType = ((XmlTypeMappingRegistry)this.getTypeMappingRegistry()).get(fieldDataTypeName).getObjectType();
            textContentMapping = new TextContentMapping(fieldDataTypeName, textContentDescriptor, new FieldDescriptor(textContentField.getName(), normalizedObjectType), this.getValidatorFactory().createContextualValidator(normalizedObjectType, textContentField, xmlTextContent, XmlDataType.class), textMode);
        }
        return textContentMapping;
    }

    private Collection<ElementMapping> createElementMappings(Class<?> objectType, NamespaceManager namespaceManager) {
        ElementMappingsBuilder elementMappingsBuilder = new ElementMappingsBuilder();
        for (Field field : AnnotatedFieldsProvider.getSortedAnnotatedFields(objectType, XmlElement.class, XmlElementList.class, XmlElementMap.class)) {
            QName fieldDataTypeName;
            if (this.hasCollectionType(field.getType()) && field.getAnnotation(XmlElementList.class) != null) {
                fieldDataTypeName = this.createListTypeMappingIfAbsent(field, namespaceManager);
                this.addElementMappingsForElementList(field, fieldDataTypeName, namespaceManager, elementMappingsBuilder);
                continue;
            }
            if (this.hasMapType(field.getType()) && field.getAnnotation(XmlElementMap.class) != null) {
                fieldDataTypeName = this.createMapTypeMappingIfAbsent(field, namespaceManager);
                this.addElementMappingsForElementMap(field, fieldDataTypeName, namespaceManager, elementMappingsBuilder);
                continue;
            }
            if (this.hasComplexType(field.getType())) {
                fieldDataTypeName = this.getAnnotatedDataTypeName((Annotation)field.getAnnotation(XmlElement.class), namespaceManager);
                if (fieldDataTypeName == null) {
                    fieldDataTypeName = this.createComplexTypeMappingIfAbsent(field.getType());
                } else {
                    this.assertTypeMappingExists(fieldDataTypeName);
                }
                this.addElementMappingsForElement(field, fieldDataTypeName, namespaceManager, elementMappingsBuilder);
                continue;
            }
            XmlElement xmlElement = field.getAnnotation(XmlElement.class);
            QName fieldDataTypeName2 = this.getAnnotatedDataTypeName((Annotation)xmlElement, namespaceManager);
            if (fieldDataTypeName2 == null) {
                fieldDataTypeName2 = this.createSimpleTypeMappingIfAbsent(field.getType(), field, xmlElement);
            } else {
                this.assertTypeMappingExists(fieldDataTypeName2);
            }
            this.addElementMappingsForElement(field, fieldDataTypeName2, namespaceManager, elementMappingsBuilder);
        }
        return elementMappingsBuilder.getResult();
    }

    private void addElementMappingsForElement(Field field, QName fieldDataTypeName, NamespaceManager namespaceManager, ElementMappingsBuilder elementMappingsBuilder) {
        XmlElement xmlElement = field.getAnnotation(XmlElement.class);
        for (QName subDataTypeName : ((XmlTypeMappingRegistry)this.getTypeMappingRegistry()).getDataTypeNameTreeElements(fieldDataTypeName)) {
            Class<?> subObjectType = this.getSubObjectType(field.getType(), subDataTypeName);
            ElementDescriptor elementDescriptor = this.createElementDescriptor(field, subObjectType, subDataTypeName, namespaceManager);
            elementMappingsBuilder.addMapping(subDataTypeName, elementDescriptor, new FieldDescriptor(field.getName(), subObjectType), this.getValidatorFactory().createContextualValidator(subObjectType, field, xmlElement, XmlDataType.class), this.getTextModeFromField(field));
        }
    }

    private void addElementMappingsForElementList(Field field, QName fieldDataTypeName, NamespaceManager namespaceManager, ElementMappingsBuilder elementMappingsBuilder) {
        XmlElementList xmlElementList = field.getAnnotation(XmlElementList.class);
        if (xmlElementList.implicit()) {
            this.addElementMappingsForCollectionItemsOrMapValues(elementMappingsBuilder, field, fieldDataTypeName, xmlElementList.items(), namespaceManager);
        }
        ElementDescriptor elementDescriptor = xmlElementList.implicit() ? new ElementDescriptor(null, fieldDataTypeName) : this.createElementDescriptor(field, field.getDeclaringClass(), fieldDataTypeName, namespaceManager);
        elementMappingsBuilder.addMapping(fieldDataTypeName, elementDescriptor, new FieldDescriptor(field.getName(), Collection.class), this.getValidatorFactory().createContextualValidator(Collection.class, field, xmlElementList, XmlDataType.class), this.getTextModeFromField(field));
    }

    private void addElementMappingsForElementMap(Field field, QName fieldDataTypeName, NamespaceManager namespaceManager, ElementMappingsBuilder elementMappingsBuilder) {
        XmlElementMap xmlElementMap = field.getAnnotation(XmlElementMap.class);
        if (xmlElementMap.implicit()) {
            this.addElementMappingsForCollectionItemsOrMapValues(elementMappingsBuilder, field, fieldDataTypeName, xmlElementMap.values(), namespaceManager);
        }
        ElementDescriptor elementDescriptor = xmlElementMap.implicit() ? new ElementDescriptor(null, fieldDataTypeName) : this.createElementDescriptor(field, field.getDeclaringClass(), fieldDataTypeName, namespaceManager);
        elementMappingsBuilder.addMapping(fieldDataTypeName, elementDescriptor, new FieldDescriptor(field.getName(), Map.class), this.getValidatorFactory().createContextualValidator(Map.class, field, xmlElementMap, XmlDataType.class), this.getTextModeFromField(field));
    }

    private void addElementMappingsForCollectionItemsOrMapValues(ElementMappingsBuilder elementMappingsBuilder, Field field, QName fieldDataTypeName, Annotation[] annotations, NamespaceManager namespaceManager) {
        HashSet objectTypes = new HashSet();
        for (Annotation annotation : this.order(annotations)) {
            QName dataTypeName = this.createForCollectionItemOrMapValueIfAbsent(field, annotation, annotations.length, namespaceManager);
            for (QName subDataTypeName : ((XmlTypeMappingRegistry)this.getTypeMappingRegistry()).getDataTypeNameTreeElements(dataTypeName)) {
                Class<?> subObjectType = this.getSubObjectType(((XmlTypeMappingRegistry)this.getTypeMappingRegistry()).get(dataTypeName).getObjectType(), subDataTypeName);
                if (objectTypes.contains(subObjectType)) continue;
                objectTypes.add(subObjectType);
                ElementDescriptor elementDescriptor = this.createElementDescriptor(annotation, subDataTypeName, namespaceManager);
                elementMappingsBuilder.addMapping(fieldDataTypeName != null ? fieldDataTypeName : subDataTypeName, elementDescriptor, subObjectType, new FieldDescriptor(field.getName(), this.getNormalizedFieldType(field, null)), this.getValidatorFactory().createContextualValidator(subObjectType, field, annotation, XmlDataType.class), (TextMode)((Object)AnnotationDataProvider.get(annotation, "textMode")));
            }
        }
    }

    private Class<?> getSubObjectType(Class<?> objectType, QName subDataTypeName) {
        if (((XmlTypeMappingRegistry)this.getTypeMappingRegistry()).get(subDataTypeName) != null) {
            return ((XmlTypeMappingRegistry)this.getTypeMappingRegistry()).get(subDataTypeName).getObjectType();
        }
        for (Class<?> subObjectType : objectType.getAnnotation(XmlDataType.class).subObjectTypes()) {
            if (!subDataTypeName.equals(this.createComplexDataTypeName(subObjectType, NamespaceManagerFactory.create(subObjectType)))) continue;
            return subObjectType;
        }
        throw new TypeMappingException("Unknown data type name: " + subDataTypeName);
    }

    private QName createForMapKeyIfAbsent(Field field, Annotation annotation, NamespaceManager namespaceManager) {
        QName dataTypeName = this.getAnnotatedDataTypeName(annotation, namespaceManager);
        if (dataTypeName != null) {
            this.assertTypeMappingIsSimple(dataTypeName);
            return dataTypeName;
        }
        Class<?> objectType = this.getMapKeyType(annotation, field);
        if (objectType == null) {
            throw new AnnotationException("Object type not determinable for map key of field: " + field.getName() + " of class " + field.getDeclaringClass().getName());
        }
        if (!this.hasSimpleType(objectType)) {
            throw new AnnotationException("Object type must be simple for map key of field:" + field.getName() + " of class " + field.getDeclaringClass().getName());
        }
        return this.createSimpleTypeMappingIfAbsent(objectType, field, annotation);
    }

    private QName createForCollectionItemOrMapValueIfAbsent(Field field, Annotation annotation, int itemOrValueCount, NamespaceManager namespaceManager) {
        QName dataTypeName = this.getAnnotatedDataTypeName(annotation, namespaceManager);
        if (dataTypeName != null) {
            this.assertTypeMappingExists(dataTypeName);
        } else {
            Class<?> objectType;
            boolean singleType = itemOrValueCount == 1;
            Class<?> clazz = objectType = this.hasMapType(field.getType()) ? this.getMapValueType(annotation, field, singleType) : this.getCollectionItemType(annotation, field, singleType);
            if (objectType == null) {
                throw new AnnotationException("Object type not determinable for collection item or map value of field: " + field.getName() + " of class " + field.getDeclaringClass().getName());
            }
            dataTypeName = this.createIfAbsent(objectType, field, annotation);
        }
        TypeMapping<QName> typeMapping = ((XmlTypeMappingRegistry)this.getTypeMappingRegistry()).get(dataTypeName);
        if (typeMapping instanceof XmlListTypeMapping && ((XmlListTypeMapping)typeMapping).isImplicit()) {
            throw new AnnotationException("No implicit lists inside lists or maps allowed");
        }
        if (typeMapping instanceof XmlMapTypeMapping && ((XmlMapTypeMapping)typeMapping).isImplicit()) {
            throw new AnnotationException("No implicit maps inside lists or maps allowed");
        }
        return dataTypeName;
    }

    private boolean hasComplexType(Class<?> objectType) {
        return objectType.getAnnotation(XmlDataType.class) != null;
    }

    private AttributeDescriptor createAttributeDescriptor(Annotation annotation, String defaultName, NamespaceManager namespaceManager) {
        QName name = QNameParser.parse(this.getAnnotatedName(annotation, defaultName), false, namespaceManager);
        return new AttributeDescriptor(name);
    }

    private ElementDescriptor createElementDescriptor(Field field, Class<?> objectType, QName dataTypeName, NamespaceManager namespaceManager) {
        QName name = null;
        String annotatedName = this.getAnnotatedName(field, null);
        if (annotatedName != null) {
            name = QNameParser.parse(annotatedName, true, namespaceManager);
        } else if (AnnotationDataProvider.get(field, "defaultName", XmlElement.class) == DefaultName.TYPE_DEFAULT_NAME && objectType.isAnnotationPresent(XmlDataType.class)) {
            name = QNameParser.parse(objectType.getAnnotation(XmlDataType.class).defaultElementName(), true, NamespaceManagerFactory.create(objectType));
        }
        if (name == null) {
            name = QNameParser.parse(field.getName(), true, namespaceManager);
        }
        return new ElementDescriptor(name, dataTypeName);
    }

    private ElementDescriptor createElementDescriptor(Annotation annotation, QName dataTypeName, NamespaceManager namespaceManager) {
        QName name = QNameParser.parse(this.getAnnotatedName(annotation, null), true, namespaceManager);
        return new ElementDescriptor(name, dataTypeName);
    }

    private Field getTextContentField(Class<?> objectType) {
        List<Field> result = AnnotatedFieldsProvider.getAnnotatedFields(objectType, XmlTextContent.class);
        if (result.size() > 1) {
            throw new AnnotationException("Only one XmlTextContent annotation allowed");
        }
        if (result.size() == 0) {
            return null;
        }
        return result.get(0);
    }

    private QName createSimpleDataTypeName(Class<?> objectType, Field field, Annotation annotation) {
        if ((annotation == null || AnnotationDataProvider.get(annotation, "format") == null && AnnotationDataProvider.get(annotation, "converterType") == null) && !this.hasCollectionType(objectType)) {
            QName name = this.dataTypeDefaultNameRegistry.get(objectType);
            if (name == null) {
                name = QName.create(DEFAULT_DATA_TYPE_NAMES_URI, objectType.getName());
            }
            return name;
        }
        String localName = objectType.getName() + "@" + field.getName() + "@" + field.getDeclaringClass().getName();
        return QName.create(DEFAULT_DATA_TYPE_NAMES_URI, localName);
    }

    private QName createComplexDataTypeName(Class<?> objectType, NamespaceManager namespaceManager) {
        String nameStr = (String)AnnotationDataProvider.get(objectType, "name", XmlDataType.class);
        if (nameStr != null) {
            return QNameParser.parse(nameStr, true, namespaceManager);
        }
        QName name = this.dataTypeDefaultNameRegistry.get(objectType);
        if (name == null) {
            name = QName.create(DEFAULT_DATA_TYPE_NAMES_URI, objectType.getName());
        }
        return name;
    }

    private QName createCollectionDataTypeName(Field field) {
        String localName = field.getName() + "@" + field.getDeclaringClass().getName();
        return QName.create(DEFAULT_DATA_TYPE_NAMES_URI, localName);
    }

    private QName createMapDataTypeName(Field field) {
        String localName = field.getName() + "@" + field.getDeclaringClass().getName();
        return QName.create(DEFAULT_DATA_TYPE_NAMES_URI, localName);
    }

    private String getAnnotatedName(AnnotatedElement annotatedElement, String defaultName) {
        String name = (String)AnnotationDataProvider.get(annotatedElement, "name", XmlElement.class, XmlAttribute.class, XmlElementList.class, XmlElementMap.class);
        if (name != null) {
            return name;
        }
        return defaultName;
    }

    private String getAnnotatedName(Annotation annotation, String defaultName) {
        if (annotation != null && AnnotationDataProvider.get(annotation, "name") != null) {
            return (String)AnnotationDataProvider.get(annotation, "name");
        }
        return defaultName;
    }

    private QName getAnnotatedDataTypeName(Annotation annotation, NamespaceManager namespaceManager) {
        if (annotation != null && AnnotationDataProvider.get(annotation, "dataTypeName") != null) {
            return QNameParser.parse((String)AnnotationDataProvider.get(annotation, "dataTypeName"), true, namespaceManager);
        }
        return null;
    }

    private TextMode getTextModeFromField(Field field) {
        return (TextMode)((Object)AnnotationDataProvider.get(field, "textMode", XmlElement.class, XmlTextContent.class, ListItem.class));
    }

    private <T extends Annotation> List<T> order(T[] items) {
        ArrayList<Annotation> result = new ArrayList<Annotation>();
        ArrayList<T> remainingItems = new ArrayList<T>(Arrays.asList(items));
        block0: while (!remainingItems.isEmpty()) {
            for (Annotation item : remainingItems) {
                if (this.hasSuperTypeOfAny(item, remainingItems)) continue;
                result.add(item);
                remainingItems.remove(item);
                continue block0;
            }
        }
        return result;
    }

    private <T extends Annotation> boolean hasSuperTypeOfAny(T item, List<T> listItems) {
        for (Annotation innerItem : listItems) {
            Class innerItemObjectType;
            Class itemObjectType;
            if (item == innerItem || !(itemObjectType = (Class)AnnotationDataProvider.get(item, "objectType")).isAssignableFrom(innerItemObjectType = (Class)AnnotationDataProvider.get(innerItem, "objectType"))) continue;
            return true;
        }
        return false;
    }

    private Class<?> getNormalizedFieldType(Field field, QName dataTypeName) {
        if (this.hasMapType(field.getType())) {
            return Map.class;
        }
        if (this.hasCollectionType(field.getType())) {
            return Collection.class;
        }
        if (dataTypeName != null) {
            return ((XmlTypeMappingRegistry)this.getTypeMappingRegistry()).get(dataTypeName).getObjectType();
        }
        return field.getType();
    }
}

