/*
 * Decompiled with CFR 0.152.
 */
package org.jsefa.xml.config;

import org.jsefa.common.config.Configuration;
import org.jsefa.common.config.InitialConfiguration;
import org.jsefa.common.util.OnDemandObjectProvider;
import org.jsefa.xml.lowlevel.config.XmlLowLevelConfiguration;
import org.jsefa.xml.mapping.XmlEntryPoint;
import org.jsefa.xml.mapping.XmlTypeMappingRegistry;
import org.jsefa.xml.mapping.support.XmlDataTypeDefaultNameRegistry;
import org.jsefa.xml.mapping.support.XmlSchemaBuiltInDataTypeNames;
import org.jsefa.xml.namespace.NamespaceManager;
import org.jsefa.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XmlConfiguration
extends Configuration<XmlTypeMappingRegistry, XmlEntryPoint> {
    private XmlDataTypeDefaultNameRegistry dataTypeDefaultNameRegistry;
    private XmlLowLevelConfiguration lowLevelConfiguration;

    public XmlConfiguration() {
    }

    private XmlConfiguration(XmlConfiguration other) {
        super(other);
        this.setDataTypeDefaultNameRegistry(other.getDataTypeDefaultNameRegistry().createCopy());
        this.setLowLevelConfiguration(other.getLowLevelConfiguration().createCopy());
    }

    public XmlConfiguration createCopy() {
        return new XmlConfiguration(this);
    }

    public XmlDataTypeDefaultNameRegistry getDataTypeDefaultNameRegistry() {
        if (this.dataTypeDefaultNameRegistry == null) {
            XmlDataTypeDefaultNameRegistry initialRegistry = (XmlDataTypeDefaultNameRegistry)InitialConfiguration.get("jsefa:xml:dataTypeDefaultNameRegistry", Defaults.DEFAULT_DATA_TYPE_DEFAULT_NAME_REGISTRY_PROVIDER);
            this.dataTypeDefaultNameRegistry = initialRegistry.createCopy();
        }
        return this.dataTypeDefaultNameRegistry;
    }

    public XmlLowLevelConfiguration getLowLevelConfiguration() {
        if (this.lowLevelConfiguration == null) {
            this.lowLevelConfiguration = new XmlLowLevelConfiguration();
        }
        return this.lowLevelConfiguration;
    }

    public void setLowLevelConfiguration(XmlLowLevelConfiguration lowLevelConfig) {
        this.lowLevelConfiguration = lowLevelConfig;
    }

    public NamespaceManager getNamespaceManager() {
        return this.getLowLevelConfiguration().getNamespaceManager();
    }

    public QName getDataTypeAttributeName() {
        return this.getLowLevelConfiguration().getDataTypeAttributeName();
    }

    public String getLineBreak() {
        return this.getLowLevelConfiguration().getLineBreak();
    }

    public String getLineIndentation() {
        return this.getLowLevelConfiguration().getLineIndentation();
    }

    public void setDataTypeDefaultNameRegistry(XmlDataTypeDefaultNameRegistry dataTypeDefaultNameRegistry) {
        this.dataTypeDefaultNameRegistry = dataTypeDefaultNameRegistry;
    }

    public void setNamespaceManager(NamespaceManager namespaceManager) {
        this.getLowLevelConfiguration().setNamespaceManager(namespaceManager);
    }

    public void setDataTypeAttributeName(QName dataTypeAttributeName) {
        this.getLowLevelConfiguration().setDataTypeAttributeName(dataTypeAttributeName);
    }

    public void setLineIndentation(String lineIndentation) {
        this.getLowLevelConfiguration().setLineIndentation(lineIndentation);
    }

    public void setLineBreak(String lineBreak) {
        this.getLowLevelConfiguration().setLineBreak(lineBreak);
    }

    @Override
    protected XmlTypeMappingRegistry createDefaultTypeMappingRegistry() {
        return new XmlTypeMappingRegistry();
    }

    public static interface Defaults {
        public static final OnDemandObjectProvider DEFAULT_DATA_TYPE_DEFAULT_NAME_REGISTRY_PROVIDER = new OnDemandObjectProvider(){

            public XmlDataTypeDefaultNameRegistry get() {
                XmlDataTypeDefaultNameRegistry registry = new XmlDataTypeDefaultNameRegistry();
                registry.register(String.class, XmlSchemaBuiltInDataTypeNames.STRING_DATA_TYPE_NAME);
                registry.register(Integer.TYPE, XmlSchemaBuiltInDataTypeNames.INT_DATA_TYPE_NAME);
                registry.register(Integer.class, XmlSchemaBuiltInDataTypeNames.INTEGER_DATA_TYPE_NAME);
                registry.register(Long.TYPE, XmlSchemaBuiltInDataTypeNames.LONG_DATA_TYPE_NAME);
                registry.register(Long.class, XmlSchemaBuiltInDataTypeNames.LONG_DATA_TYPE_NAME);
                registry.register(Boolean.TYPE, XmlSchemaBuiltInDataTypeNames.BOOLEAN_DATA_TYPE_NAME);
                registry.register(Boolean.class, XmlSchemaBuiltInDataTypeNames.BOOLEAN_DATA_TYPE_NAME);
                return registry;
            }
        };
    }
}

