/*
 * Decompiled with CFR 0.152.
 */
package org.jsefa.xml.lowlevel;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import org.jsefa.common.lowlevel.InputPosition;
import org.jsefa.common.lowlevel.LowLevelDeserializationException;
import org.jsefa.xml.lowlevel.XmlLowLevelDeserializer;
import org.jsefa.xml.lowlevel.config.XmlLowLevelConfiguration;
import org.jsefa.xml.lowlevel.model.Attribute;
import org.jsefa.xml.lowlevel.model.AttributeImpl;
import org.jsefa.xml.lowlevel.model.ElementEndImpl;
import org.jsefa.xml.lowlevel.model.ElementStartImpl;
import org.jsefa.xml.lowlevel.model.TextContentImpl;
import org.jsefa.xml.lowlevel.model.XmlItem;
import org.jsefa.xml.lowlevel.model.XmlItemType;
import org.jsefa.xml.namespace.QName;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public final class XmlPullBasedXmlLowLevelDeserializer
implements XmlLowLevelDeserializer {
    private final XmlLowLevelConfiguration config;
    private Reader reader;
    private XmlPullParser pullParser;
    private int depth = -1;
    private XmlItemType currentItemType;
    private XmlItem currentItem;
    private boolean eventPrefetched;
    private boolean decreaseDepthOnNextEvent;
    private int prefetchedEvent = -1;

    public XmlPullBasedXmlLowLevelDeserializer(XmlLowLevelConfiguration config) {
        this.config = config;
    }

    public void open(Reader reader) {
        this.open(reader, null);
    }

    public void open(Reader reader, String systemId) {
        this.reader = reader instanceof BufferedReader ? reader : new BufferedReader(reader);
        try {
            XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
            factory.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            this.pullParser = factory.newPullParser();
            this.pullParser.setInput(this.reader);
        }
        catch (XmlPullParserException e) {
            throw new LowLevelDeserializationException("Error while opening the deserialization stream", e);
        }
        this.depth = -1;
        this.currentItem = null;
        this.currentItemType = XmlItemType.NONE;
        this.eventPrefetched = false;
        this.decreaseDepthOnNextEvent = false;
    }

    public boolean hasNext() {
        try {
            if (this.eventPrefetched) {
                return true;
            }
            this.prefetchedEvent = this.pullParser.next();
            this.eventPrefetched = true;
            return this.prefetchedEvent != 1;
        }
        catch (XmlPullParserException e) {
            throw new LowLevelDeserializationException(e);
        }
        catch (IOException e) {
            throw new LowLevelDeserializationException(e);
        }
    }

    public void moveToNext() {
        if (this.decreaseDepthOnNextEvent) {
            --this.depth;
            this.decreaseDepthOnNextEvent = false;
        }
        if (!this.eventPrefetched && !this.hasNext()) {
            this.currentItemType = XmlItemType.NONE;
            this.currentItem = null;
            return;
        }
        try {
            int event;
            if (this.eventPrefetched) {
                event = this.prefetchedEvent;
                this.eventPrefetched = false;
                this.prefetchedEvent = -1;
            } else {
                event = this.pullParser.next();
            }
            switch (event) {
                case 2: {
                    ++this.depth;
                    this.currentItemType = XmlItemType.ELEMENT_START;
                    break;
                }
                case 3: {
                    this.currentItemType = XmlItemType.ELEMENT_END;
                    this.decreaseDepthOnNextEvent = true;
                    break;
                }
                case 4: {
                    this.currentItemType = XmlItemType.TEXT_CONTENT;
                    break;
                }
                default: {
                    this.currentItemType = XmlItemType.UNKNOWN;
                }
            }
            this.currentItem = null;
        }
        catch (XmlPullParserException e) {
            throw new LowLevelDeserializationException(e);
        }
        catch (IOException e) {
            throw new LowLevelDeserializationException(e);
        }
    }

    public XmlItemType currentType() {
        return this.currentItemType;
    }

    public XmlItem current() {
        if (this.currentItem == null) {
            if (this.currentItemType == XmlItemType.ELEMENT_START) {
                QName name = this.getElementName();
                QName dataTypeName = this.getDataTypeName();
                Attribute[] attributes = this.getAttributes();
                this.currentItem = new ElementStartImpl(name, dataTypeName, attributes, this.depth);
            } else if (this.currentItemType == XmlItemType.ELEMENT_END) {
                QName name = this.getElementName();
                this.currentItem = new ElementEndImpl(name, this.depth);
            } else if (this.currentItemType == XmlItemType.TEXT_CONTENT) {
                this.currentItem = new TextContentImpl(this.pullParser.getText());
            }
        }
        return this.currentItem;
    }

    public int currentDepth() {
        return this.depth;
    }

    public void close(boolean closeReader) {
        try {
            if (closeReader) {
                this.reader.close();
            }
        }
        catch (Exception e) {
            throw new LowLevelDeserializationException("Error while closing the deserialization stream", e);
        }
        this.reader = null;
    }

    public InputPosition getInputPosition() {
        if (this.reader != null) {
            int lineNumber = this.pullParser.getLineNumber();
            int columnNumber = this.pullParser.getColumnNumber();
            if (lineNumber >= 0 && columnNumber >= 0) {
                return new InputPosition(lineNumber, columnNumber);
            }
        }
        return null;
    }

    private QName getElementName() {
        return QName.create(this.normalizeURI(this.pullParser.getNamespace()), this.pullParser.getName());
    }

    private QName getDataTypeName() {
        QName dataTypeName = null;
        String dataTypeNameStr = this.pullParser.getAttributeValue(this.config.getDataTypeAttributeName().getUri(), this.config.getDataTypeAttributeName().getLocalName());
        if (dataTypeNameStr != null) {
            int delimiterPos = dataTypeNameStr.indexOf(":");
            if (delimiterPos == -1) {
                dataTypeName = QName.create(this.normalizeURI(this.pullParser.getNamespace("")), dataTypeNameStr);
            } else {
                String prefix = dataTypeNameStr.substring(0, delimiterPos);
                String uri = this.pullParser.getNamespace(prefix);
                String localName = "";
                if (delimiterPos < dataTypeNameStr.length() - 1) {
                    localName = dataTypeNameStr.substring(delimiterPos + 1);
                }
                dataTypeName = QName.create(this.normalizeURI(uri), localName);
            }
        }
        return dataTypeName;
    }

    private Attribute[] getAttributes() {
        int attributeCount = this.pullParser.getAttributeCount();
        Attribute[] attributes = new Attribute[attributeCount];
        for (int i = 0; i < attributeCount; ++i) {
            QName name = QName.create(this.normalizeURI(this.pullParser.getAttributeNamespace(i)), this.pullParser.getAttributeName(i));
            String value = this.pullParser.getAttributeValue(i);
            attributes[i] = new AttributeImpl(name, value);
        }
        return attributes;
    }

    private String normalizeURI(String uri) {
        if (uri != null) {
            return uri;
        }
        return "";
    }
}

