/*
 * Decompiled with CFR 0.152.
 */
package org.jsefa.xml.lowlevel;

import java.io.IOException;
import java.io.Writer;
import org.jsefa.common.lowlevel.LowLevelSerializationException;
import org.jsefa.xml.lowlevel.TextMode;
import org.jsefa.xml.lowlevel.XmlLowLevelSerializer;
import org.jsefa.xml.lowlevel.config.XmlLowLevelConfiguration;
import org.jsefa.xml.namespace.NamespaceManager;
import org.jsefa.xml.namespace.QName;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;
import org.xmlpull.v1.XmlSerializer;

public final class XmlPullBasedXmlLowLevelSerializer
implements XmlLowLevelSerializer {
    private final XmlLowLevelConfiguration config;
    private Writer writer;
    private XmlSerializer serializer;
    private int depth = -1;
    private boolean lastWasStartElement;
    private NamespaceManager namespaceManager;

    public XmlPullBasedXmlLowLevelSerializer(XmlLowLevelConfiguration config) {
        this.config = config;
    }

    public void open(Writer writer) {
        this.writer = writer;
        try {
            XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
            this.serializer = factory.newSerializer();
            this.serializer.setOutput(this.writer);
        }
        catch (XmlPullParserException e) {
            throw new LowLevelSerializationException("Error while opening the serialization stream", e);
        }
        catch (IllegalArgumentException e) {
            throw new LowLevelSerializationException("Error while opening the serialization stream", e);
        }
        catch (IllegalStateException e) {
            throw new LowLevelSerializationException("Error while opening the serialization stream", e);
        }
        catch (IOException e) {
            throw new LowLevelSerializationException("Error while opening the serialization stream", e);
        }
        this.depth = -1;
        this.namespaceManager = this.config.getNamespaceManager();
    }

    public void writeXmlDeclaration(String version, String encoding) {
        try {
            this.serializer.startDocument(encoding, Boolean.valueOf(true));
            this.writeLineBreak();
        }
        catch (IllegalArgumentException e) {
            throw new LowLevelSerializationException(e);
        }
        catch (IllegalStateException e) {
            throw new LowLevelSerializationException(e);
        }
        catch (IOException e) {
            throw new LowLevelSerializationException(e);
        }
    }

    public void writeDocTypeDeclaration(QName rootElementName, String publicId, String systemId) {
        StringBuilder dtd = new StringBuilder("<!DOCTYPE ");
        if (!this.hasNamespace(rootElementName)) {
            dtd.append(rootElementName.getLocalName());
        } else {
            this.namespaceManager = NamespaceManager.createWithParent(this.namespaceManager);
            String prefix = this.namespaceManager.getPrefix(rootElementName.getUri(), true);
            if (prefix == null) {
                prefix = this.namespaceManager.createPrefix(rootElementName.getUri(), true);
            }
            if (prefix.length() > 0) {
                dtd.append(prefix).append(":");
            }
            dtd.append(rootElementName.getLocalName());
        }
        if (publicId != null) {
            dtd.append(" PUBLIC \"").append(publicId).append("\" \"").append(systemId).append("\">");
        } else {
            dtd.append(" SYSTEM \"").append(systemId).append("\">");
        }
        try {
            this.serializer.docdecl(dtd.toString());
            this.writeLineBreak();
        }
        catch (IllegalArgumentException e) {
            throw new LowLevelSerializationException(e);
        }
        catch (IllegalStateException e) {
            throw new LowLevelSerializationException(e);
        }
        catch (IOException e) {
            throw new LowLevelSerializationException(e);
        }
    }

    public void writeStartElement(QName name) {
        this.writeStartElement(name, null);
    }

    public void writeStartElement(QName name, QName dataTypeName) {
        ++this.depth;
        this.namespaceManager = NamespaceManager.createWithParent(this.namespaceManager);
        try {
            if (this.lastWasStartElement) {
                this.writeLineBreak();
            } else {
                this.lastWasStartElement = true;
            }
            this.writeIdent();
            if (!this.hasNamespace(name)) {
                if (this.defaultNamespaceExists()) {
                    this.serializer.setPrefix("", "");
                    this.serializer.startTag("", name.getLocalName());
                    this.namespaceManager.registerPrefix("", "");
                }
                this.serializer.startTag(null, name.getLocalName());
            } else {
                String prefix = this.namespaceManager.getPrefix(name.getUri(), true);
                if (prefix == null) {
                    prefix = this.namespaceManager.createPrefix(name.getUri(), true);
                    this.namespaceManager.registerPrefix(prefix, name.getUri());
                }
                this.serializer.setPrefix(prefix, name.getUri());
                this.serializer.startTag(name.getUri(), name.getLocalName());
            }
            if (dataTypeName != null) {
                String value = dataTypeName.getLocalName();
                if (this.hasNamespace(dataTypeName)) {
                    String prefix = this.namespaceManager.getPrefix(dataTypeName.getUri(), true);
                    if (prefix == null) {
                        prefix = this.namespaceManager.createPrefix(dataTypeName.getUri(), true);
                        this.namespaceManager.registerPrefix(prefix, dataTypeName.getUri());
                        this.serializer.setPrefix(prefix, dataTypeName.getUri());
                    }
                    if (prefix.length() > 0) {
                        value = prefix + ":" + value;
                    }
                }
                this.writeAttribute(this.config.getDataTypeAttributeName(), value);
            }
        }
        catch (IllegalArgumentException e) {
            throw new LowLevelSerializationException("Unable to write element " + name, e);
        }
        catch (IllegalStateException e) {
            throw new LowLevelSerializationException("Unable to write element " + name, e);
        }
        catch (IOException e) {
            throw new LowLevelSerializationException("Unable to write element " + name, e);
        }
    }

    public void writeAttribute(QName name, String value) {
        if (value == null) {
            return;
        }
        try {
            if (!this.hasNamespace(name)) {
                this.serializer.attribute(null, name.getLocalName(), value);
            } else {
                String prefix = this.namespaceManager.getPrefix(name.getUri(), false);
                if (prefix == null) {
                    prefix = this.namespaceManager.createPrefix(name.getUri(), false);
                    this.namespaceManager.registerPrefix(prefix, name.getUri());
                    this.serializer.setPrefix(prefix, name.getUri());
                }
                this.serializer.attribute(name.getUri(), name.getLocalName(), value);
            }
        }
        catch (IllegalArgumentException e) {
            throw new LowLevelSerializationException("Unable to write attribute " + name, e);
        }
        catch (IllegalStateException e) {
            throw new LowLevelSerializationException("Unable to write attribute " + name, e);
        }
        catch (IOException e) {
            throw new LowLevelSerializationException("Unable to write attribute " + name, e);
        }
    }

    public void writeText(String text, TextMode textMode) {
        if (text != null && text.length() != 0) {
            try {
                if (TextMode.CDATA.equals((Object)textMode)) {
                    int index = text.indexOf("]]>");
                    int lastIndex = 0;
                    while (index > -1) {
                        this.serializer.cdsect(text.substring(lastIndex, index + 2));
                        lastIndex = index + 2;
                        index = text.indexOf("]]>", index + 1);
                    }
                    this.serializer.cdsect(text.substring(lastIndex));
                } else {
                    this.serializer.text(text);
                }
            }
            catch (IllegalArgumentException e) {
                throw new LowLevelSerializationException("Unable to write text", e);
            }
            catch (IllegalStateException e) {
                throw new LowLevelSerializationException("Unable to write text", e);
            }
            catch (IOException e) {
                throw new LowLevelSerializationException("Unable to write text", e);
            }
        }
    }

    public void writeEndElement() {
        try {
            if (!this.lastWasStartElement) {
                this.writeIdent();
            }
            this.lastWasStartElement = false;
            this.serializer.endTag(this.serializer.getNamespace(), this.serializer.getName());
            this.writeLineBreak();
        }
        catch (IllegalArgumentException e) {
            throw new LowLevelSerializationException("Unable to finish element", e);
        }
        catch (IllegalStateException e) {
            throw new LowLevelSerializationException("Unable to finish element", e);
        }
        catch (IOException e) {
            throw new LowLevelSerializationException("Unable to finish element", e);
        }
        this.namespaceManager = this.namespaceManager.getParent();
        --this.depth;
    }

    public void flush() {
        try {
            this.serializer.flush();
        }
        catch (Exception e) {
            throw new LowLevelSerializationException("Error while flushing the serialization stream", e);
        }
    }

    public void close(boolean closeWriter) {
        try {
            this.serializer.flush();
            if (closeWriter) {
                this.writer.close();
            }
        }
        catch (Exception e) {
            throw new LowLevelSerializationException("Error while closing the serialization stream", e);
        }
    }

    private void writeLineBreak() throws IOException {
        this.serializer.text(this.config.getLineBreak().toCharArray(), 0, this.config.getLineBreak().length());
    }

    private void writeIdent() throws IOException {
        String lineIndentation = this.config.getLineIndentation();
        if (lineIndentation.length() > 0) {
            for (int i = 0; i < this.depth; ++i) {
                this.serializer.text(lineIndentation.toCharArray(), 0, lineIndentation.length());
            }
        }
    }

    private boolean hasNamespace(QName name) {
        return !"".equals(name.getUri());
    }

    private boolean defaultNamespaceExists() {
        String registeredUri = this.namespaceManager.getUri("");
        return registeredUri != null && !registeredUri.equals("");
    }
}

