/*
 * Decompiled with CFR 0.152.
 */
package org.jsefa.xml.lowlevel.config;

import org.jsefa.common.config.InitialConfiguration;
import org.jsefa.common.lowlevel.config.LowLevelConfiguration;
import org.jsefa.common.util.OnDemandObjectProvider;
import org.jsefa.xml.namespace.NamespaceManager;
import org.jsefa.xml.namespace.QName;

public final class XmlLowLevelConfiguration
extends LowLevelConfiguration {
    private NamespaceManager namespaceManager;
    private QName dataTypeAttributeName;
    private String lineIndentation;

    public XmlLowLevelConfiguration() {
    }

    private XmlLowLevelConfiguration(XmlLowLevelConfiguration other) {
        super(other);
        this.setNamespaceManager(other.getNamespaceManager().createCopy());
        this.setDataTypeAttributeName(other.getDataTypeAttributeName());
        this.setLineBreak(other.getLineBreak());
        this.setLineIndentation(other.getLineIndentation());
    }

    public XmlLowLevelConfiguration createCopy() {
        return new XmlLowLevelConfiguration(this);
    }

    public NamespaceManager getNamespaceManager() {
        if (this.namespaceManager == null) {
            NamespaceManager manager = (NamespaceManager)InitialConfiguration.get("jsefa:xml:lowlevel:namespaceManager", Defaults.DEFAULT_NAMESPACE_MANAGER_PROVIDER);
            this.namespaceManager = manager.createCopy();
        }
        return this.namespaceManager;
    }

    public QName getDataTypeAttributeName() {
        if (this.dataTypeAttributeName == null) {
            this.dataTypeAttributeName = (QName)InitialConfiguration.get("jsefa:xml:lowlevel:dataTypeAttributeName", Defaults.DEFAULT_DATA_TYPE_ATTRIBUTE_NAME);
        }
        return this.dataTypeAttributeName;
    }

    public String getLineIndentation() {
        if (this.lineIndentation == null) {
            this.lineIndentation = (String)InitialConfiguration.get("jsefa:xml:lowlevel:lineIndentation", "  ");
        }
        return this.lineIndentation;
    }

    public void setNamespaceManager(NamespaceManager namespaceManager) {
        this.namespaceManager = namespaceManager;
    }

    public void setDataTypeAttributeName(QName dataTypeAttributeName) {
        this.dataTypeAttributeName = dataTypeAttributeName;
    }

    public void setLineIndentation(String lineIndentation) {
        this.lineIndentation = lineIndentation;
    }

    public static interface Defaults {
        public static final QName DEFAULT_DATA_TYPE_ATTRIBUTE_NAME = QName.create("http://www.w3.org/2001/XMLSchema-instance", "type");
        public static final String DEFAULT_LINE_INDENTATION = "  ";
        public static final OnDemandObjectProvider DEFAULT_NAMESPACE_MANAGER_PROVIDER = new OnDemandObjectProvider(){

            public NamespaceManager get() {
                NamespaceManager newNamespaceManager = NamespaceManager.create();
                newNamespaceManager.registerPreferredPrefix("xsi", "http://www.w3.org/2001/XMLSchema-instance");
                return newNamespaceManager;
            }
        };
    }
}

