/*
 * Decompiled with CFR 0.152.
 */
package org.jsefa.xml.mapping;

import java.util.ArrayList;
import java.util.List;
import org.jsefa.common.mapping.FieldDescriptor;
import org.jsefa.common.validator.Validator;
import org.jsefa.xml.lowlevel.TextMode;
import org.jsefa.xml.mapping.ElementDescriptor;
import org.jsefa.xml.mapping.ElementMapping;
import org.jsefa.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ElementMappingsBuilder {
    private final List<DataHolder> dataHolders = new ArrayList<DataHolder>();

    public void addMapping(QName dataTypeName, ElementDescriptor elementDescriptor, FieldDescriptor fieldDescriptor, Validator validator, TextMode textMode) {
        this.addMapping(dataTypeName, elementDescriptor, fieldDescriptor.getObjectType(), fieldDescriptor, validator, textMode);
    }

    public void addMapping(QName dataTypeName, ElementDescriptor elementDescriptor, Class<?> objectType, FieldDescriptor fieldDescriptor, Validator validator, TextMode textMode) {
        this.dataHolders.add(new DataHolder(dataTypeName, elementDescriptor, objectType, fieldDescriptor, validator, textMode));
    }

    public List<ElementMapping> getResult() {
        ArrayList<ElementMapping> elementMappings = new ArrayList<ElementMapping>();
        for (DataHolder dataHolder : this.dataHolders) {
            elementMappings.add(new ElementMapping(dataHolder.dataTypeName, dataHolder.elementDescriptor, dataHolder.objectType, dataHolder.fieldDescriptor, dataHolder.validator, this.isAmbiguous(dataHolder), dataHolder.textMode));
        }
        return elementMappings;
    }

    private boolean isAmbiguous(DataHolder dataHolder) {
        if (dataHolder.elementDescriptor.getName() == null) {
            return false;
        }
        for (DataHolder otherDataHolder : this.dataHolders) {
            if (otherDataHolder == dataHolder || otherDataHolder.elementDescriptor.getName() == null || !otherDataHolder.elementDescriptor.getName().equals(dataHolder.elementDescriptor.getName())) continue;
            if (otherDataHolder.objectType.isAssignableFrom(dataHolder.objectType)) {
                return true;
            }
            if (dataHolder.objectType.isAssignableFrom(otherDataHolder.objectType)) continue;
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DataHolder {
        private QName dataTypeName;
        private ElementDescriptor elementDescriptor;
        private FieldDescriptor fieldDescriptor;
        private Validator validator;
        private Class<?> objectType;
        private TextMode textMode;

        private DataHolder(QName dataTypeName, ElementDescriptor elementDescriptor, Class<?> objectType, FieldDescriptor fieldDescriptor, Validator validator, TextMode textMode) {
            this.dataTypeName = dataTypeName;
            this.elementDescriptor = elementDescriptor;
            this.objectType = objectType;
            this.fieldDescriptor = fieldDescriptor;
            this.validator = validator;
            this.textMode = textMode;
        }
    }
}

