/*
 * Decompiled with CFR 0.152.
 */
package org.jsefa.xml.mapping;

import org.jsefa.common.converter.BooleanConverter;
import org.jsefa.common.converter.IntegerConverter;
import org.jsefa.common.converter.LongConverter;
import org.jsefa.common.converter.SimpleTypeConverter;
import org.jsefa.common.converter.SimpleTypeConverterConfiguration;
import org.jsefa.common.converter.StringConverter;
import org.jsefa.common.mapping.HierarchicalTypeMappingRegistry;
import org.jsefa.xml.mapping.XmlSimpleTypeMapping;
import org.jsefa.xml.mapping.support.XmlSchemaBuiltInDataTypeNames;
import org.jsefa.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XmlTypeMappingRegistry
extends HierarchicalTypeMappingRegistry<QName> {
    public XmlTypeMappingRegistry() {
        this.registerStandards();
    }

    private XmlTypeMappingRegistry(XmlTypeMappingRegistry other) {
        super(other);
    }

    private void registerStandards() {
        this.registerStandard(XmlSchemaBuiltInDataTypeNames.STRING_DATA_TYPE_NAME, String.class, StringConverter.create());
        this.registerStandard(XmlSchemaBuiltInDataTypeNames.INT_DATA_TYPE_NAME, Integer.class, IntegerConverter.create());
        this.registerStandard(XmlSchemaBuiltInDataTypeNames.INTEGER_DATA_TYPE_NAME, Integer.class, IntegerConverter.create());
        this.registerStandard(XmlSchemaBuiltInDataTypeNames.LONG_DATA_TYPE_NAME, Long.class, LongConverter.create());
        this.registerStandard(XmlSchemaBuiltInDataTypeNames.BOOLEAN_DATA_TYPE_NAME, Boolean.class, BooleanConverter.create(SimpleTypeConverterConfiguration.EMPTY));
    }

    private void registerStandard(QName dataTypeName, Class<?> objectType, SimpleTypeConverter converter) {
        this.register(new XmlSimpleTypeMapping(dataTypeName, objectType, converter));
    }

    public XmlTypeMappingRegistry createCopy() {
        return new XmlTypeMappingRegistry(this);
    }
}

