/*
 * Decompiled with CFR 0.152.
 */
package org.jsefa.xml.namespace;

public final class QName {
    private final String uri;
    private final String localName;
    private final int hashCode;

    public static QName create(String localName) {
        return new QName("", localName);
    }

    public static QName create(String uri, String localName) {
        return new QName(uri, localName);
    }

    private QName(String uri, String localName) {
        if (uri == null || localName == null) {
            throw new IllegalArgumentException("Both uri and local name must not be null!");
        }
        this.uri = uri;
        this.localName = localName;
        this.hashCode = 37 * (17 + this.uri.hashCode()) + this.localName.hashCode();
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getUri() {
        return this.uri;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof QName)) {
            return false;
        }
        QName other = (QName)obj;
        return this.localName.equals(other.localName) && this.uri.equals(other.uri);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        if ("".equals(this.uri)) {
            return this.localName;
        }
        return this.uri + "#" + this.localName;
    }
}

