/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.zerocodejavaexec;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jsmart.zerocode.zerocodejavaexec.pojo.DbResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbSqlExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbSqlExecutor.class);
    @Inject(optional=true)
    @Named(value="db.conn.user.name")
    private String dbUserName;
    @Inject(optional=true)
    @Named(value="db.conn.password")
    private String dbPassword;
    public static final String RESULTS_KEY = "results";

    public Map<String, List<DbResult>> fetchDbCustomers(String sqlStatement) {
        Map<String, List<DbResult>> results = this.executeSelectSql(sqlStatement);
        return results;
    }

    public Map<String, List<DbResult>> fetchDbCustomersByName(String name) {
        Map<String, List<DbResult>> results = this.executeSelectSql("any sql");
        DbResult foundResult = results.get(RESULTS_KEY).stream().filter(thisRecord -> thisRecord.getName().equals(name)).findFirst().get();
        results.put(RESULTS_KEY, Arrays.asList(foundResult));
        return results;
    }

    private Map<String, List<DbResult>> executeSelectSql(String sqlStatement) {
        LOGGER.info("\n\nDB Connection user:{}, password:{}\n\n", (Object)this.dbUserName, (Object)this.dbPassword);
        ArrayList<DbResult> results = new ArrayList<DbResult>();
        results.add(new DbResult(1, "Elon Musk"));
        results.add(new DbResult(2, "Jeff Bezos"));
        HashMap<String, List<DbResult>> resultsMap = new HashMap<String, List<DbResult>>();
        resultsMap.put(RESULTS_KEY, results);
        return resultsMap;
    }

    public void setDbUserName(String dbUserName) {
        this.dbUserName = dbUserName;
    }

    public void setDbPassword(String dbPassword) {
        this.dbPassword = dbPassword;
    }
}

