/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.zerocodejavaexec.httpclient;

import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.client.CookieStore;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.jsmart.zerocode.core.httpclient.BasicHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomHttpClient
extends BasicHttpClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomHttpClient.class);

    public CustomHttpClient() {
        LOGGER.info("###Initialized 0 args - ");
    }

    public CustomHttpClient(CloseableHttpClient httpclient) {
        super(httpclient);
        LOGGER.info("###Initialized 1 arg - ");
    }

    public CloseableHttpClient createHttpClient() throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException {
        LOGGER.info("###Used SSL Enabled Http Client for http/https/TLS connections");
        SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, (certificate, authType) -> true).build();
        BasicCookieStore cookieStore = new BasicCookieStore();
        return HttpClients.custom().setSSLContext(sslContext).setSSLHostnameVerifier((HostnameVerifier)new NoopHostnameVerifier()).setDefaultCookieStore((CookieStore)cookieStore).build();
    }

    public Map<String, Object> amendRequestHeaders(Map<String, Object> headers) {
        if (headers != null) {
            this.addCustomHeaders(headers);
        } else {
            headers = new HashMap<String, Object>();
            this.addCustomHeaders(headers);
        }
        return headers;
    }

    private void addCustomHeaders(Map<String, Object> headers) {
        String my_value = UUID.randomUUID().toString();
        headers.put("my_key", my_value);
        String x_token_value = "secret_value_001";
        headers.put("x_token", x_token_value);
        LOGGER.info("###Added custom headers my_key={}, x_token={} to headers", (Object)my_value, (Object)x_token_value);
    }
}

