/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.zerocodejavaexec.wiremock;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import org.jsmart.zerocode.core.runner.ZeroCodeUnitRunner;
import org.junit.runners.model.InitializationError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZeroCodeWireMockRunner
extends ZeroCodeUnitRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZeroCodeWireMockRunner.class);
    static String basePath;
    static String fullPath;
    static int port;
    static WireMockServer mockServer;

    public ZeroCodeWireMockRunner(Class<?> klass) throws InitializationError {
        super(klass);
        ZeroCodeWireMockRunner.simulateServerDelay();
    }

    public static void simulateServerDelay() {
        LOGGER.info("Setting up WireMock with server delay...");
        basePath = "http://localhost:" + port;
        String path = "/delay/ids/2";
        fullPath = basePath + path;
        mockServer.start();
        mockServer.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)path)).willReturn(WireMock.aResponse().withStatus(200).withFixedDelay(Integer.valueOf(2000))));
    }

    static {
        port = 8383;
        mockServer = new WireMockServer(port);
    }
}

