/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.simulator.base;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.simpleframework.http.core.Container;
import org.simpleframework.http.core.ContainerServer;
import org.simpleframework.transport.Server;
import org.simpleframework.transport.connect.Connection;
import org.simpleframework.transport.connect.SocketConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseSimulator {
    private static final Logger logger = LoggerFactory.getLogger(BaseSimulator.class);
    private static int port;
    private Connection connection;
    private InetSocketAddress socketAddress;
    private String simulatorName;
    private Container actualContainer;

    public BaseSimulator(int port) {
        BaseSimulator.port = port;
    }

    public void start() {
        try {
            Container container = this.getActualContainer();
            ContainerServer server = new ContainerServer(container);
            this.connection = new SocketConnection((Server)server);
            InetSocketAddress address = new InetSocketAddress(port);
            this.socketAddress = (InetSocketAddress)this.connection.connect((SocketAddress)address);
            logger.info("\n#Simulator: " + this.getSimulatorName() + "\n#started. " + "\nListening at port: " + this.socketAddress.getPort());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        try {
            this.connection.close();
            logger.info("\n#" + this.getSimulatorName() + "\nstopped.");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int getPort() {
        return this.socketAddress.getPort();
    }

    public String getSimulatorName() {
        return this.simulatorName;
    }

    public void setSimulatorName(String simulatorName) {
        this.simulatorName = simulatorName;
    }

    public Container getActualContainer() {
        return this.actualContainer;
    }

    public void setActualContainer(Container actualContainer) {
        this.actualContainer = actualContainer;
    }
}

