/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.simulator.impl;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.jsmart.simulator.base.BaseSimulator;
import org.jsmart.simulator.base.Simulator;
import org.jsmart.simulator.domain.Api;
import org.simpleframework.http.Request;
import org.simpleframework.http.Response;
import org.simpleframework.http.Status;
import org.simpleframework.http.core.Container;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleRestSimulator
extends BaseSimulator
implements Container {
    private static final Logger logger = LoggerFactory.getLogger(SimpleRestSimulator.class);
    private List<Api> apiList = new ArrayList<Api>();
    private Api api;

    public List<Api> getApiList() {
        return this.apiList;
    }

    public SimpleRestSimulator(int port) {
        super(port);
        this.setSimulatorName("RESTFUL-simulator");
        this.setActualContainer(this);
    }

    public void handle(Request request, Response response) {
        try {
            PrintStream body = this.getPrintStreamForResponse(response);
            String responseString = "Not decided";
            logger.info("\n#" + request.getMethod() + ": Target URL: " + request.getTarget());
            for (Api api : this.apiList) {
                if (!request.getTarget().equals(api.getUrl()) || !request.getMethod().equals(api.getOperation())) continue;
                response.setStatus(Status.getStatus((int)api.getResponse().getStatus()));
                responseString = api.getResponse().getBody();
                break;
            }
            logger.info("\n# Response Status: " + response.getCode());
            logger.info("\n# Response body: \n" + responseString);
            body.print(responseString);
            body.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private PrintStream getPrintStreamForResponse(Response response) throws IOException {
        PrintStream body = response.getPrintStream();
        long time = System.currentTimeMillis();
        response.setContentType("application/json");
        response.setDescription(this.getSimulatorName());
        response.setDate("Date", time);
        response.setDate("Last-Modified", time);
        return body;
    }

    public SimpleRestSimulator withApi(Api api) {
        if (null != api) {
            this.getApiList().add(api);
        }
        return this;
    }

    @Override
    public SimpleRestSimulator restApi(Api api) {
        return this.withApi(api);
    }

    @Override
    public Simulator run() {
        if (!this.isRunning()) {
            this.start();
        }
        return this;
    }
}

