/*
 * Decompiled with CFR 0.152.
 */
package org.jsmiparser.phase.file;

import java.util.ArrayList;
import java.util.List;
import org.jsmiparser.phase.file.IntKeywordToken;
import org.jsmiparser.smi.OidComponent;
import org.jsmiparser.smi.ScopedId;
import org.jsmiparser.smi.SmiConstants;
import org.jsmiparser.smi.SmiDefaultValue;
import org.jsmiparser.smi.SmiImports;
import org.jsmiparser.smi.SmiMacro;
import org.jsmiparser.smi.SmiModule;
import org.jsmiparser.smi.SmiNamedNumber;
import org.jsmiparser.smi.SmiOidMacro;
import org.jsmiparser.smi.SmiOidValue;
import org.jsmiparser.smi.SmiPrimitiveType;
import org.jsmiparser.smi.SmiProtocolType;
import org.jsmiparser.smi.SmiRange;
import org.jsmiparser.smi.SmiReferencedType;
import org.jsmiparser.smi.SmiRow;
import org.jsmiparser.smi.SmiSymbol;
import org.jsmiparser.smi.SmiTable;
import org.jsmiparser.smi.SmiTextualConvention;
import org.jsmiparser.smi.SmiType;
import org.jsmiparser.smi.SmiVariable;
import org.jsmiparser.smi.SmiVersion;
import org.jsmiparser.smi.StatusV2;
import org.jsmiparser.util.location.Location;
import org.jsmiparser.util.token.BigIntegerToken;
import org.jsmiparser.util.token.BinaryStringToken;
import org.jsmiparser.util.token.HexStringToken;
import org.jsmiparser.util.token.IdToken;
import org.jsmiparser.util.token.IntegerToken;
import org.jsmiparser.util.token.QuotedStringToken;
import org.jsmiparser.util.token.Token;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleParser {
    private static final Logger m_log = LoggerFactory.getLogger(ModuleParser.class);
    private final SmiModule m_module;

    public ModuleParser(SmiModule module) {
        this.m_module = module;
    }

    public SmiModule getModule() {
        return this.m_module;
    }

    private Location makeLocation(antlr.Token token) {
        String source = this.m_module.getIdToken().getLocation().getSource();
        return new Location(source, token.getLine(), token.getColumn());
    }

    public IdToken idt(antlr.Token idToken) {
        return new IdToken(this.makeLocation(idToken), idToken.getText());
    }

    public IdToken idt(antlr.Token ... tokens) {
        for (antlr.Token token : tokens) {
            if (token == null) continue;
            return this.idt(token);
        }
        return null;
    }

    public IntKeywordToken intkt(antlr.Token idToken, SmiPrimitiveType primitiveType, SmiVersion version) {
        if (version != null) {
            if (version == SmiVersion.V1) {
                this.m_module.incV1Features();
            } else {
                this.m_module.incV2Features();
            }
        }
        return new IntKeywordToken(this.makeLocation(idToken), idToken.getText(), primitiveType);
    }

    public String getCStr(antlr.Token t) {
        String text = t.getText();
        if (!text.startsWith("\"") || !text.endsWith("\"")) {
            throw new IllegalArgumentException(t.getText());
        }
        return text.substring(1, text.length() - 1);
    }

    public String getOptCStr(antlr.Token t) {
        if (t != null) {
            return this.getCStr(t);
        }
        return null;
    }

    public IntegerToken intt(antlr.Token t) {
        int value = Integer.parseInt(t.getText());
        return new IntegerToken(this.makeLocation(t), value);
    }

    public BigIntegerToken bintt(antlr.Token t) {
        return new BigIntegerToken(this.makeLocation(t), false, t.getText());
    }

    public BigIntegerToken bintt(antlr.Token minusToken, antlr.Token t) {
        return new BigIntegerToken(this.makeLocation(t), minusToken != null, t.getText());
    }

    public List<IdToken> makeIdTokenList() {
        return new ArrayList<IdToken>();
    }

    public void addImports(IdToken moduleToken, List<IdToken> importedTokenList) {
        SmiImports result = new SmiImports(this.m_module, moduleToken, importedTokenList);
        this.m_module.getImports().add(result);
    }

    public OidComponent createOidComponent(OidComponent parent, antlr.Token id, antlr.Token value) {
        IdToken idToken = id != null ? this.idt(id) : null;
        IntegerToken valueToken = value != null ? this.intt(value) : null;
        return new OidComponent(parent, idToken, valueToken);
    }

    public SmiOidValue createOidValue(IdToken idToken, OidComponent lastOidComponent) {
        SmiOidValue result = new SmiOidValue(idToken, this.m_module);
        result.setLastOidComponent(lastOidComponent);
        return result;
    }

    public SmiMacro createMacro(IdToken idToken) {
        return new SmiMacro(idToken, this.m_module);
    }

    public SmiOidMacro createOidMacro(IdToken idToken) {
        return new SmiOidMacro(idToken, this.m_module);
    }

    public SmiVariable createVariable(IdToken idToken, SmiType t, antlr.Token units, SmiDefaultValue defaultValue) {
        String methodWithParams = "createVariable(" + idToken.getId() + ")";
        m_log.debug(methodWithParams);
        QuotedStringToken unitsToken = null;
        if (units != null) {
            unitsToken = new QuotedStringToken(this.makeLocation(units), units.getText(), '\"');
        }
        return new SmiVariable(idToken, this.m_module, t, unitsToken, defaultValue);
    }

    public SmiRow createRow(IdToken idToken, SmiType t) {
        String methodWithParams = "createRow(" + idToken.getId() + ")";
        m_log.debug(methodWithParams);
        SmiRow result = new SmiRow(idToken, this.m_module);
        result.setType(t);
        return result;
    }

    public SmiTable createTable(IdToken idToken, SmiType t) {
        String methodWithParams = "createTable(" + idToken.getId() + ")";
        m_log.debug(methodWithParams);
        SmiTable result = new SmiTable(idToken, this.m_module);
        result.setType(t);
        return result;
    }

    public SmiTextualConvention createTextualConvention(IdToken idToken, antlr.Token displayHint, StatusV2 status, antlr.Token description, antlr.Token reference, SmiType type) {
        SmiTextualConvention result = new SmiTextualConvention(idToken, this.m_module, this.getOptCStr(displayHint), status, this.getCStr(description), this.getOptCStr(reference));
        if (type.getBaseType() == null) {
            result.setBaseType(type);
        } else {
            result.setBaseType(type.getBaseType());
        }
        result.setEnumValues(type.getEnumValues());
        result.setBitFields(type.getBitFields());
        result.setRangeConstraints(type.getRangeConstraints());
        result.setSizeConstraints(type.getSizeConstraints());
        return result;
    }

    public SmiType createSequenceType(IdToken idToken) {
        return new SmiType(idToken, this.m_module);
    }

    public SmiType createType(IdToken idToken, SmiType baseType) {
        SmiType result;
        if (baseType == null) {
            throw new IllegalArgumentException();
        }
        if (idToken == null) {
            result = baseType;
        } else {
            result = new SmiType(idToken, this.m_module);
            result.setBaseType(baseType);
        }
        return result;
    }

    public SmiType createIntegerType(IdToken idToken, IntKeywordToken intToken, antlr.Token applicationTagToken, List<SmiNamedNumber> namedNumbers, List<SmiRange> rangeConstraints) {
        if (idToken == null && intToken.getPrimitiveType() == SmiPrimitiveType.INTEGER && namedNumbers == null && rangeConstraints == null) {
            return SmiConstants.INTEGER_TYPE;
        }
        if (idToken != null || namedNumbers != null || rangeConstraints != null) {
            SmiType type = this.createPotentiallyTaggedType(idToken, applicationTagToken);
            if (intToken.getPrimitiveType() == SmiPrimitiveType.INTEGER) {
                type.setBaseType(SmiConstants.INTEGER_TYPE);
            } else {
                type.setBaseType(new SmiReferencedType(intToken, this.m_module));
            }
            type.setEnumValues(namedNumbers);
            type.setRangeConstraints(rangeConstraints);
            return type;
        }
        return new SmiReferencedType(intToken, this.m_module);
    }

    private SmiType createPotentiallyTaggedType(IdToken idToken, antlr.Token applicationTagToken) {
        SmiType type;
        if (applicationTagToken != null) {
            int tag = Integer.parseInt(applicationTagToken.getText());
            type = new SmiType(idToken, this.m_module, tag);
        } else {
            type = new SmiType(idToken, this.m_module);
        }
        return type;
    }

    public SmiType createBitsType(IdToken idToken, List<SmiNamedNumber> namedNumbers) {
        this.m_module.incV2Features();
        if (idToken != null || namedNumbers != null) {
            SmiType type = new SmiType(idToken, this.m_module);
            type.setBaseType(SmiConstants.BITS_TYPE);
            type.setBitFields(namedNumbers);
            return type;
        }
        return SmiConstants.BITS_TYPE;
    }

    public SmiType createOctetStringType(IdToken idToken, antlr.Token applicationTagToken, List<SmiRange> sizeConstraints) {
        if (idToken != null || sizeConstraints != null) {
            SmiType type = this.createPotentiallyTaggedType(idToken, applicationTagToken);
            type.setBaseType(SmiConstants.OCTET_STRING_TYPE);
            type.setSizeConstraints(sizeConstraints);
            return type;
        }
        return SmiConstants.OCTET_STRING_TYPE;
    }

    public SmiType createDefinedType(IdToken idToken, antlr.Token moduleToken, antlr.Token referencedIdToken, List<SmiNamedNumber> namedNumbers, List<SmiRange> sizeConstraints, List<SmiRange> rangeConstraints) {
        SmiType result;
        SmiReferencedType referencedType = new SmiReferencedType(this.idt(referencedIdToken), this.m_module);
        if (moduleToken != null) {
            referencedType.setReferencedModuleToken(this.idt(moduleToken));
        }
        referencedType.setNamedNumbers(namedNumbers);
        referencedType.setSizeConstraints(sizeConstraints);
        referencedType.setRangeConstraints(rangeConstraints);
        if (idToken != null) {
            result = new SmiType(idToken, this.m_module);
            result.setBaseType(referencedType);
        } else {
            result = referencedType;
        }
        return result;
    }

    public SmiType createChoiceType(IdToken idToken) {
        return SmiProtocolType.createChoiceType(idToken, this.m_module);
    }

    public void addField(SmiType sequenceType, antlr.Token col, SmiType fieldType) {
        sequenceType.addField(this.idt(col), fieldType);
    }

    public SmiType createSequenceOfType(antlr.Token elementTypeNameToken) {
        SmiType sequenceOfType = new SmiType(null, this.m_module);
        sequenceOfType.setElementTypeToken(this.idt(elementTypeNameToken));
        return sequenceOfType;
    }

    public void addRange(List<SmiRange> rc, Token rv1, Token rv2) {
        SmiRange range = rv2 != null ? new SmiRange(rv1, rv2) : new SmiRange(rv1);
        rc.add(range);
    }

    public BinaryStringToken bst(antlr.Token t) {
        return new BinaryStringToken(this.makeLocation(t), t.getText());
    }

    public HexStringToken hst(antlr.Token t) {
        return new HexStringToken(this.makeLocation(t), t.getText());
    }

    public QuotedStringToken dqst(antlr.Token t) {
        return new QuotedStringToken(this.makeLocation(t), t.getText(), '\"');
    }

    public void addSymbol(SmiSymbol symbol) {
        if (symbol != null) {
            this.m_module.addSymbol(symbol);
        }
    }

    public StatusV2 findStatusV2(String text) {
        this.m_module.incV2Features();
        return StatusV2.find(text, true);
    }

    public ScopedId makeScopedId(antlr.Token moduleToken, antlr.Token symbolToken) {
        return new ScopedId(this.m_module, moduleToken != null ? this.idt(moduleToken) : null, this.idt(symbolToken));
    }
}

