/*
 * Decompiled with CFR 0.152.
 */
package org.jsmiparser.smi;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jsmiparser.phase.xref.XRefProblemReporter;
import org.jsmiparser.smi.SmiCodeNamingStrategy;
import org.jsmiparser.smi.SmiIndex;
import org.jsmiparser.smi.SmiModule;
import org.jsmiparser.smi.SmiObjectType;
import org.jsmiparser.smi.SmiOidNode;
import org.jsmiparser.smi.SmiOidValue;
import org.jsmiparser.smi.SmiOptions;
import org.jsmiparser.smi.SmiRow;
import org.jsmiparser.smi.SmiSymbol;
import org.jsmiparser.smi.SmiSymbolMap;
import org.jsmiparser.smi.SmiSymbolMapImpl;
import org.jsmiparser.smi.SmiTable;
import org.jsmiparser.smi.SmiTextualConvention;
import org.jsmiparser.smi.SmiType;
import org.jsmiparser.smi.SmiVariable;
import org.jsmiparser.smi.SmiVersion;
import org.jsmiparser.util.location.Location;
import org.jsmiparser.util.token.IdToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmiMib {
    private Map<String, SmiModule> m_moduleMap = new LinkedHashMap<String, SmiModule>();
    private final SmiOptions m_options;
    private SmiCodeNamingStrategy m_codeNamingStrategy;
    private SmiOidNode m_rootNode;
    SmiSymbolMapImpl<SmiType> m_typeMap = new SmiSymbolMapImpl<SmiType>(SmiType.class, this.m_moduleMap);
    SmiSymbolMapImpl<SmiTextualConvention> m_textualConventionMap = new SmiSymbolMapImpl<SmiTextualConvention>(SmiTextualConvention.class, this.m_moduleMap);
    SmiSymbolMapImpl<SmiSymbol> m_symbolMap = new SmiSymbolMapImpl<SmiSymbol>(SmiSymbol.class, this.m_moduleMap);
    SmiSymbolMapImpl<SmiVariable> m_variableMap = new SmiSymbolMapImpl<SmiVariable>(SmiVariable.class, this.m_moduleMap);
    SmiSymbolMapImpl<SmiTable> m_tableMap = new SmiSymbolMapImpl<SmiTable>(SmiTable.class, this.m_moduleMap);
    SmiSymbolMapImpl<SmiRow> m_rowMap = new SmiSymbolMapImpl<SmiRow>(SmiRow.class, this.m_moduleMap);
    SmiSymbolMapImpl<SmiVariable> m_columnMap = new SmiSymbolMapImpl<SmiVariable>(SmiVariable.class, this.m_moduleMap);
    SmiSymbolMapImpl<SmiVariable> m_scalarMap = new SmiSymbolMapImpl<SmiVariable>(SmiVariable.class, this.m_moduleMap);
    SmiSymbolMapImpl<SmiOidValue> m_oidValueMap = new SmiSymbolMapImpl<SmiOidValue>(SmiOidValue.class, this.m_moduleMap);
    SmiSymbolMapImpl<SmiObjectType> m_objectTypesMap = new SmiSymbolMapImpl<SmiObjectType>(SmiObjectType.class, this.m_moduleMap);
    int m_dummyOidNodesCount;
    private SmiModule m_internalModule;

    public SmiMib(SmiOptions options, SmiCodeNamingStrategy codeNamingStrategy) {
        this.m_options = options;
        this.m_codeNamingStrategy = codeNamingStrategy;
        SmiModule internalMib = this.buildInternalMib();
        this.m_moduleMap.put(internalMib.getId(), internalMib);
    }

    private SmiModule buildInternalMib() {
        Location location = new Location("JSMI_INTERNAL_MIB");
        this.m_internalModule = new SmiModule(this, new IdToken(location, "JSMI_INTERNAL_MIB"));
        this.m_rootNode = SmiOidNode.createRootNode();
        return this.m_internalModule;
    }

    public SmiOidNode getRootNode() {
        return this.m_rootNode;
    }

    public SmiModule getInternalModule() {
        return this.m_internalModule;
    }

    public SmiModule findModule(String id) {
        return this.m_moduleMap.get(id);
    }

    public Collection<SmiModule> getModules() {
        return this.m_moduleMap.values();
    }

    public SmiOptions getOptions() {
        return this.m_options;
    }

    public SmiCodeNamingStrategy getCodeNamingStrategy() {
        return this.m_codeNamingStrategy;
    }

    public void setCodeNamingStrategy(SmiCodeNamingStrategy codeNamingStrategy) {
        this.m_codeNamingStrategy = codeNamingStrategy;
    }

    public SmiModule createModule(IdToken idToken) {
        SmiModule oldModule = this.m_moduleMap.get(idToken.getId());
        if (oldModule != null) {
            throw new IllegalStateException("Duplicate module: " + oldModule.getIdToken() + " is already defined when adding: " + idToken);
        }
        SmiModule module = new SmiModule(this, idToken);
        this.m_moduleMap.put(module.getId(), module);
        return module;
    }

    public void determineInheritanceRelations() {
        for (SmiRow row : this.m_rowMap.values()) {
            SmiIndex lastIndex;
            SmiRow lastIndexRow;
            if (row.getAugments() != null) {
                row.addParentRow(row.getAugments());
                continue;
            }
            if (row.getIndexes().size() == 1) {
                SmiIndex index = row.getIndexes().get(0);
                SmiRow indexRow = index.getColumn().getRow();
                if (row == indexRow) continue;
                row.addParentRow(indexRow);
                continue;
            }
            if (row.getIndexes().size() <= 1 || row == (lastIndexRow = (lastIndex = row.getIndexes().get(row.getIndexes().size() - 1)).getColumn().getRow()) || !row.hasSameIndexes(lastIndexRow)) continue;
            row.addParentRow(lastIndexRow);
        }
    }

    void addModule(String id, SmiModule module) {
        SmiModule oldModule = this.m_moduleMap.get(id);
        if (oldModule != null) {
            throw new IllegalArgumentException("Mib already contains a module: " + oldModule);
        }
        this.m_moduleMap.put(id, module);
    }

    public void fillTables() {
        for (SmiModule module : this.m_moduleMap.values()) {
            module.fillTables();
            this.m_typeMap.putAll(module.m_typeMap);
            this.m_textualConventionMap.putAll(module.m_textualConventionMap);
            this.m_variableMap.putAll(module.m_variableMap);
            this.m_rowMap.putAll(module.m_rowMap);
            this.m_tableMap.putAll(module.m_tableMap);
            this.m_symbolMap.putAll(module.m_symbolMap);
            this.m_oidValueMap.putAll(module.m_oidValueMap);
            this.m_objectTypesMap.putAll(module.m_objectTypeMap);
        }
    }

    public void fillExtraTables() {
        for (SmiModule module : this.m_moduleMap.values()) {
            module.fillExtraTables();
            this.m_scalarMap.putAll(module.m_scalarMap);
            this.m_columnMap.putAll(module.m_columnMap);
        }
    }

    public int getDummyOidNodesCount() {
        return this.m_dummyOidNodesCount;
    }

    public SmiSymbolMap<SmiType> getTypes() {
        return this.m_typeMap;
    }

    public SmiSymbolMap<SmiTextualConvention> getTextualConventions() {
        return this.m_textualConventionMap;
    }

    public SmiSymbolMap<SmiSymbol> getSymbols() {
        return this.m_symbolMap;
    }

    public SmiSymbolMap<SmiVariable> getVariables() {
        return this.m_variableMap;
    }

    public SmiSymbolMap<SmiTable> getTables() {
        return this.m_tableMap;
    }

    public SmiSymbolMap<SmiRow> getRows() {
        return this.m_rowMap;
    }

    public SmiSymbolMap<SmiVariable> getColumns() {
        return this.m_columnMap;
    }

    public SmiSymbolMap<SmiVariable> getScalars() {
        return this.m_scalarMap;
    }

    public SmiSymbolMap<SmiOidValue> getOidValues() {
        return this.m_oidValueMap;
    }

    public SmiSymbolMap<SmiObjectType> getObjectTypes() {
        return this.m_objectTypesMap;
    }

    public SmiOidNode findByOid(int ... oid) {
        SmiOidNode child = null;
        SmiOidNode parent = this.getRootNode();
        for (int oidPart : oid) {
            child = parent.findChild(oidPart);
            if (child == null) {
                return null;
            }
            parent = child;
        }
        return child;
    }

    public SmiOidNode findByOidPrefix(int ... oid) {
        SmiOidNode parent = this.getRootNode();
        for (int subId : oid) {
            SmiOidNode result = parent.findChild(subId);
            if (result == null) {
                return parent;
            }
            parent = result;
        }
        return null;
    }

    public Set<SmiModule> findModules(SmiVersion version) {
        HashSet<SmiModule> result = new HashSet<SmiModule>();
        for (SmiModule module : this.m_moduleMap.values()) {
            if (module.getVersion() != null && module.getVersion() != version) continue;
            result.add(module);
        }
        return result;
    }

    public void defineMissingStandardOids() {
        Location location = this.m_internalModule.getIdToken().getLocation();
        if (this.m_symbolMap.findAll("itu").isEmpty()) {
            SmiOidNode ituNode = new SmiOidNode(this.m_rootNode, 0);
            SmiOidValue itu = new SmiOidValue(new IdToken(location, "itu"), this.m_internalModule, ituNode);
            this.m_internalModule.addSymbol(itu);
            this.m_internalModule.m_symbolMap.put(itu.getId(), itu);
            this.m_symbolMap.put(itu.getId(), itu);
            this.m_oidValueMap.put(itu.getId(), itu);
        }
        if (this.m_symbolMap.findAll("iso").isEmpty()) {
            SmiOidNode isoNode = new SmiOidNode(this.m_rootNode, 1);
            SmiOidValue iso = new SmiOidValue(new IdToken(location, "iso"), this.m_internalModule, isoNode);
            this.m_internalModule.addSymbol(iso);
            this.m_internalModule.m_symbolMap.put(iso.getId(), iso);
            this.m_symbolMap.put(iso.getId(), iso);
            this.m_oidValueMap.put(iso.getId(), iso);
        }
    }

    public SmiModule resolveModule(IdToken moduleToken, XRefProblemReporter reporter) {
        SmiModule result = this.m_moduleMap.get(moduleToken.getId());
        if (result == null) {
            reporter.reportCannotFindModule(moduleToken);
        }
        return result;
    }
}

