/*
 * Decompiled with CFR 0.152.
 */
package org.jsmiparser.smi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jsmiparser.phase.xref.XRefProblemReporter;
import org.jsmiparser.smi.SmiConstants;
import org.jsmiparser.smi.SmiImports;
import org.jsmiparser.smi.SmiMib;
import org.jsmiparser.smi.SmiObjectType;
import org.jsmiparser.smi.SmiOidValue;
import org.jsmiparser.smi.SmiRow;
import org.jsmiparser.smi.SmiSymbol;
import org.jsmiparser.smi.SmiTable;
import org.jsmiparser.smi.SmiTextualConvention;
import org.jsmiparser.smi.SmiType;
import org.jsmiparser.smi.SmiVariable;
import org.jsmiparser.smi.SmiVersion;
import org.jsmiparser.util.token.IdToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmiModule {
    private static final Logger m_log = LoggerFactory.getLogger(SmiModule.class);
    private SmiMib m_mib;
    private IdToken m_idToken;
    private List<SmiImports> m_imports = new ArrayList<SmiImports>();
    private List<SmiSymbol> m_symbols = new ArrayList<SmiSymbol>();
    Map<String, SmiType> m_typeMap = new LinkedHashMap<String, SmiType>();
    Map<String, SmiTextualConvention> m_textualConventionMap = new LinkedHashMap<String, SmiTextualConvention>();
    Map<String, SmiSymbol> m_symbolMap = new LinkedHashMap<String, SmiSymbol>();
    Map<String, SmiVariable> m_variableMap = new LinkedHashMap<String, SmiVariable>();
    Map<String, SmiVariable> m_scalarMap = new LinkedHashMap<String, SmiVariable>();
    Map<String, SmiTable> m_tableMap = new LinkedHashMap<String, SmiTable>();
    Map<String, SmiRow> m_rowMap = new LinkedHashMap<String, SmiRow>();
    Map<String, SmiVariable> m_columnMap = new LinkedHashMap<String, SmiVariable>();
    Map<String, SmiOidValue> m_oidValueMap = new LinkedHashMap<String, SmiOidValue>();
    Map<String, SmiObjectType> m_objectTypeMap = new LinkedHashMap<String, SmiObjectType>();
    private int m_v1Features = 0;
    private int m_v2Features = 0;
    private SmiVersion m_version;
    private boolean m_isSmiDefinitionModule;

    public SmiModule(SmiMib mib, IdToken idToken) {
        this.m_mib = mib;
        if (idToken == null) {
            throw new IllegalArgumentException();
        }
        this.setIdToken(idToken);
        this.m_isSmiDefinitionModule = SmiConstants.SMI_DEFINITION_MODULE_NAMES.contains(idToken.getId());
    }

    public int getV1Features() {
        return this.m_v1Features;
    }

    public void incV1Features() {
        ++this.m_v1Features;
    }

    public int getV2Features() {
        return this.m_v2Features;
    }

    public void incV2Features() {
        ++this.m_v2Features;
    }

    public SmiVersion getVersion() {
        if (this.m_version == null && (this.m_v1Features != 0 || this.m_v2Features != 0)) {
            this.m_version = this.determineVersion();
        }
        return this.m_version;
    }

    private SmiVersion determineVersion() {
        if (this.m_v1Features > this.m_v2Features) {
            return SmiVersion.V1;
        }
        if (this.m_v1Features < this.m_v2Features) {
            return SmiVersion.V2;
        }
        m_log.info("interesting mib with equal amount of V1 and V2 features: " + this.m_v1Features + ": " + this.getIdToken());
        return null;
    }

    public SmiType findType(String id) {
        return this.m_typeMap.get(id);
    }

    public Collection<SmiType> getTypes() {
        return this.m_typeMap.values();
    }

    public SmiTextualConvention findTextualConvention(String id) {
        return this.m_textualConventionMap.get(id);
    }

    public Collection<SmiTextualConvention> getTextualConventions() {
        return this.m_textualConventionMap.values();
    }

    public Collection<SmiSymbol> getSymbols() {
        if (this.m_symbols != null) {
            return this.m_symbols;
        }
        return this.m_symbolMap.values();
    }

    public SmiSymbol findSymbol(String id) {
        return this.m_symbolMap.get(id);
    }

    public SmiVariable findVariable(String id) {
        return this.m_variableMap.get(id);
    }

    public Collection<SmiVariable> getVariables() {
        return this.m_variableMap.values();
    }

    public SmiVariable findScalar(String id) {
        return this.m_scalarMap.get(id);
    }

    public Collection<SmiVariable> getScalars() {
        return this.m_scalarMap.values();
    }

    public SmiTable findTable(String id) {
        return this.m_tableMap.get(id);
    }

    public Collection<SmiTable> getTables() {
        return this.m_tableMap.values();
    }

    public SmiRow findRow(String id) {
        return this.m_rowMap.get(id);
    }

    public Collection<SmiRow> getRows() {
        return this.m_rowMap.values();
    }

    public SmiVariable findColumn(String id) {
        return this.m_columnMap.get(id);
    }

    public Collection<SmiVariable> getColumns() {
        return this.m_columnMap.values();
    }

    public SmiOidValue findOidValue(String id) {
        return this.m_oidValueMap.get(id);
    }

    public Collection<SmiOidValue> getOidValues() {
        return this.m_oidValueMap.values();
    }

    public SmiObjectType findObjectType(String id) {
        return this.m_objectTypeMap.get(id);
    }

    public Collection<SmiObjectType> getObjectTypes() {
        return this.m_objectTypeMap.values();
    }

    public void setIdToken(IdToken id) {
        assert (this.m_idToken == null);
        this.m_idToken = id;
        this.m_mib.addModule(id.getId(), this);
    }

    public IdToken getIdToken() {
        return this.m_idToken;
    }

    public String getId() {
        return this.m_idToken.getId();
    }

    public SmiMib getMib() {
        return this.m_mib;
    }

    public SmiType createType(IdToken idToken) {
        SmiType type = new SmiType(idToken, this);
        this.m_typeMap.put(idToken.getId(), type);
        return type;
    }

    public String getCodeId() {
        return this.getMib().getCodeNamingStrategy().getModuleId(this);
    }

    public String getFullCodeId() {
        return this.getMib().getCodeNamingStrategy().getFullModuleId(this);
    }

    public SmiTable createTable(IdToken idToken) {
        SmiTable table = new SmiTable(idToken, this);
        this.m_tableMap.put(idToken.getId(), table);
        return table;
    }

    public SmiRow createRow(IdToken idToken) {
        SmiRow row = new SmiRow(idToken, this);
        this.m_rowMap.put(idToken.getId(), row);
        return row;
    }

    public String getFullVariableOidClassId() {
        return this.getMib().getCodeNamingStrategy().getFullVariableOidClassId(this);
    }

    public String getVariableOidClassId() {
        return this.getMib().getCodeNamingStrategy().getVariableOidClassId(this);
    }

    public boolean isSmiDefinitionModule() {
        return this.m_isSmiDefinitionModule;
    }

    public List<SmiImports> getImports() {
        return this.m_imports;
    }

    public Set<SmiModule> getImportedModules() {
        HashSet<SmiModule> result = new HashSet<SmiModule>();
        for (SmiImports anImport : this.m_imports) {
            result.add(anImport.getModule());
        }
        return result;
    }

    public void fillTables() {
        for (SmiSymbol symbol : this.m_symbols) {
            this.put(this.m_tableMap, SmiTable.class, symbol);
            this.put(this.m_variableMap, SmiVariable.class, symbol);
            this.put(this.m_typeMap, SmiType.class, symbol);
            this.put(this.m_textualConventionMap, SmiTextualConvention.class, symbol);
            this.put(this.m_rowMap, SmiRow.class, symbol);
            this.put(this.m_oidValueMap, SmiOidValue.class, symbol);
            this.put(this.m_objectTypeMap, SmiObjectType.class, symbol);
        }
    }

    public void fillExtraTables() {
        for (SmiVariable variable : this.m_variableMap.values()) {
            if (variable.isColumn()) {
                this.m_columnMap.put(variable.getId(), variable);
                continue;
            }
            this.m_scalarMap.put(variable.getId(), variable);
        }
    }

    private <T extends SmiSymbol> void put(Map<String, T> map, Class<T> clazz, SmiSymbol symbol) {
        if (clazz.isInstance(symbol)) {
            map.put(symbol.getId(), clazz.cast(symbol));
        }
    }

    public void addSymbol(SmiSymbol symbol) {
        this.m_symbols.add(symbol);
        this.m_symbolMap.put(symbol.getId(), symbol);
    }

    public SmiSymbol resolveReference(IdToken idToken, XRefProblemReporter reporter) {
        SmiSymbol result = this.findSymbol(idToken.getId());
        if (result == null) {
            result = this.findImportedSymbol(idToken.getId());
        }
        if (result == null) {
            List<SmiSymbol> symbols = this.getMib().getSymbols().findAll(idToken.getId());
            if (symbols.size() == 1) {
                result = symbols.get(0);
            } else if (symbols.size() > 0) {
                result = this.determineBestMatch(idToken, symbols);
            }
        }
        if (result == null && reporter != null) {
            reporter.reportCannotFindSymbol(idToken);
        }
        return result;
    }

    public <T extends SmiSymbol> T resolveReference(IdToken idToken, Class<T> expectedClass, XRefProblemReporter reporter) {
        SmiSymbol result = this.resolveReference(idToken, reporter);
        if (result != null) {
            if (expectedClass.isInstance(result)) {
                return (T)((SmiSymbol)expectedClass.cast(result));
            }
            reporter.reportFoundSymbolButWrongType(idToken, expectedClass, result.getClass());
        }
        return null;
    }

    private SmiSymbol determineBestMatch(IdToken idToken, List<SmiSymbol> symbols) {
        SmiSymbol result = this.determineBestMatchBasedOnSnmpVersion(symbols);
        if (result != null) {
            return result;
        }
        result = this.determineBestMatchBasedOnOtherImports(idToken, symbols);
        if (result != null) {
            return result;
        }
        if (m_log.isDebugEnabled()) {
            m_log.debug("Couldn't choose between " + symbols.size() + " choices for resolving: " + idToken + ":");
            for (SmiSymbol symbol : symbols) {
                m_log.debug(symbol.toString());
            }
        }
        return null;
    }

    private SmiSymbol determineBestMatchBasedOnOtherImports(IdToken idToken, List<SmiSymbol> symbols) {
        for (SmiSymbol symbol : symbols) {
            for (SmiImports imports : this.m_imports) {
                if (imports.getModule() != symbol.getModule()) continue;
                m_log.debug("Determined best match for " + idToken + " based on other imports from " + symbol.getModule().getId());
                return symbol;
            }
        }
        return null;
    }

    private SmiSymbol determineBestMatchBasedOnSnmpVersion(List<SmiSymbol> symbols) {
        if (symbols.size() == 2) {
            SmiSymbol s0 = symbols.get(0);
            SmiSymbol s1 = symbols.get(1);
            SmiVersion version0 = s0.getModule().getVersion();
            SmiVersion version1 = s1.getModule().getVersion();
            if (version0 != null && version1 != null && version0 != version1) {
                if (this.getVersion() == version0) {
                    return s0;
                }
                if (this.getVersion() == version1) {
                    return s1;
                }
            }
        }
        return null;
    }

    private SmiSymbol findImportedSymbol(String id) {
        for (SmiImports imports : this.m_imports) {
            SmiSymbol symbol = imports.find(id);
            if (symbol == null) continue;
            return symbol;
        }
        return null;
    }

    public void resolveImports(XRefProblemReporter reporter) {
        for (SmiImports imports : this.m_imports) {
            imports.resolveImports(reporter);
        }
    }

    public String toString() {
        return this.m_idToken.toString();
    }
}

