/*
 * Decompiled with CFR 0.152.
 */
package org.jsmiparser.smi;

import java.util.EnumSet;
import java.util.Set;
import org.jsmiparser.smi.MacroType;
import org.jsmiparser.smi.StatusV1;
import org.jsmiparser.smi.StatusV2;
import org.jsmiparser.smi.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum StatusAll {
    MANDATORY(MacroType.OBJECT_TYPE_V1),
    OPTIONAL(MacroType.OBJECT_TYPE_V1),
    OBSOLETE(MacroType.OBJECT_TYPE_V1, MacroType.OBJECT_IDENTITY, MacroType.NOTIFICATION_TYPE, MacroType.TEXTUAL_CONVENTION, MacroType.OBJECT_GROUP, MacroType.NOTIFICATION_GROUP, MacroType.MODULE_COMPLIANCE, MacroType.AGENT_CAPABILITIES),
    DEPRECATED(MacroType.OBJECT_TYPE_V1, MacroType.OBJECT_IDENTITY, MacroType.NOTIFICATION_TYPE, MacroType.TEXTUAL_CONVENTION, MacroType.OBJECT_GROUP, MacroType.NOTIFICATION_GROUP, MacroType.MODULE_COMPLIANCE),
    CURRENT(MacroType.OBJECT_IDENTITY, MacroType.NOTIFICATION_TYPE, MacroType.TEXTUAL_CONVENTION, MacroType.OBJECT_GROUP, MacroType.NOTIFICATION_GROUP, MacroType.MODULE_COMPLIANCE, MacroType.AGENT_CAPABILITIES);

    private String m_keyword;
    private Set<MacroType> m_supportedMacroTypes = EnumSet.noneOf(MacroType.class);

    private StatusAll(MacroType ... macroTypes) {
        this.m_keyword = this.name().toLowerCase();
        for (MacroType macroType : macroTypes) {
            this.m_supportedMacroTypes.add(macroType);
        }
    }

    public String toString() {
        return this.m_keyword;
    }

    public static StatusAll find(String keyword, boolean mandatory) {
        return Util.find(StatusAll.class, keyword, mandatory);
    }

    public StatusV1 getStatusV1() {
        for (StatusV1 statusV1 : StatusV1.values()) {
            if (statusV1.getStatusAll() != this) continue;
            return statusV1;
        }
        return null;
    }

    public StatusV2 getStatusV2() {
        for (StatusV2 statusV2 : StatusV2.values()) {
            if (statusV2.getStatusAll() != this) continue;
            return statusV2;
        }
        return null;
    }

    public static StatusAll findV1(MacroType macroType, String keyword) {
        StatusAll result = StatusAll.find(keyword, true);
        if (result.isSupportedBy(macroType)) {
            return result;
        }
        throw new IllegalArgumentException("Status " + (Object)((Object)result) + " is not supported by " + (Object)((Object)macroType));
    }

    public boolean isSupportedBy(MacroType macroType) {
        return this.m_supportedMacroTypes.contains((Object)macroType);
    }
}

