/*
 * Decompiled with CFR 0.152.
 */
package org.jsmiparser;

import org.jsmiparser.AbstractMibTestCase;
import org.jsmiparser.smi.SmiModule;
import org.jsmiparser.smi.SmiTrapType;
import org.jsmiparser.smi.SmiVariable;
import org.jsmiparser.smi.SmiVersion;
import org.jsmiparser.util.token.IdToken;

public class BgpRfc1269MibTest
extends AbstractMibTestCase {
    public BgpRfc1269MibTest() {
        super(SmiVersion.V1, "libsmi-0.4.8/mibs/ietf/RFC-1212", "libsmi-0.4.8/mibs/ietf/RFC1213-MIB", "libsmi-0.4.8/mibs/ietf/RFC-1215", "libsmi-0.4.8/mibs/ietf/RFC1269-MIB");
    }

    public void testSizes() {
        BgpRfc1269MibTest.assertNotNull((String)"MIB cannot be null", (Object)this.getMib());
        BgpRfc1269MibTest.assertNotNull((Object)this.getMib().getScalars());
        BgpRfc1269MibTest.assertEquals((int)108, (int)this.getMib().getScalars().size());
        BgpRfc1269MibTest.assertNotNull((Object)this.getMib().getColumns());
        BgpRfc1269MibTest.assertEquals((int)89, (int)this.getMib().getColumns().size());
        BgpRfc1269MibTest.assertEquals((int)2, (int)this.getMib().getTrapTypes().size());
        SmiModule bgpMib = this.getMib().findModule("RFC1269-MIB");
        BgpRfc1269MibTest.assertNotNull((Object)bgpMib);
        BgpRfc1269MibTest.assertEquals((int)2, (int)bgpMib.getTrapTypes().size());
        BgpRfc1269MibTest.assertEquals((int)3, (int)bgpMib.getScalars().size());
        BgpRfc1269MibTest.assertEquals((int)20, (int)bgpMib.getColumns().size());
        BgpRfc1269MibTest.assertNotNull((Object)bgpMib.findScalar("bgpLocalAs"));
        BgpRfc1269MibTest.assertNull((Object)bgpMib.findColumn("bgpLocalAs"));
        BgpRfc1269MibTest.assertNotNull((Object)bgpMib.findColumn("bgpPeerIdentifier"));
        BgpRfc1269MibTest.assertNull((Object)bgpMib.findScalar("bgpPeerIdentifier"));
        BgpRfc1269MibTest.assertNotNull((Object)bgpMib.findTable("bgpPeerTable"));
        BgpRfc1269MibTest.assertNull((Object)bgpMib.findVariable("bgpPeerTable"));
        BgpRfc1269MibTest.assertNotNull((Object)bgpMib.findRow("bgpPeerEntry"));
        BgpRfc1269MibTest.assertNull((Object)bgpMib.findVariable("bgpPeerEntry"));
    }

    public void testTrapTypes() {
        SmiModule bgpMib = this.getMib().findModule("RFC1269-MIB");
        BgpRfc1269MibTest.assertNotNull((Object)bgpMib);
        SmiTrapType bgpEstablished = bgpMib.findTrapType("bgpEstablished");
        BgpRfc1269MibTest.assertNotNull((Object)bgpEstablished);
        SmiTrapType bgpBackwardTransition = bgpMib.findTrapType("bgpBackwardTransition");
        BgpRfc1269MibTest.assertNotNull((Object)bgpBackwardTransition);
        SmiVariable bgpPeerRemoteAddr = bgpMib.findVariable("bgpPeerRemoteAddr");
        BgpRfc1269MibTest.assertNotNull((Object)bgpPeerRemoteAddr);
        SmiVariable bgpPeerLastError = bgpMib.findVariable("bgpPeerLastError");
        BgpRfc1269MibTest.assertNotNull((Object)bgpPeerLastError);
        SmiVariable bgpPeerState = bgpMib.findVariable("bgpPeerState");
        BgpRfc1269MibTest.assertNotNull((Object)bgpPeerState);
        BgpRfc1269MibTest.assertEquals((String)"1.3.6.1.2.1.15", (String)bgpEstablished.getEnterpriseOid().getOidStr());
        BgpRfc1269MibTest.assertEquals((int)1, (int)bgpEstablished.getSpecificType());
        BgpRfc1269MibTest.assertEquals((String)"1.3.6.1.2.1.15.1", (String)bgpEstablished.getOidStr());
        BgpRfc1269MibTest.assertEquals((String)"The BGP Established event is generated when\n          the BGP FSM enters the ESTABLISHED state. ", (String)bgpEstablished.getDescription());
        BgpRfc1269MibTest.assertNull((Object)bgpEstablished.getReference());
        BgpRfc1269MibTest.assertNotNull((Object)bgpEstablished.getVariableTokens());
        BgpRfc1269MibTest.assertEquals((int)3, (int)bgpEstablished.getVariableTokens().size());
        BgpRfc1269MibTest.assertEquals((String)"bgpPeerRemoteAddr", (String)((String)((IdToken)bgpEstablished.getVariableTokens().get(0)).getValue()));
        BgpRfc1269MibTest.assertEquals((String)"bgpPeerLastError", (String)((String)((IdToken)bgpEstablished.getVariableTokens().get(1)).getValue()));
        BgpRfc1269MibTest.assertEquals((String)"bgpPeerState", (String)((String)((IdToken)bgpEstablished.getVariableTokens().get(2)).getValue()));
        BgpRfc1269MibTest.assertEquals((String)"bgpEstablished", (String)((String)bgpEstablished.getIdToken().getValue()));
        BgpRfc1269MibTest.assertNotNull((Object)bgpEstablished.getVariables());
        BgpRfc1269MibTest.assertEquals((int)3, (int)bgpEstablished.getVariables().size());
        BgpRfc1269MibTest.assertSame((Object)bgpPeerRemoteAddr, bgpEstablished.getVariables().get(0));
        BgpRfc1269MibTest.assertSame((Object)bgpPeerLastError, bgpEstablished.getVariables().get(1));
        BgpRfc1269MibTest.assertSame((Object)bgpPeerState, bgpEstablished.getVariables().get(2));
    }
}

