/*
 * Decompiled with CFR 0.152.
 */
package org.jsmiparser.parser;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.jsmiparser.parser.SmiDefaultParser;
import org.jsmiparser.util.url.FileURLListFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibSmiParserFactory {
    private final File mibsDir;

    public LibSmiParserFactory(File mibsDir) {
        this.mibsDir = mibsDir;
    }

    public SmiDefaultParser create() throws Exception {
        System.out.println("Creating a SmiDefaultParser for the libsmi mibs ...");
        SmiDefaultParser parser = new SmiDefaultParser();
        List<URL> inputUrls = this.initFileParserOptions(this.mibsDir, "iana", "ietf", "site", "tubs");
        parser.getFileParserPhase().setInputUrls(inputUrls);
        return parser;
    }

    private List<URL> initFileParserOptions(File mibsDir, String ... subDirNames) throws Exception {
        ArrayList<URL> result = new ArrayList<URL>();
        for (String subDirName : subDirNames) {
            File[] files;
            File dir = new File(mibsDir, subDirName);
            FileURLListFactory urlListFactory = new FileURLListFactory(dir);
            for (File file : files = dir.listFiles()) {
                if (!file.isFile() || file.getName().equals("RFC1158-MIB") || file.getName().contains("TOTAL") || file.getName().endsWith("tree") || file.getName().startsWith("Makefile") || file.getName().endsWith("~") || file.getName().endsWith("-orig") || file.getName().equals("IANA-ITU-ALARM-TC-MIB") && file.getParentFile().getName().equals("iana")) continue;
                urlListFactory.add(file.getName());
            }
            result.addAll(urlListFactory.create());
        }
        return result;
    }
}

