/*
 * Decompiled with CFR 0.152.
 */
package org.jsmiparser.smi;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jsmiparser.phase.xref.XRefProblemReporter;
import org.jsmiparser.smi.SmiModule;
import org.jsmiparser.smi.SmiUtil;
import org.jsmiparser.util.location.Location;
import org.jsmiparser.util.token.IdToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SmiSymbol
implements Serializable,
Comparable {
    private IdToken m_idToken;
    private SmiModule m_module;
    private Map<Object, Object> m_userData;

    public SmiSymbol(IdToken idToken, SmiModule module) {
        if (module == null) {
            throw new IllegalArgumentException();
        }
        this.m_idToken = idToken;
        this.m_module = module;
    }

    public SmiSymbol(SmiModule module) {
        if (module == null) {
            throw new IllegalArgumentException();
        }
        this.m_module = module;
    }

    public String getId() {
        return this.m_idToken != null ? this.m_idToken.getId() : null;
    }

    public IdToken getIdToken() {
        return this.m_idToken;
    }

    public void setIdToken(IdToken idToken) {
        this.m_idToken = idToken;
    }

    public abstract String getCodeId();

    public String getFullCodeId() {
        return this.m_module.getMib().getCodeNamingStrategy().getFullCodeId(this);
    }

    public SmiModule getModule() {
        return this.m_module;
    }

    public Location getLocation() {
        return this.m_idToken != null ? this.m_idToken.getLocation() : null;
    }

    public String getUcId() {
        return SmiUtil.ucFirst(this.getId());
    }

    public String toString() {
        return this.m_module.getId() + ": " + this.getId();
    }

    public int hashCode() {
        if (this.m_idToken != null) {
            return this.m_idToken.getId().hashCode();
        }
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (this.m_idToken != null && obj instanceof SmiSymbol) {
            SmiSymbol other = (SmiSymbol)obj;
            return this.m_module.equals(other.m_module) && other.getId().equals(this.getId());
        }
        return super.equals(obj);
    }

    public int compareTo(Object o) {
        return this.compareTo((SmiSymbol)o);
    }

    public int compareTo(SmiSymbol other) {
        int result = this.getModule().getId().compareTo(other.getModule().getId());
        if (result == 0) {
            result = this.getId().compareTo(other.getId());
        }
        return result;
    }

    public void resolveReferences(XRefProblemReporter reporter) {
    }

    public Map<Object, Object> getUserData() {
        if (this.m_userData == null) {
            return Collections.emptyMap();
        }
        return this.m_userData;
    }

    public void addUserData(Object key, Object value) {
        if (this.m_userData == null) {
            this.m_userData = new HashMap<Object, Object>();
        }
        this.m_userData.put(key, value);
    }

    public Object findUserData(Object key) {
        if (this.m_userData == null) {
            return null;
        }
        return this.m_userData.get(key);
    }

    public <T> T findUserData(Class<T> key) {
        if (this.m_userData == null) {
            return null;
        }
        return (T)this.m_userData.get(key);
    }
}

