/*
 * Copyright 2012 Davy Verstappen.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jsmiparser.smi;

public class BERConstants {

    private static final byte ASN_UNIVERSAL = 0x00;
    private static final byte ASN_APPLICATION = 0x40;

    public static final byte INTEGER32 = ASN_UNIVERSAL | 0x02;
    public static final byte OCTETSTRING = ASN_UNIVERSAL | 0x04;
    public static final byte OID = ASN_UNIVERSAL | 0x06;

    public static final byte IPADDRESS = ASN_APPLICATION | 0x00;
    public static final byte COUNTER32 = ASN_APPLICATION | 0x01;
    public static final byte GAUGE32 = ASN_APPLICATION | 0x02;
    public static final byte TIMETICKS = ASN_APPLICATION | 0x03;
    public static final byte OPAQUE = ASN_APPLICATION | 0x04;
    public static final byte COUNTER64 = ASN_APPLICATION | 0x06;

}
