/*
 * Decompiled with CFR 0.152.
 */
package org.jsmiparser;

import java.math.BigInteger;
import java.util.List;
import org.jsmiparser.AbstractMibTestCase;
import org.jsmiparser.smi.ObjectTypeAccessV2;
import org.jsmiparser.smi.SmiConstants;
import org.jsmiparser.smi.SmiNamedNumber;
import org.jsmiparser.smi.SmiObjectType;
import org.jsmiparser.smi.SmiPrimitiveType;
import org.jsmiparser.smi.SmiRange;
import org.jsmiparser.smi.SmiTextualConvention;
import org.jsmiparser.smi.SmiType;
import org.jsmiparser.smi.SmiVariable;
import org.jsmiparser.smi.StatusV2;

public class TypesMibTest
extends AbstractMibTestCase {
    public TypesMibTest() {
        super(null, "types.txt");
    }

    public void testMyINTEGER() {
        SmiType type = (SmiType)this.getMib().getTypes().find("MyINTEGER");
        this.checkMyINTEGER(type);
    }

    public void testTCMyINTEGER() {
        SmiTextualConvention tc = (SmiTextualConvention)this.getMib().getTextualConventions().find("TCMyINTEGER");
        TypesMibTest.assertEquals((String)(tc.getId() + " Desc"), (String)tc.getDescription());
        TypesMibTest.assertEquals((String)"255a", (String)tc.getDisplayHint());
        TypesMibTest.assertEquals((Object)StatusV2.DEPRECATED, (Object)tc.getStatusV2());
        this.checkMyINTEGER((SmiType)tc);
    }

    public void testOTMyINTEGER() {
        SmiObjectType ot = (SmiObjectType)this.getMib().getVariables().find("myINTEGER");
        TypesMibTest.assertEquals((String)(ot.getId() + " Desc"), (String)ot.getDescription());
        TypesMibTest.assertEquals((Object)ObjectTypeAccessV2.NOT_ACCESSIBLE, (Object)ot.getMaxAccess());
        TypesMibTest.assertEquals((Object)StatusV2.CURRENT, (Object)ot.getStatusV2());
        SmiType type = ot.getType();
        TypesMibTest.assertSame((Object)SmiConstants.INTEGER_TYPE, (Object)type);
        TypesMibTest.assertSame((Object)SmiPrimitiveType.INTEGER, (Object)type.getPrimitiveType());
        TypesMibTest.assertNull((Object)type.getEnumValues());
        TypesMibTest.assertNull((Object)type.getBitFields());
        TypesMibTest.assertNull((Object)type.getFields());
        TypesMibTest.assertNull((Object)type.getRangeConstraints());
        TypesMibTest.assertNull((Object)type.getSizeConstraints());
    }

    private void checkMyINTEGER(SmiType type) {
        TypesMibTest.assertSame((Object)SmiConstants.INTEGER_TYPE, (Object)type.getBaseType());
        TypesMibTest.assertSame((Object)SmiPrimitiveType.INTEGER, (Object)type.getPrimitiveType());
        TypesMibTest.assertNull((Object)type.getEnumValues());
        TypesMibTest.assertNull((Object)type.getBitFields());
        TypesMibTest.assertNull((Object)type.getFields());
        TypesMibTest.assertNull((Object)type.getRangeConstraints());
        TypesMibTest.assertNull((Object)type.getSizeConstraints());
    }

    public void testMyINTEGERFromMinus3To4() {
        SmiType type = (SmiType)this.getMib().getTypes().find("MyINTEGERFromMinus3To4");
        this.checkMyINTEGERFromMinus3To4(type);
    }

    public void testTCMyINTEGERFromMinus3To4() {
        SmiTextualConvention tc = (SmiTextualConvention)this.getMib().getTextualConventions().find("TCMyINTEGERFromMinus3To4");
        TypesMibTest.assertEquals((String)(tc.getId() + " Desc"), (String)tc.getDescription());
        TypesMibTest.assertEquals((String)"255a", (String)tc.getDisplayHint());
        TypesMibTest.assertEquals((Object)StatusV2.DEPRECATED, (Object)tc.getStatusV2());
        this.checkMyINTEGERFromMinus3To4((SmiType)tc);
    }

    public void testOTMyINTEGERFromMinus3To4() {
        SmiObjectType ot = (SmiObjectType)this.getMib().getVariables().find("myINTEGERFromMinus3To4");
        TypesMibTest.assertEquals((String)(ot.getId() + " Desc"), (String)ot.getDescription());
        TypesMibTest.assertEquals((Object)ObjectTypeAccessV2.NOT_ACCESSIBLE, (Object)ot.getMaxAccess());
        TypesMibTest.assertEquals((Object)StatusV2.CURRENT, (Object)ot.getStatusV2());
        this.checkMyINTEGERFromMinus3To4(ot.getType());
    }

    private void checkMyINTEGERFromMinus3To4(SmiType type) {
        TypesMibTest.assertSame((Object)SmiConstants.INTEGER_TYPE, (Object)type.getBaseType());
        TypesMibTest.assertSame((Object)SmiPrimitiveType.INTEGER, (Object)type.getPrimitiveType());
        TypesMibTest.assertNull((Object)type.getEnumValues());
        TypesMibTest.assertNull((Object)type.getBitFields());
        TypesMibTest.assertNull((Object)type.getFields());
        TypesMibTest.assertNull((Object)type.getSizeConstraints());
        TypesMibTest.assertEquals((int)1, (int)type.getRangeConstraints().size());
        TypesMibTest.assertEquals((int)-3, (int)((SmiRange)type.getRangeConstraints().get(0)).getMinValue().intValue());
        TypesMibTest.assertEquals((int)4, (int)((SmiRange)type.getRangeConstraints().get(0)).getMaxValue().intValue());
    }

    public void testMyInteger32() {
        SmiType type = (SmiType)this.getMib().getTypes().find("MyInteger32");
        this.checkMyInteger32(type);
    }

    public void testTCMyInteger32() {
        SmiTextualConvention tc = (SmiTextualConvention)this.getMib().getTextualConventions().find("TCMyInteger32");
        TypesMibTest.assertEquals((String)(tc.getId() + " Desc"), (String)tc.getDescription());
        TypesMibTest.assertEquals((String)"255a", (String)tc.getDisplayHint());
        TypesMibTest.assertEquals((Object)StatusV2.DEPRECATED, (Object)tc.getStatusV2());
        this.checkMyInteger32((SmiType)tc);
    }

    public void testOTMyInteger32() {
        SmiObjectType ot = (SmiObjectType)this.getMib().getVariables().find("myInteger32");
        TypesMibTest.assertEquals((String)(ot.getId() + " Desc"), (String)ot.getDescription());
        TypesMibTest.assertEquals((Object)ObjectTypeAccessV2.NOT_ACCESSIBLE, (Object)ot.getMaxAccess());
        TypesMibTest.assertEquals((Object)StatusV2.CURRENT, (Object)ot.getStatusV2());
        SmiType type = ot.getType();
        TypesMibTest.assertSame((Object)this.getInteger32(), (Object)type);
        TypesMibTest.assertSame((Object)SmiPrimitiveType.INTEGER_32, (Object)type.getPrimitiveType());
        TypesMibTest.assertNull((Object)type.getEnumValues());
        TypesMibTest.assertNull((Object)type.getBitFields());
        TypesMibTest.assertNull((Object)type.getFields());
        TypesMibTest.assertEquals((int)1, (int)type.getRangeConstraints().size());
        TypesMibTest.assertNull((Object)type.getSizeConstraints());
    }

    private void checkMyInteger32(SmiType type) {
        TypesMibTest.assertSame((Object)this.getInteger32(), (Object)type.getBaseType());
        TypesMibTest.assertSame((Object)SmiPrimitiveType.INTEGER_32, (Object)type.getPrimitiveType());
        TypesMibTest.assertNull((Object)type.getEnumValues());
        TypesMibTest.assertNull((Object)type.getBitFields());
        TypesMibTest.assertNull((Object)type.getFields());
        TypesMibTest.assertNull((Object)type.getRangeConstraints());
        TypesMibTest.assertNull((Object)type.getSizeConstraints());
    }

    public void testMyInteger32FromMinus5To6() {
        SmiType type = (SmiType)this.getMib().getTypes().find("MyInteger32FromMinus5To6");
        this.checkMyInteger32FromMinus5To6(type);
    }

    public void testTCMyInteger32FromMinus5To6() {
        SmiTextualConvention tc = (SmiTextualConvention)this.getMib().getTextualConventions().find("TCMyInteger32FromMinus5To6");
        TypesMibTest.assertEquals((String)(tc.getId() + " Desc"), (String)tc.getDescription());
        TypesMibTest.assertEquals((String)"255a", (String)tc.getDisplayHint());
        TypesMibTest.assertEquals((Object)StatusV2.DEPRECATED, (Object)tc.getStatusV2());
        this.checkMyInteger32FromMinus5To6((SmiType)tc);
    }

    public void testOTMyInteger32FromMinus5To6() {
        SmiObjectType ot = (SmiObjectType)this.getMib().getVariables().find("myInteger32FromMinus5To6");
        TypesMibTest.assertEquals((String)(ot.getId() + " Desc"), (String)ot.getDescription());
        TypesMibTest.assertEquals((Object)ObjectTypeAccessV2.NOT_ACCESSIBLE, (Object)ot.getMaxAccess());
        TypesMibTest.assertEquals((Object)StatusV2.CURRENT, (Object)ot.getStatusV2());
        this.checkMyInteger32FromMinus5To6(ot.getType());
    }

    private void checkMyInteger32FromMinus5To6(SmiType type) {
        TypesMibTest.assertSame((Object)this.getInteger32(), (Object)type.getBaseType());
        TypesMibTest.assertSame((Object)SmiPrimitiveType.INTEGER_32, (Object)type.getPrimitiveType());
        TypesMibTest.assertNull((Object)type.getEnumValues());
        TypesMibTest.assertNull((Object)type.getBitFields());
        TypesMibTest.assertNull((Object)type.getFields());
        TypesMibTest.assertNull((Object)type.getSizeConstraints());
        TypesMibTest.assertEquals((int)1, (int)type.getRangeConstraints().size());
        TypesMibTest.assertEquals((int)-5, (int)((SmiRange)type.getRangeConstraints().get(0)).getMinValue().intValue());
        TypesMibTest.assertEquals((int)6, (int)((SmiRange)type.getRangeConstraints().get(0)).getMaxValue().intValue());
    }

    public void testMyEnum() {
        SmiType type = (SmiType)this.getMib().getTypes().find("MyEnum");
        this.checkMyEnum(type);
    }

    public void testTCMyEnum() {
        SmiTextualConvention tc = (SmiTextualConvention)this.getMib().getTextualConventions().find("TCMyEnum");
        TypesMibTest.assertEquals((String)(tc.getId() + " Desc"), (String)tc.getDescription());
        TypesMibTest.assertEquals((String)"255a", (String)tc.getDisplayHint());
        TypesMibTest.assertEquals((Object)StatusV2.DEPRECATED, (Object)tc.getStatusV2());
        this.checkMyEnum((SmiType)tc);
    }

    public void testOTMyEnum() {
        SmiObjectType ot = (SmiObjectType)this.getMib().getVariables().find("myEnum");
        TypesMibTest.assertEquals((String)(ot.getId() + " Desc"), (String)ot.getDescription());
        TypesMibTest.assertEquals((Object)ObjectTypeAccessV2.NOT_ACCESSIBLE, (Object)ot.getMaxAccess());
        TypesMibTest.assertEquals((Object)StatusV2.CURRENT, (Object)ot.getStatusV2());
        this.checkMyEnum(ot.getType());
    }

    private void checkMyEnum(SmiType type) {
        TypesMibTest.assertSame((Object)SmiConstants.INTEGER_TYPE, (Object)type.getBaseType());
        TypesMibTest.assertSame((Object)SmiPrimitiveType.ENUM, (Object)type.getPrimitiveType());
        TypesMibTest.assertNull((Object)type.getBitFields());
        TypesMibTest.assertNull((Object)type.getFields());
        TypesMibTest.assertNull((Object)type.getRangeConstraints());
        TypesMibTest.assertNull((Object)type.getSizeConstraints());
        List values = type.getEnumValues();
        TypesMibTest.assertEquals((int)3, (int)values.size());
        TypesMibTest.assertEquals((int)0, (int)((SmiNamedNumber)values.get(0)).getValue().intValue());
        TypesMibTest.assertEquals((String)"zero", (String)((SmiNamedNumber)values.get(0)).getId());
        TypesMibTest.assertEquals((int)1, (int)((SmiNamedNumber)values.get(1)).getValue().intValue());
        TypesMibTest.assertEquals((String)"one", (String)((SmiNamedNumber)values.get(1)).getId());
        TypesMibTest.assertEquals((int)57, (int)((SmiNamedNumber)values.get(2)).getValue().intValue());
        TypesMibTest.assertEquals((String)"fiftySeven", (String)((SmiNamedNumber)values.get(2)).getId());
    }

    public void testMyBits() {
        SmiType type = (SmiType)this.getMib().getTypes().find("MyBits");
        this.checkMyBits(type);
    }

    public void testTCMyBits() {
        SmiTextualConvention tc = (SmiTextualConvention)this.getMib().getTextualConventions().find("TCMyBits");
        TypesMibTest.assertEquals((String)(tc.getId() + " Desc"), (String)tc.getDescription());
        TypesMibTest.assertEquals((String)"255a", (String)tc.getDisplayHint());
        TypesMibTest.assertEquals((Object)StatusV2.DEPRECATED, (Object)tc.getStatusV2());
        this.checkMyBits((SmiType)tc);
    }

    public void testOTMyBits() {
        SmiObjectType ot = (SmiObjectType)this.getMib().getVariables().find("myBits");
        TypesMibTest.assertEquals((String)(ot.getId() + " Desc"), (String)ot.getDescription());
        TypesMibTest.assertEquals((Object)ObjectTypeAccessV2.NOT_ACCESSIBLE, (Object)ot.getMaxAccess());
        TypesMibTest.assertEquals((Object)StatusV2.CURRENT, (Object)ot.getStatusV2());
        this.checkMyBits(ot.getType());
    }

    private void checkMyBits(SmiType type) {
        TypesMibTest.assertSame((Object)SmiConstants.BITS_TYPE, (Object)type.getBaseType());
        TypesMibTest.assertSame((Object)SmiPrimitiveType.BITS, (Object)type.getPrimitiveType());
        TypesMibTest.assertNull((Object)type.getEnumValues());
        TypesMibTest.assertNull((Object)type.getFields());
        TypesMibTest.assertNull((Object)type.getRangeConstraints());
        TypesMibTest.assertNull((Object)type.getSizeConstraints());
        List values = type.getBitFields();
        TypesMibTest.assertEquals((int)3, (int)values.size());
        TypesMibTest.assertEquals((int)0, (int)((SmiNamedNumber)values.get(0)).getValue().intValue());
        TypesMibTest.assertEquals((String)"zero", (String)((SmiNamedNumber)values.get(0)).getId());
        TypesMibTest.assertEquals((int)1, (int)((SmiNamedNumber)values.get(1)).getValue().intValue());
        TypesMibTest.assertEquals((String)"one", (String)((SmiNamedNumber)values.get(1)).getId());
        TypesMibTest.assertEquals((int)57, (int)((SmiNamedNumber)values.get(2)).getValue().intValue());
        TypesMibTest.assertEquals((String)"fiftySeven", (String)((SmiNamedNumber)values.get(2)).getId());
    }

    public void testMyOctetString() {
        SmiType type = (SmiType)this.getMib().getTypes().find("MyOctetString");
        this.checkMyOctetString(type);
    }

    public void testMyDerivedOctetString() {
        SmiType type = (SmiType)this.getMib().getTypes().find("MyDerivedOctetString");
        TypesMibTest.assertNotNull((Object)type);
        SmiType myOctetStringType = (SmiType)this.getMib().getTypes().find("MyOctetString");
        TypesMibTest.assertNotNull((Object)myOctetStringType);
        TypesMibTest.assertSame((Object)myOctetStringType, (Object)type.getBaseType());
        TypesMibTest.assertSame((Object)SmiConstants.OCTET_STRING_TYPE, (Object)type.getBaseType().getBaseType());
        TypesMibTest.assertSame((Object)SmiPrimitiveType.OCTET_STRING, (Object)type.getPrimitiveType());
        TypesMibTest.assertNull((Object)type.getEnumValues());
        TypesMibTest.assertNull((Object)type.getBitFields());
        TypesMibTest.assertNull((Object)type.getFields());
        TypesMibTest.assertNull((Object)type.getRangeConstraints());
        TypesMibTest.assertNull((Object)type.getSizeConstraints());
    }

    public void testMyDerivedOctetStringBetween3And5() {
        SmiType type = (SmiType)this.getMib().getTypes().find("MyDerivedOctetStringBetween3And5");
        TypesMibTest.assertNotNull((Object)type);
        SmiType myOctetStringType = (SmiType)this.getMib().getTypes().find("MyOctetString");
        TypesMibTest.assertNotNull((Object)myOctetStringType);
        TypesMibTest.assertSame((Object)myOctetStringType, (Object)type.getBaseType());
        TypesMibTest.assertSame((Object)SmiConstants.OCTET_STRING_TYPE, (Object)type.getBaseType().getBaseType());
        TypesMibTest.assertSame((Object)SmiPrimitiveType.OCTET_STRING, (Object)type.getPrimitiveType());
        TypesMibTest.assertNull((Object)type.getEnumValues());
        TypesMibTest.assertNull((Object)type.getBitFields());
        TypesMibTest.assertNull((Object)type.getFields());
        TypesMibTest.assertNull((Object)type.getRangeConstraints());
        List constraints = type.getSizeConstraints();
        TypesMibTest.assertNotNull((Object)constraints);
        TypesMibTest.assertEquals((int)1, (int)constraints.size());
        TypesMibTest.assertEquals((Object)new BigInteger("3"), (Object)((SmiRange)constraints.get(0)).getMinValue());
        TypesMibTest.assertEquals((Object)new BigInteger("5"), (Object)((SmiRange)constraints.get(0)).getMaxValue());
    }

    public void testTCMyOctetString() {
        SmiTextualConvention tc = (SmiTextualConvention)this.getMib().getTextualConventions().find("TCMyOctetString");
        TypesMibTest.assertEquals((String)(tc.getId() + " Desc"), (String)tc.getDescription());
        TypesMibTest.assertEquals((String)"255a", (String)tc.getDisplayHint());
        TypesMibTest.assertEquals((Object)StatusV2.DEPRECATED, (Object)tc.getStatusV2());
        this.checkMyOctetString((SmiType)tc);
    }

    public void testOTMyOctetString() {
        SmiObjectType ot = (SmiObjectType)this.getMib().getVariables().find("myOctetString");
        TypesMibTest.assertEquals((String)(ot.getId() + " Desc"), (String)ot.getDescription());
        TypesMibTest.assertEquals((Object)ObjectTypeAccessV2.NOT_ACCESSIBLE, (Object)ot.getMaxAccess());
        TypesMibTest.assertEquals((Object)StatusV2.CURRENT, (Object)ot.getStatusV2());
        SmiType type = ot.getType();
        TypesMibTest.assertSame((Object)SmiConstants.OCTET_STRING_TYPE, (Object)type);
        TypesMibTest.assertSame((Object)SmiPrimitiveType.OCTET_STRING, (Object)type.getPrimitiveType());
        TypesMibTest.assertNull((Object)type.getEnumValues());
        TypesMibTest.assertNull((Object)type.getBitFields());
        TypesMibTest.assertNull((Object)type.getFields());
        TypesMibTest.assertNull((Object)type.getRangeConstraints());
        TypesMibTest.assertNull((Object)type.getSizeConstraints());
    }

    private void checkMyOctetString(SmiType type) {
        TypesMibTest.assertSame((Object)SmiConstants.OCTET_STRING_TYPE, (Object)type.getBaseType());
        TypesMibTest.assertSame((Object)SmiPrimitiveType.OCTET_STRING, (Object)type.getPrimitiveType());
        TypesMibTest.assertNull((Object)type.getEnumValues());
        TypesMibTest.assertNull((Object)type.getBitFields());
        TypesMibTest.assertNull((Object)type.getFields());
        TypesMibTest.assertNull((Object)type.getRangeConstraints());
        TypesMibTest.assertNull((Object)type.getSizeConstraints());
    }

    public void testMyOctetStringBetweenSize9And5() {
        SmiType type = (SmiType)this.getMib().getTypes().find("MyOctetStringBetweenSize9And5");
        this.checkMyOctetStringBetweenSize9And5(type);
    }

    public void testTCMyOctetStringBetweenSize9And5() {
        SmiTextualConvention tc = (SmiTextualConvention)this.getMib().getTextualConventions().find("TCMyOctetStringBetweenSize9And5");
        TypesMibTest.assertEquals((String)(tc.getId() + " Desc"), (String)tc.getDescription());
        TypesMibTest.assertEquals((String)"255a", (String)tc.getDisplayHint());
        TypesMibTest.assertEquals((Object)StatusV2.DEPRECATED, (Object)tc.getStatusV2());
        this.checkMyOctetStringBetweenSize9And5((SmiType)tc);
    }

    public void testOTMyOctetStringBetweenSize9And5() {
        SmiObjectType ot = (SmiObjectType)this.getMib().getVariables().find("myOctetStringBetweenSize9And5");
        TypesMibTest.assertEquals((String)(ot.getId() + " Desc"), (String)ot.getDescription());
        TypesMibTest.assertEquals((Object)ObjectTypeAccessV2.NOT_ACCESSIBLE, (Object)ot.getMaxAccess());
        TypesMibTest.assertEquals((Object)StatusV2.CURRENT, (Object)ot.getStatusV2());
        this.checkMyOctetStringBetweenSize9And5(ot.getType());
    }

    private void checkMyOctetStringBetweenSize9And5(SmiType type) {
        TypesMibTest.assertSame((Object)SmiConstants.OCTET_STRING_TYPE, (Object)type.getBaseType());
        TypesMibTest.assertSame((Object)SmiPrimitiveType.OCTET_STRING, (Object)type.getPrimitiveType());
        TypesMibTest.assertNull((Object)type.getEnumValues());
        TypesMibTest.assertNull((Object)type.getBitFields());
        TypesMibTest.assertNull((Object)type.getFields());
        TypesMibTest.assertNull((Object)type.getRangeConstraints());
        List constraints = type.getSizeConstraints();
        TypesMibTest.assertEquals((int)1, (int)constraints.size());
        TypesMibTest.assertEquals((int)9, (int)((SmiRange)constraints.get(0)).getMinValue().intValue());
        TypesMibTest.assertEquals((int)5, (int)((SmiRange)constraints.get(0)).getMaxValue().intValue());
    }

    public void testOTMyOctetStringOfSize11() {
        SmiVariable ot = (SmiVariable)this.getMib().getVariables().find("myOctetStringOfSize11");
        TypesMibTest.assertEquals((String)(ot.getId() + " Desc"), (String)ot.getDescription());
        TypesMibTest.assertEquals((Object)ObjectTypeAccessV2.NOT_ACCESSIBLE, (Object)ot.getMaxAccess());
        TypesMibTest.assertEquals((Object)StatusV2.CURRENT, (Object)ot.getStatusV2());
        TypesMibTest.assertNotNull((Object)ot.getSizeConstraints());
        SmiType type = ot.getType();
        TypesMibTest.assertSame((Object)SmiConstants.OCTET_STRING_TYPE, (Object)type.getBaseType());
        TypesMibTest.assertSame((Object)SmiPrimitiveType.OCTET_STRING, (Object)type.getPrimitiveType());
        TypesMibTest.assertNull((Object)type.getEnumValues());
        TypesMibTest.assertNull((Object)type.getBitFields());
        TypesMibTest.assertNull((Object)type.getFields());
        TypesMibTest.assertNull((Object)type.getRangeConstraints());
        List constraints = type.getSizeConstraints();
        TypesMibTest.assertEquals((int)1, (int)constraints.size());
        TypesMibTest.assertTrue((boolean)((SmiRange)constraints.get(0)).isSingle());
        TypesMibTest.assertEquals((int)11, (int)((SmiRange)constraints.get(0)).getMinValue().intValue());
        TypesMibTest.assertEquals((int)11, (int)((SmiRange)constraints.get(0)).getMaxValue().intValue());
    }

    public void testMyCounter() {
        SmiType type = (SmiType)this.getMib().getTypes().find("MyCounter");
        this.checkMyCounter(type);
    }

    public void testTCMyCounter() {
        SmiTextualConvention tc = (SmiTextualConvention)this.getMib().getTextualConventions().find("TCMyCounter");
        TypesMibTest.assertEquals((String)(tc.getId() + " Desc"), (String)tc.getDescription());
        TypesMibTest.assertEquals((String)"255a", (String)tc.getDisplayHint());
        TypesMibTest.assertEquals((Object)StatusV2.DEPRECATED, (Object)tc.getStatusV2());
        this.checkMyCounter((SmiType)tc);
    }

    public void testOTMyCounter() {
        SmiObjectType ot = (SmiObjectType)this.getMib().getVariables().find("myCounter");
        TypesMibTest.assertEquals((String)(ot.getId() + " Desc"), (String)ot.getDescription());
        TypesMibTest.assertEquals((Object)ObjectTypeAccessV2.NOT_ACCESSIBLE, (Object)ot.getMaxAccess());
        TypesMibTest.assertEquals((Object)StatusV2.CURRENT, (Object)ot.getStatusV2());
        SmiType type = ot.getType();
        TypesMibTest.assertSame((Object)this.getCounter(), (Object)type);
        TypesMibTest.assertSame((Object)SmiPrimitiveType.COUNTER_32, (Object)type.getPrimitiveType());
        TypesMibTest.assertNull((Object)type.getEnumValues());
        TypesMibTest.assertNull((Object)type.getBitFields());
        TypesMibTest.assertNull((Object)type.getFields());
        TypesMibTest.assertEquals((int)1, (int)type.getRangeConstraints().size());
        TypesMibTest.assertNull((Object)type.getSizeConstraints());
    }

    private void checkMyCounter(SmiType type) {
        TypesMibTest.assertSame((Object)this.getCounter(), (Object)type.getBaseType());
        TypesMibTest.assertSame((Object)SmiPrimitiveType.COUNTER_32, (Object)type.getPrimitiveType());
        TypesMibTest.assertNull((Object)type.getEnumValues());
        TypesMibTest.assertNull((Object)type.getBitFields());
        TypesMibTest.assertNull((Object)type.getFields());
        TypesMibTest.assertNull((Object)type.getRangeConstraints());
        TypesMibTest.assertNull((Object)type.getSizeConstraints());
    }

    public void testMyCounterFromMinus100To100() {
        SmiType type = (SmiType)this.getMib().getTypes().find("MyCounterFromMinus100To100");
        this.checkMyCounterFromMinus100To100(type);
    }

    public void testTCMyCounterFromMinus5To6() {
        SmiTextualConvention tc = (SmiTextualConvention)this.getMib().getTextualConventions().find("TCMyCounterFromMinus100To100");
        TypesMibTest.assertEquals((String)(tc.getId() + " Desc"), (String)tc.getDescription());
        TypesMibTest.assertEquals((String)"255a", (String)tc.getDisplayHint());
        TypesMibTest.assertEquals((Object)StatusV2.DEPRECATED, (Object)tc.getStatusV2());
        this.checkMyCounterFromMinus100To100((SmiType)tc);
    }

    public void testOTMyCounterFromMinus100To100() {
        SmiObjectType ot = (SmiObjectType)this.getMib().getVariables().find("myCounterFromMinus100To100");
        TypesMibTest.assertEquals((String)(ot.getId() + " Desc"), (String)ot.getDescription());
        TypesMibTest.assertEquals((Object)ObjectTypeAccessV2.NOT_ACCESSIBLE, (Object)ot.getMaxAccess());
        TypesMibTest.assertEquals((Object)StatusV2.CURRENT, (Object)ot.getStatusV2());
        this.checkMyCounterFromMinus100To100(ot.getType());
    }

    private void checkMyCounterFromMinus100To100(SmiType type) {
        TypesMibTest.assertSame((Object)this.getCounter(), (Object)type.getBaseType());
        TypesMibTest.assertSame((Object)SmiPrimitiveType.COUNTER_32, (Object)type.getPrimitiveType());
        TypesMibTest.assertNull((Object)type.getEnumValues());
        TypesMibTest.assertNull((Object)type.getBitFields());
        TypesMibTest.assertNull((Object)type.getFields());
        TypesMibTest.assertNull((Object)type.getSizeConstraints());
        TypesMibTest.assertEquals((int)1, (int)type.getRangeConstraints().size());
        TypesMibTest.assertEquals((int)-100, (int)((SmiRange)type.getRangeConstraints().get(0)).getMinValue().intValue());
        TypesMibTest.assertEquals((int)100, (int)((SmiRange)type.getRangeConstraints().get(0)).getMaxValue().intValue());
    }

    public void testMyUnsigned32() {
        SmiObjectType ot = (SmiObjectType)this.getMib().getVariables().find("myUnsigned32");
        TypesMibTest.assertNotNull((Object)ot);
        TypesMibTest.assertNotNull((Object)ot.getType());
        TypesMibTest.assertEquals((Object)SmiPrimitiveType.UNSIGNED_32, (Object)ot.getType().getPrimitiveType());
    }

    public void testMyTimeTicks() {
        SmiObjectType ot = (SmiObjectType)this.getMib().getVariables().find("myTimeTicks");
        TypesMibTest.assertNotNull((Object)ot);
        TypesMibTest.assertNotNull((Object)ot.getType());
        TypesMibTest.assertEquals((Object)SmiPrimitiveType.TIME_TICKS, (Object)ot.getType().getPrimitiveType());
    }
}

