/*
 * Decompiled with CFR 0.152.
 */
package org.jsmiparser.smi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jsmiparser.phase.xref.XRefProblemReporter;
import org.jsmiparser.smi.Notification;
import org.jsmiparser.smi.SmiModule;
import org.jsmiparser.smi.SmiOidMacro;
import org.jsmiparser.smi.SmiVariable;
import org.jsmiparser.smi.StatusV2;
import org.jsmiparser.util.token.IdToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmiNotificationType
extends SmiOidMacro
implements Notification {
    private List<IdToken> m_objectTokens;
    private List<SmiVariable> m_objects = new ArrayList<SmiVariable>();
    private StatusV2 m_statusV2;
    private String m_description;
    private String m_reference;

    public SmiNotificationType(IdToken idToken, SmiModule module, List<IdToken> objectTokens, StatusV2 statusV2, String description, String reference) {
        super(idToken, module);
        this.m_objectTokens = objectTokens;
        if (this.m_objectTokens == null) {
            this.m_objectTokens = Collections.emptyList();
        }
        this.m_statusV2 = statusV2;
        this.m_description = description;
        this.m_reference = reference;
    }

    @Override
    public void resolveReferences(XRefProblemReporter reporter) {
        for (IdToken objectToken : this.m_objectTokens) {
            SmiVariable variable = this.getModule().resolveReference(objectToken, SmiVariable.class, reporter);
            if (variable == null) continue;
            this.m_objects.add(variable);
        }
    }

    @Override
    public List<SmiVariable> getObjects() {
        return this.m_objects;
    }

    @Override
    public List<IdToken> getObjectTokens() {
        return this.m_objectTokens;
    }

    @Override
    public StatusV2 getStatusV2() {
        return this.m_statusV2;
    }

    @Override
    public String getDescription() {
        return this.m_description;
    }

    @Override
    public String getReference() {
        return this.m_reference;
    }
}

