/*
 * Decompiled with CFR 0.152.
 */
package org.jsmiparser.smi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.collections.map.MultiValueMap;
import org.jsmiparser.smi.SmiModule;
import org.jsmiparser.smi.SmiSymbol;
import org.jsmiparser.smi.SmiSymbolMap;
import org.jsmiparser.util.multimap.GenMultiMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SmiSymbolMapImpl<T extends SmiSymbol>
extends GenMultiMap<String, T>
implements SmiSymbolMap<T> {
    private final Class<T> m_symbolClass;
    private final Map<String, SmiModule> m_moduleMap;

    public SmiSymbolMapImpl(Class<T> symbolClass, Map<String, SmiModule> moduleMap) {
        super((MultiMap)MultiValueMap.decorate(new HashMap(), ArrayList.class));
        this.m_symbolClass = symbolClass;
        this.m_moduleMap = moduleMap;
    }

    @Override
    public T find(String symbolId) throws IllegalArgumentException {
        return (T)((SmiSymbol)this.getOne(symbolId));
    }

    @Override
    public T find(String moduleId, String symbolId) throws IllegalArgumentException {
        if (moduleId != null) {
            SmiModule module = this.m_moduleMap.get(moduleId);
            if (module == null) {
                throw new IllegalArgumentException("Module " + moduleId + " could not be found.");
            }
            SmiSymbol symbol = module.findSymbol(symbolId);
            if (symbol == null) {
                return null;
            }
            if (this.m_symbolClass.isAssignableFrom(symbol.getClass())) {
                return (T)((SmiSymbol)this.m_symbolClass.cast(symbol));
            }
            return null;
        }
        return (T)((SmiSymbol)this.getOne(symbolId));
    }

    @Override
    public List<T> findAll(String symbolId) {
        return this.getAll(symbolId);
    }

    @Override
    public Collection<T> getAll() {
        return this.m_impl.values();
    }

    @Override
    public Iterator<T> iterator() {
        return this.m_impl.values().iterator();
    }
}

