// $ANTLR : "SMIParser.g" -> "SMIParser.java"$

package org.jsmiparser.phase.file.antlr;

import org.jsmiparser.util.token.*;
import org.jsmiparser.smi.*;
import org.jsmiparser.phase.file.*;
import org.jsmiparser.util.location.Location;

import antlr.*;
import java.lang.* ;
import java.math.*;
import java.util.*;

import antlr.TokenBuffer;
import antlr.TokenStreamException;
import antlr.TokenStreamIOException;
import antlr.ANTLRException;
import antlr.LLkParser;
import antlr.Token;
import antlr.TokenStream;
import antlr.RecognitionException;
import antlr.NoViableAltException;
import antlr.MismatchedTokenException;
import antlr.SemanticException;
import antlr.ParserSharedInputState;
import antlr.collections.impl.BitSet;

public class SMIParser extends antlr.LLkParser       implements SMITokenTypes
 {

    private SmiMib m_mib;
    private String m_locationPath;
	private ModuleParser m_mp;

    public void init(SmiMib mib, String locationPath) {
        m_mib = mib;
        m_locationPath = locationPath;
    }

    SmiModule beginModule(Token idToken) {
        if (m_mp != null) {
            throw new IllegalStateException("Module " + m_mp.getModule().getIdToken() + " is still being parsed when trying to create new module " + idToken);
        }
        SmiModule module = m_mib.createModule(idt(idToken));
        m_mp = new ModuleParser(module);
        return module;
    }

    private void endModule() {
        if (m_mp == null) {
            throw new IllegalStateException("No module is being parsed");
        }
        m_mp = null;
    }

    private Location makeLocation(Token token) {
        return new Location(m_locationPath, token.getLine(), token.getColumn());
    }

    private IdToken idt(Token idToken) {
        return new IdToken(makeLocation(idToken), idToken.getText());
    }


protected SMIParser(TokenBuffer tokenBuf, int k) {
  super(tokenBuf,k);
  tokenNames = _tokenNames;
}

public SMIParser(TokenBuffer tokenBuf) {
  this(tokenBuf,3);
}

protected SMIParser(TokenStream lexer, int k) {
  super(lexer,k);
  tokenNames = _tokenNames;
}

public SMIParser(TokenStream lexer) {
  this(lexer,3);
}

public SMIParser(ParserSharedInputState state) {
  super(state,3);
  tokenNames = _tokenNames;
}

	public final SmiModule  module_definition() throws RecognitionException, TokenStreamException {
		SmiModule result = null;
		
		
		switch ( LA(1)) {
		case EOF:
		{
			match(Token.EOF_TYPE);
			break;
		}
		case UPPER:
		case LOWER:
		{
			result=module_identifier();
			match(DEFINITIONS_KW);
			match(ASSIGN_OP);
			match(BEGIN_KW);
			module_body();
			match(END_KW);
			if ( inputState.guessing==0 ) {
				endModule();
			}
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		return result;
	}
	
	public final SmiModule  module_identifier() throws RecognitionException, TokenStreamException {
		SmiModule result = null;
		
		Token  u = null;
		Token  l = null;
		
		{
		switch ( LA(1)) {
		case UPPER:
		{
			u = LT(1);
			match(UPPER);
			break;
		}
		case LOWER:
		{
			l = LT(1);
			match(LOWER);
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		if ( inputState.guessing==0 ) {
			
			// TODO error msg: only upper is correct
				result = beginModule(u != null ? u : l);
			
		}
		return result;
	}
	
	public final void module_body() throws RecognitionException, TokenStreamException {
		
		
		{
		switch ( LA(1)) {
		case EXPORTS_KW:
		{
			exports();
			break;
		}
		case END_KW:
		case IMPORTS_KW:
		case UPPER:
		case LOWER:
		case 126:
		case 127:
		case 128:
		case 129:
		case 130:
		case 131:
		case 132:
		case 133:
		case 134:
		case 135:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		{
		switch ( LA(1)) {
		case IMPORTS_KW:
		{
			imports();
			break;
		}
		case END_KW:
		case UPPER:
		case LOWER:
		case 126:
		case 127:
		case 128:
		case 129:
		case 130:
		case 131:
		case 132:
		case 133:
		case 134:
		case 135:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		{
		_loop88:
		do {
			if ((_tokenSet_0.member(LA(1)))) {
				assignment();
			}
			else {
				break _loop88;
			}
			
		} while (true);
		}
	}
	
	public final void exports() throws RecognitionException, TokenStreamException {
		
		
		match(EXPORTS_KW);
		{
		symbol_list();
		}
		match(SEMI);
	}
	
	public final void imports() throws RecognitionException, TokenStreamException {
		
		
		match(IMPORTS_KW);
		{
		_loop93:
		do {
			if ((_tokenSet_0.member(LA(1)))) {
				symbols_from_module();
			}
			else {
				break _loop93;
			}
			
		} while (true);
		}
		match(SEMI);
	}
	
	public final SmiSymbol  assignment() throws RecognitionException, TokenStreamException {
		SmiSymbol s = null;
		
		Token  u = null;
		Token  l = null;
		
		IdToken intToken = null;
		SmiType type = null;
		IdToken mn = null;
		
		
		{
		switch ( LA(1)) {
		case UPPER:
		{
			u = LT(1);
			match(UPPER);
			match(ASSIGN_OP);
			s=type_assignment(m_mp.idt(u));
			break;
		}
		case LOWER:
		{
			l = LT(1);
			match(LOWER);
			s=value_assignment(m_mp.idt(l));
			break;
		}
		case 126:
		case 127:
		case 128:
		case 129:
		case 130:
		case 131:
		case 132:
		case 133:
		case 134:
		case 135:
		{
			mn=macroName();
			match(LITERAL_MACRO);
			match(ASSIGN_OP);
			match(BEGIN_KW);
			{
			_loop105:
			do {
				if ((_tokenSet_1.member(LA(1)))) {
					{
					match(_tokenSet_1);
					}
				}
				else {
					break _loop105;
				}
				
			} while (true);
			}
			match(END_KW);
			if ( inputState.guessing==0 ) {
				s = m_mp.createMacro(mn);
			}
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		if ( inputState.guessing==0 ) {
			
				    m_mp.addSymbol(s);
				
		}
		return s;
	}
	
	public final List<IdToken>  symbol_list() throws RecognitionException, TokenStreamException {
		List<IdToken> result = m_mp.makeIdTokenList();
		
		
			IdToken s1 = null, s2 = null;
		
		
		s1=symbol();
		if ( inputState.guessing==0 ) {
			result.add(s1);
		}
		{
		_loop97:
		do {
			if ((LA(1)==COMMA)) {
				match(COMMA);
				s2=symbol();
				if ( inputState.guessing==0 ) {
					result.add(s2);
				}
			}
			else {
				break _loop97;
			}
			
		} while (true);
		}
		return result;
	}
	
	public final void symbols_from_module() throws RecognitionException, TokenStreamException {
		
		
			List<IdToken> idTokenList = null;
			IdToken m = null;
		
		
		idTokenList=symbol_list();
		match(FROM_KW);
		m=upper();
		if ( inputState.guessing==0 ) {
			
				m_mp.addImports(m, idTokenList);
			
		}
	}
	
	public final IdToken  upper() throws RecognitionException, TokenStreamException {
		IdToken result = null;
		
		Token  u = null;
		
		u = LT(1);
		match(UPPER);
		if ( inputState.guessing==0 ) {
			
				result = m_mp.idt(u);
			
		}
		return result;
	}
	
	public final IdToken  symbol() throws RecognitionException, TokenStreamException {
		IdToken result = null;
		
		
		switch ( LA(1)) {
		case UPPER:
		{
			result=upper();
			break;
		}
		case LOWER:
		{
			result=lower();
			break;
		}
		case 126:
		case 127:
		case 128:
		case 129:
		case 130:
		case 131:
		case 132:
		case 133:
		case 134:
		case 135:
		{
			result=macroName();
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		return result;
	}
	
	public final IdToken  lower() throws RecognitionException, TokenStreamException {
		IdToken result = null;
		
		Token  l = null;
		
		l = LT(1);
		match(LOWER);
		if ( inputState.guessing==0 ) {
			
				result = m_mp.idt(l);
			
		}
		return result;
	}
	
	public final IdToken  macroName() throws RecognitionException, TokenStreamException {
		IdToken result = null;
		
		Token  ot = null;
		Token  mi = null;
		Token  oi = null;
		Token  nt = null;
		Token  tc = null;
		Token  og = null;
		Token  ng = null;
		Token  mc = null;
		Token  ac = null;
		Token  tt = null;
		
		{
		switch ( LA(1)) {
		case 126:
		{
			ot = LT(1);
			match(126);
			break;
		}
		case 127:
		{
			mi = LT(1);
			match(127);
			if ( inputState.guessing==0 ) {
				m_mp.getModule().incV2Features();
			}
			break;
		}
		case 128:
		{
			oi = LT(1);
			match(128);
			if ( inputState.guessing==0 ) {
				m_mp.getModule().incV2Features();
			}
			break;
		}
		case 129:
		{
			nt = LT(1);
			match(129);
			if ( inputState.guessing==0 ) {
				m_mp.getModule().incV2Features();
			}
			break;
		}
		case 130:
		{
			tc = LT(1);
			match(130);
			if ( inputState.guessing==0 ) {
				m_mp.getModule().incV2Features();
			}
			break;
		}
		case 131:
		{
			og = LT(1);
			match(131);
			if ( inputState.guessing==0 ) {
				m_mp.getModule().incV2Features();
			}
			break;
		}
		case 132:
		{
			ng = LT(1);
			match(132);
			if ( inputState.guessing==0 ) {
				m_mp.getModule().incV2Features();
			}
			break;
		}
		case 133:
		{
			mc = LT(1);
			match(133);
			if ( inputState.guessing==0 ) {
				m_mp.getModule().incV2Features();
			}
			break;
		}
		case 134:
		{
			ac = LT(1);
			match(134);
			if ( inputState.guessing==0 ) {
				m_mp.getModule().incV2Features();
			}
			break;
		}
		case 135:
		{
			tt = LT(1);
			match(135);
			if ( inputState.guessing==0 ) {
				m_mp.getModule().incV1Features();
			}
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		if ( inputState.guessing==0 ) {
			
				result = m_mp.idt(ot, mi, oi, nt, tc, og, ng, mc, ac, tt);
			
		}
		return result;
	}
	
	public final SmiType  type_assignment(
		IdToken idToken
	) throws RecognitionException, TokenStreamException {
		SmiType t = null;
		
		
		switch ( LA(1)) {
		case 130:
		{
			t=textualconvention_macro(idToken);
			break;
		}
		case INTEGER_KW:
		case OBJECT_KW:
		case OCTET_KW:
		case L_BRACKET:
		case UPPER:
		case LITERAL_BITS:
		{
			t=leaf_type(idToken);
			break;
		}
		case SEQUENCE_KW:
		{
			t=sequence_type(idToken);
			break;
		}
		case CHOICE_KW:
		{
			t=choice_type(idToken);
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		return t;
	}
	
	public final SmiValue  value_assignment(
		IdToken idToken
	) throws RecognitionException, TokenStreamException {
		SmiValue v = null;
		
		
		switch ( LA(1)) {
		case 126:
		case 127:
		case 128:
		case 129:
		case 131:
		case 132:
		case 133:
		case 134:
		case 135:
		{
			v=macro_value_assignment(idToken);
			break;
		}
		case OBJECT_KW:
		{
			v=oid_value_assignment(idToken);
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		return v;
	}
	
	public final SmiTextualConvention  textualconvention_macro(
		IdToken idToken
	) throws RecognitionException, TokenStreamException {
		SmiTextualConvention tc=null;
		
		Token  displayHint = null;
		Token  description = null;
		Token  reference = null;
		
		SmiType type;
		StatusV2 status;
		
		
		match(130);
		{
		switch ( LA(1)) {
		case 153:
		{
			match(153);
			displayHint = LT(1);
			match(C_STRING);
			break;
		}
		case LITERAL_STATUS:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		match(LITERAL_STATUS);
		status=status_v2();
		match(LITERAL_DESCRIPTION);
		description = LT(1);
		match(C_STRING);
		{
		switch ( LA(1)) {
		case LITERAL_REFERENCE:
		{
			match(LITERAL_REFERENCE);
			reference = LT(1);
			match(C_STRING);
			break;
		}
		case LITERAL_SYNTAX:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		match(LITERAL_SYNTAX);
		type=leaf_type(null);
		if ( inputState.guessing==0 ) {
			
				    tc = m_mp.createTextualConvention(idToken, displayHint, status, description, reference, type);
				
		}
		return tc;
	}
	
	public final SmiType  leaf_type(
		IdToken idToken
	) throws RecognitionException, TokenStreamException {
		SmiType t = null;
		
		Token  n = null;
		
		{
		switch ( LA(1)) {
		case L_BRACKET:
		{
			match(L_BRACKET);
			match(APPLICATION_KW);
			n = LT(1);
			match(NUMBER);
			match(R_BRACKET);
			match(IMPLICIT_KW);
			break;
		}
		case INTEGER_KW:
		case OBJECT_KW:
		case OCTET_KW:
		case UPPER:
		case LITERAL_BITS:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		{
		switch ( LA(1)) {
		case INTEGER_KW:
		{
			t=integer_type(idToken, n);
			break;
		}
		case OBJECT_KW:
		{
			t=oid_type(idToken);
			break;
		}
		case OCTET_KW:
		{
			t=octet_string_type(idToken, n);
			break;
		}
		case LITERAL_BITS:
		{
			t=bits_type(idToken);
			break;
		}
		case UPPER:
		{
			t=defined_type(idToken);
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		return t;
	}
	
	public final SmiType  sequence_type(
		IdToken idToken
	) throws RecognitionException, TokenStreamException {
		SmiType t = null;
		
		
		match(SEQUENCE_KW);
		if ( inputState.guessing==0 ) {
			t = m_mp.createSequenceType(idToken);
		}
		match(L_BRACE);
		sequence_field(t);
		{
		_loop127:
		do {
			if ((LA(1)==COMMA)) {
				match(COMMA);
				sequence_field(t);
			}
			else {
				break _loop127;
			}
			
		} while (true);
		}
		match(R_BRACE);
		return t;
	}
	
	public final SmiType  choice_type(
		IdToken idToken
	) throws RecognitionException, TokenStreamException {
		SmiType t = null;
		
		
		match(CHOICE_KW);
		match(L_BRACE);
		{
		_loop121:
		do {
			if ((_tokenSet_2.member(LA(1)))) {
				{
				match(_tokenSet_2);
				}
			}
			else {
				break _loop121;
			}
			
		} while (true);
		}
		match(R_BRACE);
		if ( inputState.guessing==0 ) {
			
			return m_mp.createChoiceType(idToken);
			
		}
		return t;
	}
	
	public final SmiType  integer_type(
		IdToken idToken, Token applicationTagToken
	) throws RecognitionException, TokenStreamException {
		SmiType t = null;
		
		
		IntKeywordToken intToken;
		List<SmiNamedNumber> namedNumbers = null;
		List<SmiRange> rangeConstraints = null;
		
		
		intToken=integer_type_kw(idToken);
		{
		switch ( LA(1)) {
		case L_BRACE:
		{
			namedNumbers=named_number_list();
			break;
		}
		case L_PAREN:
		{
			rangeConstraints=range_constraint();
			break;
		}
		case END_KW:
		case COMMA:
		case R_BRACE:
		case UPPER:
		case LOWER:
		case 126:
		case 127:
		case 128:
		case 129:
		case 130:
		case 131:
		case 132:
		case 133:
		case 134:
		case 135:
		case LITERAL_UNITS:
		case LITERAL_ACCESS:
		case 141:
		case LITERAL_STATUS:
		case LITERAL_DESCRIPTION:
		case LITERAL_DEFVAL:
		case 158:
		case 159:
		case 163:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		if ( inputState.guessing==0 ) {
			
				    t = m_mp.createIntegerType(idToken, intToken, applicationTagToken, namedNumbers, rangeConstraints);
				
		}
		return t;
	}
	
	public final SmiType  oid_type(
		IdToken idToken
	) throws RecognitionException, TokenStreamException {
		SmiType t = null;
		
		
		match(OBJECT_KW);
		match(IDENTIFIER_KW);
		if ( inputState.guessing==0 ) {
			
				t = m_mp.createType(idToken, SmiConstants.OBJECT_IDENTIFIER_TYPE);
			
		}
		return t;
	}
	
	public final SmiType  octet_string_type(
		IdToken idToken, Token applicationTagToken
	) throws RecognitionException, TokenStreamException {
		SmiType type = null;
		
		
		List<SmiRange> sizeConstraints = null;
		
		
		match(OCTET_KW);
		match(STRING_KW);
		{
		switch ( LA(1)) {
		case L_PAREN:
		{
			sizeConstraints=size_constraint();
			break;
		}
		case END_KW:
		case COMMA:
		case R_BRACE:
		case UPPER:
		case LOWER:
		case 126:
		case 127:
		case 128:
		case 129:
		case 130:
		case 131:
		case 132:
		case 133:
		case 134:
		case 135:
		case LITERAL_UNITS:
		case LITERAL_ACCESS:
		case 141:
		case LITERAL_STATUS:
		case LITERAL_DESCRIPTION:
		case LITERAL_DEFVAL:
		case 158:
		case 159:
		case 163:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		if ( inputState.guessing==0 ) {
			
				    type = m_mp.createOctetStringType(idToken, applicationTagToken, sizeConstraints);
				
		}
		return type;
	}
	
	public final SmiType  bits_type(
		IdToken idToken
	) throws RecognitionException, TokenStreamException {
		SmiType type = null;
		
		
		List<SmiNamedNumber> namedNumbers = null;
		
		
		match(LITERAL_BITS);
		{
		switch ( LA(1)) {
		case L_BRACE:
		{
			namedNumbers=named_number_list();
			break;
		}
		case END_KW:
		case COMMA:
		case R_BRACE:
		case UPPER:
		case LOWER:
		case 126:
		case 127:
		case 128:
		case 129:
		case 130:
		case 131:
		case 132:
		case 133:
		case 134:
		case 135:
		case LITERAL_UNITS:
		case LITERAL_ACCESS:
		case 141:
		case LITERAL_STATUS:
		case LITERAL_DESCRIPTION:
		case LITERAL_DEFVAL:
		case 158:
		case 159:
		case 163:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		if ( inputState.guessing==0 ) {
			
			type = m_mp.createBitsType(idToken, namedNumbers);
				
		}
		return type;
	}
	
	public final SmiType  defined_type(
		IdToken idToken
	) throws RecognitionException, TokenStreamException {
		SmiType type = null;
		
		Token  mt = null;
		Token  tt = null;
		
		List<SmiNamedNumber> namedNumbers = null;
		List<SmiRange> sizeConstraints = null;
		List<SmiRange> rangeConstraints = null;
		
		
		{
		if ((LA(1)==UPPER) && (LA(2)==DOT)) {
			mt = LT(1);
			match(UPPER);
			match(DOT);
		}
		else if ((LA(1)==UPPER) && (_tokenSet_3.member(LA(2)))) {
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
		}
		tt = LT(1);
		match(UPPER);
		{
		switch ( LA(1)) {
		case L_BRACE:
		{
			namedNumbers=named_number_list();
			break;
		}
		case END_KW:
		case COMMA:
		case R_BRACE:
		case UPPER:
		case LOWER:
		case 126:
		case 127:
		case 128:
		case 129:
		case 130:
		case 131:
		case 132:
		case 133:
		case 134:
		case 135:
		case LITERAL_UNITS:
		case LITERAL_ACCESS:
		case 141:
		case LITERAL_STATUS:
		case LITERAL_DESCRIPTION:
		case LITERAL_DEFVAL:
		case 158:
		case 159:
		case 163:
		{
			break;
		}
		default:
			if ((LA(1)==L_PAREN) && (LA(2)==SIZE_KW)) {
				sizeConstraints=size_constraint();
			}
			else if ((LA(1)==L_PAREN) && (_tokenSet_4.member(LA(2)))) {
				rangeConstraints=range_constraint();
			}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		if ( inputState.guessing==0 ) {
			
				    type = m_mp.createDefinedType(idToken, mt, tt, namedNumbers, sizeConstraints, rangeConstraints);
				
		}
		return type;
	}
	
	public final IntKeywordToken  integer_type_kw(
		IdToken idToken
	) throws RecognitionException, TokenStreamException {
		IntKeywordToken t = null;
		
		Token  i = null;
		
		i = LT(1);
		match(INTEGER_KW);
		if ( inputState.guessing==0 ) {
			t = m_mp.intkt(i, SmiPrimitiveType.INTEGER, null);
		}
		return t;
	}
	
	public final List<SmiNamedNumber>  named_number_list() throws RecognitionException, TokenStreamException {
		List<SmiNamedNumber> l = new ArrayList<SmiNamedNumber>();
		
		
		match(L_BRACE);
		named_number(l);
		{
		_loop242:
		do {
			if ((LA(1)==COMMA)) {
				match(COMMA);
				named_number(l);
			}
			else {
				break _loop242;
			}
			
		} while (true);
		}
		match(R_BRACE);
		return l;
	}
	
	public final List<SmiRange>  range_constraint() throws RecognitionException, TokenStreamException {
		List<SmiRange> rc = null;
		
		
		match(L_PAREN);
		if ( inputState.guessing==0 ) {
			rc = new ArrayList<SmiRange>();
		}
		range(rc);
		{
		_loop133:
		do {
			if ((LA(1)==BAR)) {
				match(BAR);
				range(rc);
			}
			else {
				break _loop133;
			}
			
		} while (true);
		}
		match(R_PAREN);
		return rc;
	}
	
	public final List<SmiRange>  size_constraint() throws RecognitionException, TokenStreamException {
		List<SmiRange> rc = null;
		
		
		match(L_PAREN);
		match(SIZE_KW);
		rc=range_constraint();
		match(R_PAREN);
		return rc;
	}
	
	public final void sequence_field(
		SmiType sequenceType
	) throws RecognitionException, TokenStreamException {
		
		Token  l = null;
		
			SmiType fieldType = null;
		
		
		l = LT(1);
		match(LOWER);
		fieldType=leaf_type(null);
		if ( inputState.guessing==0 ) {
			
				m_mp.addField(sequenceType, l, fieldType);
			
		}
	}
	
	public final SmiType  sequenceof_type() throws RecognitionException, TokenStreamException {
		SmiType t = null;
		
		Token  u = null;
		
		match(SEQUENCE_KW);
		match(OF_KW);
		u = LT(1);
		match(UPPER);
		if ( inputState.guessing==0 ) {
			
				t = m_mp.createSequenceOfType(u);
			
		}
		return t;
	}
	
	public final void range(
		List<SmiRange> rc
	) throws RecognitionException, TokenStreamException {
		
		
			org.jsmiparser.util.token.Token rv1 = null;
			org.jsmiparser.util.token.Token rv2 = null;
		
		
		rv1=range_value();
		{
		switch ( LA(1)) {
		case DOTDOT:
		{
			match(DOTDOT);
			rv2=range_value();
			break;
		}
		case BAR:
		case R_PAREN:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		if ( inputState.guessing==0 ) {
			
				m_mp.addRange(rc, rv1, rv2);
			
		}
	}
	
	public final org.jsmiparser.util.token.Token  range_value() throws RecognitionException, TokenStreamException {
		org.jsmiparser.util.token.Token t = null;
		
		
		switch ( LA(1)) {
		case MINUS:
		case NUMBER:
		{
			t=big_integer_token();
			break;
		}
		case B_STRING:
		{
			t=binary_string_token();
			break;
		}
		case H_STRING:
		{
			t=hex_string_token();
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		return t;
	}
	
	public final BigIntegerToken  big_integer_token() throws RecognitionException, TokenStreamException {
		BigIntegerToken bit = null;
		
		Token  mt = null;
		Token  nt = null;
		
		{
		switch ( LA(1)) {
		case MINUS:
		{
			mt = LT(1);
			match(MINUS);
			break;
		}
		case NUMBER:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		nt = LT(1);
		match(NUMBER);
		if ( inputState.guessing==0 ) {
			bit = m_mp.bintt(mt, nt);
		}
		return bit;
	}
	
	public final BinaryStringToken  binary_string_token() throws RecognitionException, TokenStreamException {
		BinaryStringToken t = null;
		
		Token  bt = null;
		
		bt = LT(1);
		match(B_STRING);
		if ( inputState.guessing==0 ) {
			t = m_mp.bst(bt);
		}
		return t;
	}
	
	public final HexStringToken  hex_string_token() throws RecognitionException, TokenStreamException {
		HexStringToken t = null;
		
		Token  ht = null;
		
		ht = LT(1);
		match(H_STRING);
		if ( inputState.guessing==0 ) {
			t = m_mp.hst(ht);
		}
		return t;
	}
	
	public final SmiValue  macro_value_assignment(
		IdToken idToken
	) throws RecognitionException, TokenStreamException {
		SmiValue v = null;
		
		
		switch ( LA(1)) {
		case 126:
		case 127:
		case 128:
		case 129:
		case 131:
		case 132:
		case 133:
		case 134:
		{
			v=oid_macro_value_assignment(idToken);
			break;
		}
		case 135:
		{
			v=int_macro_value_assignment(idToken);
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		return v;
	}
	
	public final SmiOidValue  oid_value_assignment(
		IdToken idToken
	) throws RecognitionException, TokenStreamException {
		SmiOidValue v = null;
		
		
			OidComponent last = null;
		
		
		match(OBJECT_KW);
		match(IDENTIFIER_KW);
		match(ASSIGN_OP);
		last=oid_sequence(idToken);
		if ( inputState.guessing==0 ) {
			
				v = m_mp.createOidValue(idToken, last);
			
		}
		return v;
	}
	
	public final OidComponent  oid_sequence(
		IdToken idToken
	) throws RecognitionException, TokenStreamException {
		OidComponent last = null;
		
		
		match(L_BRACE);
		{
		int _cnt150=0;
		_loop150:
		do {
			if ((LA(1)==NUMBER||LA(1)==LOWER)) {
				last=oid_component(last);
			}
			else {
				if ( _cnt150>=1 ) { break _loop150; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt150++;
		} while (true);
		}
		match(R_BRACE);
		return last;
	}
	
	public final SmiOidMacro  oid_macro_value_assignment(
		IdToken idToken
	) throws RecognitionException, TokenStreamException {
		SmiOidMacro v = null;
		
		
			OidComponent lastOidComponent = null;
		
		
		{
		switch ( LA(1)) {
		case 126:
		{
			v=objecttype_macro(idToken);
			break;
		}
		case 127:
		{
			moduleidentity_macro();
			break;
		}
		case 128:
		{
			objectidentity_macro();
			break;
		}
		case 129:
		{
			v=notificationtype_macro(idToken);
			break;
		}
		case 131:
		{
			objectgroup_macro();
			break;
		}
		case 132:
		{
			notificationgroup_macro();
			break;
		}
		case 133:
		{
			modulecompliance_macro();
			break;
		}
		case 134:
		{
			agentcapabilities_macro();
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		match(ASSIGN_OP);
		lastOidComponent=oid_sequence(idToken);
		if ( inputState.guessing==0 ) {
			
				if (v == null) { // TODO temporary
					v = m_mp.createOidMacro(idToken);
				}
				v.setLastOidComponent(lastOidComponent);
			
		}
		return v;
	}
	
	public final SmiTrapType  int_macro_value_assignment(
		IdToken idToken
	) throws RecognitionException, TokenStreamException {
		SmiTrapType v = null;
		
		Token  specificType = null;
		
		{
		v=traptype_macro(idToken);
		match(ASSIGN_OP);
		specificType = LT(1);
		match(NUMBER);
		}
		if ( inputState.guessing==0 ) {
			
				v.setSpecificTypeToken(m_mp.intt(specificType));
			
		}
		return v;
	}
	
	public final SmiObjectType  objecttype_macro(
		IdToken idToken
	) throws RecognitionException, TokenStreamException {
		SmiObjectType ot = null;
		
		Token  units = null;
		Token  access = null;
		Token  maxAccess = null;
		Token  desc = null;
		
		SmiType sequenceOfType = null;
			SmiType type = null;
			SmiVariable var = null;
			SmiRow row = null;
			SmiTable table = null;
			StatusAll status = null;
			SmiDefaultValue defaultValue = null;
		
		
		match(126);
		match(LITERAL_SYNTAX);
		{
		switch ( LA(1)) {
		case INTEGER_KW:
		case OBJECT_KW:
		case OCTET_KW:
		case L_BRACKET:
		case UPPER:
		case LITERAL_BITS:
		{
			type=leaf_type(null);
			break;
		}
		case SEQUENCE_KW:
		{
			sequenceOfType=sequenceof_type();
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		{
		switch ( LA(1)) {
		case LITERAL_UNITS:
		{
			match(LITERAL_UNITS);
			units = LT(1);
			match(C_STRING);
			break;
		}
		case LITERAL_ACCESS:
		case 141:
		case LITERAL_STATUS:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		{
		switch ( LA(1)) {
		case LITERAL_ACCESS:
		{
			{
			match(LITERAL_ACCESS);
			access = LT(1);
			match(LOWER);
			}
			break;
		}
		case 141:
		{
			{
			match(141);
			maxAccess = LT(1);
			match(LOWER);
			}
			break;
		}
		case LITERAL_STATUS:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		match(LITERAL_STATUS);
		status=status_all();
		{
		switch ( LA(1)) {
		case LITERAL_DESCRIPTION:
		{
			match(LITERAL_DESCRIPTION);
			desc = LT(1);
			match(C_STRING);
			break;
		}
		case ASSIGN_OP:
		case LITERAL_REFERENCE:
		case LITERAL_INDEX:
		case LITERAL_AUGMENTS:
		case LITERAL_DEFVAL:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		{
		switch ( LA(1)) {
		case LITERAL_REFERENCE:
		{
			match(LITERAL_REFERENCE);
			match(C_STRING);
			break;
		}
		case ASSIGN_OP:
		case LITERAL_INDEX:
		case LITERAL_AUGMENTS:
		case LITERAL_DEFVAL:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		{
		switch ( LA(1)) {
		case LITERAL_INDEX:
		case LITERAL_AUGMENTS:
		{
			{
			switch ( LA(1)) {
			case LITERAL_INDEX:
			{
				match(LITERAL_INDEX);
				row=objecttype_macro_index(idToken, type);
				break;
			}
			case LITERAL_AUGMENTS:
			{
				match(LITERAL_AUGMENTS);
				row=objecttype_macro_augments(idToken, type);
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			break;
		}
		case ASSIGN_OP:
		case LITERAL_DEFVAL:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		{
		switch ( LA(1)) {
		case LITERAL_DEFVAL:
		{
			match(LITERAL_DEFVAL);
			match(L_BRACE);
			defaultValue=leaf_value();
			match(R_BRACE);
			break;
		}
		case ASSIGN_OP:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		if ( inputState.guessing==0 ) {
			
				    if (sequenceOfType != null) {
				        ot = table = m_mp.createTable(idToken, sequenceOfType);
				    } else if (row != null) {
				        ot = row;
				    } else {
				        ot = var = m_mp.createVariable(idToken, type, units, defaultValue);
				    }
				    if (access != null) {
				        ot.setAccessToken(m_mp.idt(access));
				    } else {
				    ot.setMaxAccessToken(m_mp.idt(maxAccess));
				}
				    ot.setStatus(status);
				    ot.setDescription(m_mp.getOptCStr(desc));
				
		}
		return ot;
	}
	
	public final void moduleidentity_macro() throws RecognitionException, TokenStreamException {
		
		Token  lastUpdated = null;
		Token  organization = null;
		Token  contactInfo = null;
		Token  description = null;
		
		List<SmiModuleRevision> revisions = new ArrayList<SmiModuleRevision>();
		
		
		match(127);
		match(148);
		lastUpdated = LT(1);
		match(C_STRING);
		match(LITERAL_ORGANIZATION);
		organization = LT(1);
		match(C_STRING);
		match(150);
		contactInfo = LT(1);
		match(C_STRING);
		match(LITERAL_DESCRIPTION);
		description = LT(1);
		match(C_STRING);
		{
		_loop181:
		do {
			if ((LA(1)==LITERAL_REVISION)) {
				moduleidentity_macro_revision(revisions);
			}
			else {
				break _loop181;
			}
			
		} while (true);
		}
		if ( inputState.guessing==0 ) {
			
				    m_mp.setModuleIdentity(lastUpdated, organization, contactInfo, description, revisions);
				
		}
	}
	
	public final void objectidentity_macro() throws RecognitionException, TokenStreamException {
		
		
		match(128);
		match(LITERAL_STATUS);
		status_v2();
		match(LITERAL_DESCRIPTION);
		match(C_STRING);
		{
		switch ( LA(1)) {
		case LITERAL_REFERENCE:
		{
			match(LITERAL_REFERENCE);
			match(C_STRING);
			break;
		}
		case ASSIGN_OP:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
	}
	
	public final SmiNotificationType  notificationtype_macro(
		IdToken idToken
	) throws RecognitionException, TokenStreamException {
		SmiNotificationType nt = null;
		
		Token  description = null;
		Token  reference = null;
		
			List<IdToken> objectTokens = null;
			StatusV2 status = null;
		
		
		match(129);
		{
		switch ( LA(1)) {
		case LITERAL_OBJECTS:
		{
			match(LITERAL_OBJECTS);
			match(L_BRACE);
			objectTokens=symbol_list();
			match(R_BRACE);
			break;
		}
		case LITERAL_STATUS:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		match(LITERAL_STATUS);
		status=status_v2();
		match(LITERAL_DESCRIPTION);
		description = LT(1);
		match(C_STRING);
		{
		switch ( LA(1)) {
		case LITERAL_REFERENCE:
		{
			match(LITERAL_REFERENCE);
			reference = LT(1);
			match(C_STRING);
			break;
		}
		case ASSIGN_OP:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		if ( inputState.guessing==0 ) {
			
					nt = m_mp.createNotification(idToken, objectTokens, status, m_mp.getCStr(description), m_mp.getOptCStr(reference));
				
		}
		return nt;
	}
	
	public final void objectgroup_macro() throws RecognitionException, TokenStreamException {
		
		
		match(131);
		match(LITERAL_OBJECTS);
		match(L_BRACE);
		match(LOWER);
		{
		_loop193:
		do {
			if ((LA(1)==COMMA)) {
				match(COMMA);
				match(LOWER);
			}
			else {
				break _loop193;
			}
			
		} while (true);
		}
		match(R_BRACE);
		match(LITERAL_STATUS);
		status_v2();
		match(LITERAL_DESCRIPTION);
		match(C_STRING);
		{
		switch ( LA(1)) {
		case LITERAL_REFERENCE:
		{
			match(LITERAL_REFERENCE);
			match(C_STRING);
			break;
		}
		case ASSIGN_OP:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
	}
	
	public final void notificationgroup_macro() throws RecognitionException, TokenStreamException {
		
		
		match(132);
		match(LITERAL_NOTIFICATIONS);
		match(L_BRACE);
		match(LOWER);
		{
		_loop197:
		do {
			if ((LA(1)==COMMA)) {
				match(COMMA);
				match(LOWER);
			}
			else {
				break _loop197;
			}
			
		} while (true);
		}
		match(R_BRACE);
		match(LITERAL_STATUS);
		status_v2();
		match(LITERAL_DESCRIPTION);
		match(C_STRING);
		{
		switch ( LA(1)) {
		case LITERAL_REFERENCE:
		{
			match(LITERAL_REFERENCE);
			match(C_STRING);
			break;
		}
		case ASSIGN_OP:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
	}
	
	public final void modulecompliance_macro() throws RecognitionException, TokenStreamException {
		
		
		match(133);
		match(LITERAL_STATUS);
		status_v2();
		match(LITERAL_DESCRIPTION);
		match(C_STRING);
		{
		switch ( LA(1)) {
		case LITERAL_REFERENCE:
		{
			match(LITERAL_REFERENCE);
			match(C_STRING);
			break;
		}
		case LITERAL_MODULE:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		{
		int _cnt202=0;
		_loop202:
		do {
			if ((LA(1)==LITERAL_MODULE)) {
				modulecompliance_macro_module();
			}
			else {
				if ( _cnt202>=1 ) { break _loop202; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt202++;
		} while (true);
		}
	}
	
	public final void agentcapabilities_macro() throws RecognitionException, TokenStreamException {
		
		
		match(134);
		match(160);
		match(C_STRING);
		match(LITERAL_STATUS);
		agentcapabilities_status();
		match(LITERAL_DESCRIPTION);
		match(C_STRING);
		{
		switch ( LA(1)) {
		case LITERAL_REFERENCE:
		{
			match(LITERAL_REFERENCE);
			match(C_STRING);
			break;
		}
		case ASSIGN_OP:
		case LITERAL_SUPPORTS:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		{
		_loop220:
		do {
			if ((LA(1)==LITERAL_SUPPORTS)) {
				agentcapabilities_macro_module();
			}
			else {
				break _loop220;
			}
			
		} while (true);
		}
	}
	
	public final SmiTrapType  traptype_macro(
		IdToken idToken
	) throws RecognitionException, TokenStreamException {
		SmiTrapType tt = null;
		
		Token  enterprise = null;
		Token  description = null;
		Token  reference = null;
		
			List<IdToken> variables = null;
		
		
		match(135);
		match(LITERAL_ENTERPRISE);
		enterprise = LT(1);
		match(LOWER);
		{
		switch ( LA(1)) {
		case LITERAL_VARIABLES:
		{
			match(LITERAL_VARIABLES);
			match(L_BRACE);
			variables=symbol_list();
			match(R_BRACE);
			break;
		}
		case ASSIGN_OP:
		case LITERAL_DESCRIPTION:
		case LITERAL_REFERENCE:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		{
		switch ( LA(1)) {
		case LITERAL_DESCRIPTION:
		{
			match(LITERAL_DESCRIPTION);
			description = LT(1);
			match(C_STRING);
			break;
		}
		case ASSIGN_OP:
		case LITERAL_REFERENCE:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		{
		switch ( LA(1)) {
		case LITERAL_REFERENCE:
		{
			match(LITERAL_REFERENCE);
			reference = LT(1);
			match(C_STRING);
			break;
		}
		case ASSIGN_OP:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		if ( inputState.guessing==0 ) {
			
					tt = m_mp.createTrap(idToken, m_mp.idt(enterprise), variables, m_mp.getOptCStr(description), m_mp.getOptCStr(reference));
				
		}
		return tt;
	}
	
	public final SmiDefaultValue  leaf_value() throws RecognitionException, TokenStreamException {
		SmiDefaultValue result = null;
		
		
			BigIntegerToken bit = null;
			List<IdToken> bitsIdTokenList = null;
		OidComponent lastOidComponent = null;
		BinaryStringToken bst = null;
			HexStringToken hst = null;
			QuotedStringToken qst = null;
			ScopedId scopedId = null;
			boolean isNullValue = false;
		
		
		{
		switch ( LA(1)) {
		case MINUS:
		case NUMBER:
		{
			bit=big_integer_token();
			break;
		}
		case B_STRING:
		{
			bst=binary_string_token();
			break;
		}
		case H_STRING:
		{
			hst=hex_string_token();
			break;
		}
		case C_STRING:
		{
			qst=double_quoted_string_token();
			break;
		}
		case UPPER:
		case LOWER:
		{
			scopedId=defined_value();
			break;
		}
		case NULL_KW:
		{
			match(NULL_KW);
			if ( inputState.guessing==0 ) {
				isNullValue = true;
			}
			break;
		}
		default:
			boolean synPredMatched147 = false;
			if (((LA(1)==L_BRACE) && (LA(2)==R_BRACE||LA(2)==LOWER) && (LA(3)==COMMA||LA(3)==R_BRACE))) {
				int _m147 = mark();
				synPredMatched147 = true;
				inputState.guessing++;
				try {
					{
					bits_value();
					}
				}
				catch (RecognitionException pe) {
					synPredMatched147 = false;
				}
				rewind(_m147);
inputState.guessing--;
			}
			if ( synPredMatched147 ) {
				bitsIdTokenList=bits_value();
			}
			else if ((LA(1)==L_BRACE) && (LA(2)==NUMBER||LA(2)==LOWER) && (_tokenSet_5.member(LA(3)))) {
				lastOidComponent=oid_sequence(null);
			}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		if ( inputState.guessing==0 ) {
			
			result = new SmiDefaultValue(m_mp.getModule(), bit, bitsIdTokenList, lastOidComponent, bst, hst, qst, scopedId, isNullValue);
			
		}
		return result;
	}
	
	public final List<IdToken>  bits_value() throws RecognitionException, TokenStreamException {
		List<IdToken> result = new ArrayList<IdToken>();
		
		Token  l1 = null;
		Token  l2 = null;
		
		match(L_BRACE);
		{
		switch ( LA(1)) {
		case LOWER:
		{
			l1 = LT(1);
			match(LOWER);
			if ( inputState.guessing==0 ) {
				result.add(idt(l1));
			}
			{
			_loop157:
			do {
				if ((LA(1)==COMMA)) {
					match(COMMA);
					l2 = LT(1);
					match(LOWER);
					if ( inputState.guessing==0 ) {
						result.add(idt(l2));
					}
				}
				else {
					break _loop157;
				}
				
			} while (true);
			}
			break;
		}
		case R_BRACE:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		match(R_BRACE);
		return result;
	}
	
	public final QuotedStringToken  double_quoted_string_token() throws RecognitionException, TokenStreamException {
		QuotedStringToken t = null;
		
		Token  ct = null;
		
		ct = LT(1);
		match(C_STRING);
		if ( inputState.guessing==0 ) {
			t = m_mp.dqst(ct);
		}
		return t;
	}
	
	public final ScopedId  defined_value() throws RecognitionException, TokenStreamException {
		ScopedId id=null;
		
		Token  u = null;
		Token  l = null;
		
		{
		switch ( LA(1)) {
		case UPPER:
		{
			u = LT(1);
			match(UPPER);
			match(DOT);
			break;
		}
		case LOWER:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		l = LT(1);
		match(LOWER);
		if ( inputState.guessing==0 ) {
			id = m_mp.makeScopedId(u, l);
		}
		return id;
	}
	
	public final OidComponent  oid_component(
		OidComponent parent
	) throws RecognitionException, TokenStreamException {
		OidComponent oc = null;
		
		Token  nt1 = null;
		Token  lt = null;
		Token  nt2 = null;
		
		switch ( LA(1)) {
		case NUMBER:
		{
			nt1 = LT(1);
			match(NUMBER);
			if ( inputState.guessing==0 ) {
				oc = m_mp.createOidComponent(parent, null, nt1);
			}
			break;
		}
		case LOWER:
		{
			{
			lt = LT(1);
			match(LOWER);
			{
			switch ( LA(1)) {
			case L_PAREN:
			{
				match(L_PAREN);
				nt2 = LT(1);
				match(NUMBER);
				match(R_PAREN);
				break;
			}
			case R_BRACE:
			case NUMBER:
			case LOWER:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			}
			if ( inputState.guessing==0 ) {
				oc = m_mp.createOidComponent(parent, lt, nt2);
			}
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		return oc;
	}
	
	public final StatusAll  status_all() throws RecognitionException, TokenStreamException {
		StatusAll status = null;
		
		Token  l = null;
		
		l = LT(1);
		match(LOWER);
		if ( inputState.guessing==0 ) {
			
				status = StatusAll.find(l.getText(), true);
			
		}
		return status;
	}
	
	public final SmiRow  objecttype_macro_index(
		IdToken idToken, SmiType type
	) throws RecognitionException, TokenStreamException {
		SmiRow row = m_mp.createRow(idToken, type);
		
		
		match(L_BRACE);
		objecttype_macro_indextype(row);
		{
		_loop175:
		do {
			if ((LA(1)==COMMA)) {
				match(COMMA);
				objecttype_macro_indextype(row);
			}
			else {
				break _loop175;
			}
			
		} while (true);
		}
		match(R_BRACE);
		return row;
	}
	
	public final SmiRow  objecttype_macro_augments(
		IdToken idToken, SmiType type
	) throws RecognitionException, TokenStreamException {
		SmiRow row = m_mp.createRow(idToken, type);
		
		
		ScopedId id;
		
		
		match(L_BRACE);
		id=defined_value();
		match(R_BRACE);
		if ( inputState.guessing==0 ) {
			
				    row.setAugmentsId(id);
				
		}
		return row;
	}
	
	public final StatusV2  status_v2() throws RecognitionException, TokenStreamException {
		StatusV2 status = null;
		
		Token  l = null;
		
		l = LT(1);
		match(LOWER);
		if ( inputState.guessing==0 ) {
			
				status = m_mp.findStatusV2(l.getText());
			
		}
		return status;
	}
	
	public final void objecttype_macro_indextype(
		SmiRow row
	) throws RecognitionException, TokenStreamException {
		
		
		boolean implied=false;
		ScopedId id;
		
		
		{
		switch ( LA(1)) {
		case IMPLIED_KW:
		{
			match(IMPLIED_KW);
			if ( inputState.guessing==0 ) {
				implied=true;
			}
			break;
		}
		case UPPER:
		case LOWER:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		id=defined_value();
		if ( inputState.guessing==0 ) {
			row.addIndex(id, implied);
		}
	}
	
	public final void moduleidentity_macro_revision(
		List<SmiModuleRevision> revisions
	) throws RecognitionException, TokenStreamException {
		
		Token  revision = null;
		Token  description = null;
		
		match(LITERAL_REVISION);
		revision = LT(1);
		match(C_STRING);
		match(LITERAL_DESCRIPTION);
		description = LT(1);
		match(C_STRING);
		if ( inputState.guessing==0 ) {
			
			revisions.add(m_mp.createModuleRevision(revision, description));
				
		}
	}
	
	public final void modulecompliance_macro_module() throws RecognitionException, TokenStreamException {
		
		
		match(LITERAL_MODULE);
		{
		switch ( LA(1)) {
		case UPPER:
		{
			match(UPPER);
			break;
		}
		case OBJECT_KW:
		case ASSIGN_OP:
		case LITERAL_MODULE:
		case 156:
		case LITERAL_GROUP:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		{
		switch ( LA(1)) {
		case 156:
		{
			match(156);
			match(L_BRACE);
			match(LOWER);
			{
			_loop207:
			do {
				if ((LA(1)==COMMA)) {
					match(COMMA);
					match(LOWER);
				}
				else {
					break _loop207;
				}
				
			} while (true);
			}
			match(R_BRACE);
			break;
		}
		case OBJECT_KW:
		case ASSIGN_OP:
		case LITERAL_MODULE:
		case LITERAL_GROUP:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		{
		_loop209:
		do {
			if ((LA(1)==OBJECT_KW||LA(1)==LITERAL_GROUP)) {
				modulecompliance_macro_compliance();
			}
			else {
				break _loop209;
			}
			
		} while (true);
		}
	}
	
	public final void modulecompliance_macro_compliance() throws RecognitionException, TokenStreamException {
		
		
		switch ( LA(1)) {
		case LITERAL_GROUP:
		{
			modulecompliance_macro_compliance_group();
			break;
		}
		case OBJECT_KW:
		{
			modulecompliance_macro_compliance_object();
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
	}
	
	public final void modulecompliance_macro_compliance_group() throws RecognitionException, TokenStreamException {
		
		
		match(LITERAL_GROUP);
		match(LOWER);
		match(LITERAL_DESCRIPTION);
		match(C_STRING);
	}
	
	public final void modulecompliance_macro_compliance_object() throws RecognitionException, TokenStreamException {
		
		
		match(OBJECT_KW);
		match(LOWER);
		{
		switch ( LA(1)) {
		case LITERAL_SYNTAX:
		{
			match(LITERAL_SYNTAX);
			leaf_type(null);
			break;
		}
		case LITERAL_DESCRIPTION:
		case 158:
		case 159:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		{
		switch ( LA(1)) {
		case 158:
		{
			match(158);
			leaf_type(null);
			break;
		}
		case LITERAL_DESCRIPTION:
		case 159:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		{
		switch ( LA(1)) {
		case 159:
		{
			match(159);
			modulecompliance_access();
			break;
		}
		case LITERAL_DESCRIPTION:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		match(LITERAL_DESCRIPTION);
		match(C_STRING);
	}
	
	public final void modulecompliance_access() throws RecognitionException, TokenStreamException {
		
		Token  l = null;
		
		l = LT(1);
		match(LOWER);
		if ( inputState.guessing==0 ) {
			
				ModuleComplianceAccess.find(l.getText(), true);
			
		}
	}
	
	public final void agentcapabilities_status() throws RecognitionException, TokenStreamException {
		
		Token  l = null;
		
		l = LT(1);
		match(LOWER);
		if ( inputState.guessing==0 ) {
			
				AgentCapabilitiesStatus.find(l.getText(), true);
			
		}
	}
	
	public final void agentcapabilities_macro_module() throws RecognitionException, TokenStreamException {
		
		
		match(LITERAL_SUPPORTS);
		match(UPPER);
		match(INCLUDES_KW);
		match(L_BRACE);
		match(LOWER);
		{
		_loop224:
		do {
			if ((LA(1)==COMMA)) {
				match(COMMA);
				match(LOWER);
			}
			else {
				break _loop224;
			}
			
		} while (true);
		}
		match(R_BRACE);
		{
		_loop226:
		do {
			if ((LA(1)==LITERAL_VARIATION)) {
				agentcapabilities_macro_variation();
			}
			else {
				break _loop226;
			}
			
		} while (true);
		}
	}
	
	public final void agentcapabilities_macro_variation() throws RecognitionException, TokenStreamException {
		
		
		match(LITERAL_VARIATION);
		match(LOWER);
		{
		switch ( LA(1)) {
		case LITERAL_SYNTAX:
		{
			match(LITERAL_SYNTAX);
			leaf_type(null);
			break;
		}
		case LITERAL_ACCESS:
		case LITERAL_DESCRIPTION:
		case LITERAL_DEFVAL:
		case 158:
		case 163:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		{
		switch ( LA(1)) {
		case 158:
		{
			match(158);
			leaf_type(null);
			break;
		}
		case LITERAL_ACCESS:
		case LITERAL_DESCRIPTION:
		case LITERAL_DEFVAL:
		case 163:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		{
		switch ( LA(1)) {
		case LITERAL_ACCESS:
		{
			match(LITERAL_ACCESS);
			agentcapabilities_access();
			break;
		}
		case LITERAL_DESCRIPTION:
		case LITERAL_DEFVAL:
		case 163:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		{
		switch ( LA(1)) {
		case 163:
		{
			match(163);
			match(L_BRACE);
			match(LOWER);
			{
			_loop233:
			do {
				if ((LA(1)==COMMA)) {
					match(COMMA);
					match(LOWER);
				}
				else {
					break _loop233;
				}
				
			} while (true);
			}
			match(R_BRACE);
			break;
		}
		case LITERAL_DESCRIPTION:
		case LITERAL_DEFVAL:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		{
		switch ( LA(1)) {
		case LITERAL_DEFVAL:
		{
			match(LITERAL_DEFVAL);
			match(L_BRACE);
			leaf_value();
			match(R_BRACE);
			break;
		}
		case LITERAL_DESCRIPTION:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		match(LITERAL_DESCRIPTION);
		match(C_STRING);
	}
	
	public final void agentcapabilities_access() throws RecognitionException, TokenStreamException {
		
		Token  l = null;
		
		l = LT(1);
		match(LOWER);
		if ( inputState.guessing==0 ) {
			
				AgentCapabilitiesAccess.find(l.getText(), true);
			
		}
	}
	
	public final void named_number(
		List<SmiNamedNumber> l
	) throws RecognitionException, TokenStreamException {
		
		
			IdToken it = null;
			BigIntegerToken bit = null;
		
		
		it=lower();
		match(L_PAREN);
		bit=big_integer_token();
		match(R_PAREN);
		if ( inputState.guessing==0 ) {
			
				l.add(new SmiNamedNumber(it, bit));
			
		}
	}
	
	
	public static final String[] _tokenNames = {
		"<0>",
		"EOF",
		"<2>",
		"NULL_TREE_LOOKAHEAD",
		"\"ABSENT\"",
		"\"ABSTRACT-SYNTAX\"",
		"\"ALL\"",
		"\"ANY\"",
		"\"ARGUMENT\"",
		"\"APPLICATION\"",
		"\"AUTOMATIC\"",
		"\"BASEDNUM\"",
		"\"BEGIN\"",
		"\"BIT\"",
		"\"BMPString\"",
		"\"BOOLEAN\"",
		"\"BY\"",
		"\"CHARACTER\"",
		"\"CHOICE\"",
		"\"CLASS\"",
		"\"COMPONENTS\"",
		"\"COMPONENT\"",
		"\"CONSTRAINED\"",
		"\"DEFAULT\"",
		"\"DEFINED\"",
		"\"DEFINITIONS\"",
		"\"EMBEDDED\"",
		"\"END\"",
		"\"ENUMERATED\"",
		"\"ERROR\"",
		"\"ERRORS\"",
		"\"EXCEPT\"",
		"\"EXPLICIT\"",
		"\"EXPORTS\"",
		"\"EXTENSIBILITY\"",
		"\"EXTERNAL\"",
		"\"FALSE\"",
		"\"FROM\"",
		"\"GeneralizedTime\"",
		"\"GeneralString\"",
		"\"GraphicString\"",
		"\"IA5String\"",
		"\"IDENTIFIER\"",
		"\"IMPLICIT\"",
		"\"IMPLIED\"",
		"\"IMPORTS\"",
		"\"INCLUDES\"",
		"\"INSTANCE\"",
		"\"INTEGER\"",
		"\"INTERSECTION\"",
		"\"ISO646String\"",
		"\"LINKED\"",
		"\"MAX\"",
		"\"MINUSINFINITY\"",
		"\"MIN\"",
		"\"NULL\"",
		"\"NumericString\"",
		"\"ObjectDescriptor\"",
		"\"OBJECT\"",
		"\"OCTET\"",
		"\"OPERATION\"",
		"\"OF\"",
		"\"OID\"",
		"\"OPTIONAL\"",
		"\"PARAMETER\"",
		"\"PDV\"",
		"\"PLUSINFINITY\"",
		"\"PRESENT\"",
		"\"PrintableString\"",
		"\"PRIVATE\"",
		"\"REAL\"",
		"\"RELATIVE\"",
		"\"RESULT\"",
		"\"SEQUENCE\"",
		"\"SET\"",
		"\"SIZE\"",
		"\"STRING\"",
		"\"TAGS\"",
		"\"TeletexString\"",
		"\"TRUE\"",
		"\"TYPE-IDENTIFIER\"",
		"\"UNION\"",
		"\"UNIQUE\"",
		"\"UNIVERSAL\"",
		"\"UniversalString\"",
		"\"UTCTime\"",
		"\"UTF8String\"",
		"\"VideotexString\"",
		"\"VisibleString\"",
		"\"WITH\"",
		"ASSIGN_OP",
		"BAR",
		"COLON",
		"COMMA",
		"COMMENT",
		"DOT",
		"DOTDOT",
		"ELLIPSIS",
		"EXCLAMATION",
		"INTERSECTION",
		"LESS",
		"L_BRACE",
		"L_BRACKET",
		"L_PAREN",
		"MINUS",
		"PLUS",
		"R_BRACE",
		"R_BRACKET",
		"R_PAREN",
		"SEMI",
		"SINGLE_QUOTE",
		"CHARB",
		"CHARH",
		"WS",
		"SMIC_DIRECTIVE",
		"INCLUDE",
		"SL_COMMENT",
		"NUMBER",
		"UPPER",
		"LOWER",
		"BDIG",
		"HDIG",
		"B_OR_H_STRING",
		"B_STRING",
		"H_STRING",
		"C_STRING",
		"\"OBJECT-TYPE\"",
		"\"MODULE-IDENTITY\"",
		"\"OBJECT-IDENTITY\"",
		"\"NOTIFICATION-TYPE\"",
		"\"TEXTUAL-CONVENTION\"",
		"\"OBJECT-GROUP\"",
		"\"NOTIFICATION-GROUP\"",
		"\"MODULE-COMPLIANCE\"",
		"\"AGENT-CAPABILITIES\"",
		"\"TRAP-TYPE\"",
		"\"MACRO\"",
		"\"BITS\"",
		"\"SYNTAX\"",
		"\"UNITS\"",
		"\"ACCESS\"",
		"\"MAX-ACCESS\"",
		"\"STATUS\"",
		"\"DESCRIPTION\"",
		"\"REFERENCE\"",
		"\"INDEX\"",
		"\"AUGMENTS\"",
		"\"DEFVAL\"",
		"\"LAST-UPDATED\"",
		"\"ORGANIZATION\"",
		"\"CONTACT-INFO\"",
		"\"REVISION\"",
		"\"OBJECTS\"",
		"\"DISPLAY-HINT\"",
		"\"NOTIFICATIONS\"",
		"\"MODULE\"",
		"\"MANDATORY-GROUPS\"",
		"\"GROUP\"",
		"\"WRITE-SYNTAX\"",
		"\"MIN-ACCESS\"",
		"\"PRODUCT-RELEASE\"",
		"\"SUPPORTS\"",
		"\"VARIATION\"",
		"\"CREATION-REQUIRES\"",
		"\"ENTERPRISE\"",
		"\"VARIABLES\""
	};
	
	private static final long[] mk_tokenSet_0() {
		long[] data = { 0L, -4557642822898941952L, 255L, 0L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_0 = new BitSet(mk_tokenSet_0());
	private static final long[] mk_tokenSet_1() {
		long[] data = { -134217744L, -1L, 274877906943L, 0L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_1 = new BitSet(mk_tokenSet_1());
	private static final long[] mk_tokenSet_2() {
		long[] data = new long[8];
		data[0]=-16L;
		data[1]=-4398046511105L;
		data[2]=274877906943L;
		return data;
	}
	public static final BitSet _tokenSet_2 = new BitSet(mk_tokenSet_2());
	private static final long[] mk_tokenSet_3() {
		long[] data = { 134217728L, -4557637737120792576L, 37581551871L, 0L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_3 = new BitSet(mk_tokenSet_3());
	private static final long[] mk_tokenSet_4() {
		long[] data = { 0L, 1738390555676639232L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_4 = new BitSet(mk_tokenSet_4());
	private static final long[] mk_tokenSet_5() {
		long[] data = { 0L, 45040944076029952L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_5 = new BitSet(mk_tokenSet_5());
	
	}
