/*
 * Decompiled with CFR 0.152.
 */
package org.jsmiparser;

import java.util.List;
import java.util.Set;
import junit.framework.TestCase;
import org.jsmiparser.parser.SmiDefaultParser;
import org.jsmiparser.parser.SmiParser;
import org.jsmiparser.smi.SmiConstants;
import org.jsmiparser.smi.SmiMib;
import org.jsmiparser.smi.SmiModule;
import org.jsmiparser.smi.SmiObjectType;
import org.jsmiparser.smi.SmiOidNode;
import org.jsmiparser.smi.SmiOidValue;
import org.jsmiparser.smi.SmiPrimitiveType;
import org.jsmiparser.smi.SmiRange;
import org.jsmiparser.smi.SmiSymbol;
import org.jsmiparser.smi.SmiType;
import org.jsmiparser.smi.SmiVersion;
import org.jsmiparser.util.problem.annotations.ProblemSeverity;
import org.jsmiparser.util.url.ClassPathURLListFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StopWatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMibTestCase
extends TestCase {
    public static final String LIBSMI_MIBS_URL = "libsmi-0.4.8/mibs";
    private static final Logger m_log = LoggerFactory.getLogger(AbstractMibTestCase.class);
    private final SmiVersion m_version;
    private final String[] m_resources;
    private static ThreadLocal<Class<? extends AbstractMibTestCase>> m_testClass = new ThreadLocal();
    private static ThreadLocal<SmiMib> m_mib = new ThreadLocal();
    private SmiType m_integer32;
    private SmiType m_counter;
    private SmiDefaultParser m_parser;

    public AbstractMibTestCase(SmiVersion version, String ... resources) {
        this.m_version = version;
        this.m_resources = resources;
    }

    protected SmiDefaultParser getParser() {
        return this.m_parser;
    }

    protected SmiMib getMib() {
        if (m_mib.get() == null || m_testClass.get() != ((Object)((Object)this)).getClass()) {
            try {
                SmiParser parser = this.createParser();
                StopWatch stopWatch = new StopWatch();
                stopWatch.start();
                SmiMib mib = parser.parse();
                stopWatch.stop();
                m_log.info("Parsing time: " + stopWatch.getTotalTimeSeconds() + " s");
                if (this.mustParseSuccessfully()) {
                    AbstractMibTestCase.assertTrue((boolean)((SmiDefaultParser)parser).getProblemEventHandler().isOk());
                    AbstractMibTestCase.assertEquals((int)0, (int)((SmiDefaultParser)parser).getProblemEventHandler().getSeverityCount(ProblemSeverity.ERROR));
                }
                m_mib.set(mib);
                m_testClass.set(((Object)((Object)this)).getClass());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return m_mib.get();
    }

    protected boolean mustParseSuccessfully() {
        return true;
    }

    protected SmiParser createParser() throws Exception {
        ClassPathURLListFactory urlListFactory = new ClassPathURLListFactory("libsmi-0.4.8/mibs/ietf");
        if (this.m_version == null || this.m_version == SmiVersion.V1) {
            urlListFactory.add("RFC1155-SMI");
        }
        if (this.m_version == null || this.m_version == SmiVersion.V2) {
            urlListFactory.add("SNMPv2-SMI");
            urlListFactory.add("SNMPv2-TC");
            urlListFactory.add("SNMPv2-CONF");
            urlListFactory.add("SNMPv2-MIB");
        }
        List urls = urlListFactory.create();
        for (String resource : this.getResources()) {
            urls.add(((Object)((Object)this)).getClass().getClassLoader().getResource(resource));
        }
        this.m_parser = new SmiDefaultParser();
        this.m_parser.getFileParserPhase().setInputUrls(urls);
        return this.m_parser;
    }

    public final String[] getResources() {
        return this.m_resources;
    }

    public SmiType getInteger32() {
        if (this.m_integer32 == null) {
            this.m_integer32 = (SmiType)this.getMib().getTypes().find("Integer32");
            AbstractMibTestCase.assertSame((Object)SmiConstants.INTEGER_TYPE, (Object)this.m_integer32.getBaseType());
            AbstractMibTestCase.assertSame((Object)SmiPrimitiveType.INTEGER_32, (Object)this.m_integer32.getPrimitiveType());
            AbstractMibTestCase.assertEquals((int)1, (int)this.m_integer32.getRangeConstraints().size());
            AbstractMibTestCase.assertEquals((int)Integer.MIN_VALUE, (int)((SmiRange)this.m_integer32.getRangeConstraints().get(0)).getMinValue().intValue());
            AbstractMibTestCase.assertEquals((int)Integer.MAX_VALUE, (int)((SmiRange)this.m_integer32.getRangeConstraints().get(0)).getMaxValue().intValue());
            AbstractMibTestCase.assertNull((Object)this.m_integer32.getSizeConstraints());
            AbstractMibTestCase.assertNull((Object)this.m_integer32.getEnumValues());
            AbstractMibTestCase.assertNull((Object)this.m_integer32.getBitFields());
            AbstractMibTestCase.assertNull((Object)this.m_integer32.getFields());
        }
        return this.m_integer32;
    }

    public SmiType getCounter() {
        if (this.m_counter == null) {
            this.m_counter = (SmiType)this.getMib().getTypes().find("Counter");
            AbstractMibTestCase.assertSame((Object)SmiConstants.INTEGER_TYPE, (Object)this.m_counter.getBaseType());
            AbstractMibTestCase.assertSame((Object)SmiPrimitiveType.COUNTER_32, (Object)this.m_counter.getPrimitiveType());
            AbstractMibTestCase.assertEquals((int)1, (int)this.m_counter.getRangeConstraints().size());
            AbstractMibTestCase.assertEquals((int)0, (int)((SmiRange)this.m_counter.getRangeConstraints().get(0)).getMinValue().intValue());
            AbstractMibTestCase.assertEquals((long)0xFFFFFFFFL, (long)((SmiRange)this.m_counter.getRangeConstraints().get(0)).getMaxValue().longValue());
            AbstractMibTestCase.assertNull((Object)this.m_counter.getSizeConstraints());
            AbstractMibTestCase.assertNull((Object)this.m_counter.getEnumValues());
            AbstractMibTestCase.assertNull((Object)this.m_counter.getBitFields());
            AbstractMibTestCase.assertNull((Object)this.m_counter.getFields());
        }
        return this.m_counter;
    }

    protected void showOverview() {
        for (SmiModule module : m_mib.get().getModules()) {
            for (SmiSymbol symbol : module.getSymbols()) {
                String msg = module.getId() + ": " + symbol.getId() + ": " + symbol.getClass().getSimpleName();
                if (symbol instanceof SmiOidValue) {
                    SmiOidValue oidValue = (SmiOidValue)symbol;
                    msg = msg + ": " + oidValue.getOidStr();
                }
                System.out.println(msg);
            }
        }
    }

    protected void checkOidTree(SmiMib mib) {
        int count = 0;
        for (SmiSymbol symbol : mib.getSymbols()) {
            if (!(symbol instanceof SmiOidValue)) continue;
            SmiOidValue oidValue = (SmiOidValue)symbol;
            if (oidValue.getNode() != mib.getRootNode()) {
                String msg = oidValue.getIdToken().toString();
                AbstractMibTestCase.assertNotNull((String)msg, (Object)oidValue.getNode().getParent());
                SmiOidNode foundOidNode = oidValue.getNode().getParent().findChild(oidValue.getNode().getValue());
                AbstractMibTestCase.assertNotNull((String)msg, (Object)foundOidNode);
                AbstractMibTestCase.assertSame((String)msg, (Object)oidValue.getNode(), (Object)foundOidNode);
                AbstractMibTestCase.assertTrue((String)msg, (boolean)oidValue.getNode().getParent().contains(oidValue.getNode()));
            }
            ++count;
        }
        int totalChildCount = mib.getRootNode().getTotalChildCount();
    }

    protected void checkObjectTypeAccessAll(SmiMib mib) {
        for (SmiObjectType objectType : mib.getObjectTypes()) {
            AbstractMibTestCase.assertNotNull((String)objectType.getId(), (Object)objectType.getAccessAll());
        }
    }

    protected void add(Set<String> paths, String dir, String name) {
        paths.add(dir + "/" + name);
    }
}

