/*
 * Decompiled with CFR 0.152.
 */
package org.jsmiparser;

import java.util.List;
import org.jsmiparser.AbstractMibTestCase;
import org.jsmiparser.smi.SmiModule;
import org.jsmiparser.smi.SmiPrimitiveType;
import org.jsmiparser.smi.SmiRange;
import org.jsmiparser.smi.SmiTextualConvention;
import org.jsmiparser.smi.SmiType;
import org.jsmiparser.smi.SmiVariable;
import org.jsmiparser.smi.SmiVersion;

public class BridgeMibTest
extends AbstractMibTestCase {
    public BridgeMibTest() {
        super(SmiVersion.V2, "libsmi-0.4.8/mibs/iana/IANAifType-MIB", "libsmi-0.4.8/mibs/ietf/IF-MIB", "libsmi-0.4.8/mibs/ietf/BRIDGE-MIB");
    }

    public void testBridgeMib() {
        SmiType integer32 = this.getInteger32();
        SmiModule bridgeMib = this.getMib().findModule("BRIDGE-MIB");
        BridgeMibTest.assertEquals((String)"BRIDGE-MIB", (String)bridgeMib.getId());
        SmiTextualConvention timeout = (SmiTextualConvention)this.getMib().getTextualConventions().find("Timeout");
        BridgeMibTest.assertNotNull((Object)timeout);
        BridgeMibTest.assertEquals((Object)integer32, (Object)timeout.getBaseType());
        BridgeMibTest.assertEquals((Object)SmiPrimitiveType.INTEGER_32, (Object)timeout.getPrimitiveType());
        BridgeMibTest.assertNull((Object)timeout.getRangeConstraints());
        SmiVariable dot1dStpBridgeMaxAge = (SmiVariable)this.getMib().getVariables().find("dot1dStpBridgeMaxAge");
        BridgeMibTest.assertNotNull((Object)dot1dStpBridgeMaxAge);
        SmiType anonymousType = dot1dStpBridgeMaxAge.getType();
        BridgeMibTest.assertNull((Object)anonymousType.getIdToken());
        BridgeMibTest.assertSame((Object)timeout, (Object)anonymousType.getBaseType());
        BridgeMibTest.assertEquals((Object)SmiPrimitiveType.INTEGER_32, (Object)dot1dStpBridgeMaxAge.getType().getPrimitiveType());
        List dot1dStpBridgeMaxAgeRangeConstraints = dot1dStpBridgeMaxAge.getType().getRangeConstraints();
        BridgeMibTest.assertEquals((int)1, (int)dot1dStpBridgeMaxAgeRangeConstraints.size());
        BridgeMibTest.assertEquals((int)600, (int)((SmiRange)dot1dStpBridgeMaxAgeRangeConstraints.get(0)).getMinValue().intValue());
        BridgeMibTest.assertEquals((int)4000, (int)((SmiRange)dot1dStpBridgeMaxAgeRangeConstraints.get(0)).getMaxValue().intValue());
    }
}

