/*
 * Decompiled with CFR 0.152.
 */
package org.jsmiparser;

import java.net.URISyntaxException;
import java.util.List;
import org.jsmiparser.AbstractMibTestCase;
import org.jsmiparser.smi.SmiConstants;
import org.jsmiparser.smi.SmiIndex;
import org.jsmiparser.smi.SmiMib;
import org.jsmiparser.smi.SmiModule;
import org.jsmiparser.smi.SmiModuleIdentity;
import org.jsmiparser.smi.SmiModuleRevision;
import org.jsmiparser.smi.SmiNamedNumber;
import org.jsmiparser.smi.SmiNotificationType;
import org.jsmiparser.smi.SmiOidNode;
import org.jsmiparser.smi.SmiOidValue;
import org.jsmiparser.smi.SmiPrimitiveType;
import org.jsmiparser.smi.SmiRow;
import org.jsmiparser.smi.SmiTable;
import org.jsmiparser.smi.SmiTextualConvention;
import org.jsmiparser.smi.SmiType;
import org.jsmiparser.smi.SmiVariable;
import org.jsmiparser.smi.SmiVersion;
import org.jsmiparser.smi.StatusV2;
import org.jsmiparser.util.token.IdToken;

public class IfMibTest
extends AbstractMibTestCase {
    public IfMibTest() {
        super(SmiVersion.V2, "libsmi-0.4.8/mibs/iana/IANAifType-MIB", "libsmi-0.4.8/mibs/ietf/IF-MIB");
    }

    public void testSizes() {
        IfMibTest.assertEquals((int)44, (int)this.getMib().getScalars().size());
        IfMibTest.assertEquals((int)57, (int)this.getMib().getColumns().size());
        IfMibTest.assertEquals((int)5, (int)this.getMib().getNotificationTypes().size());
        SmiModule ifMib = this.getMib().findModule("IF-MIB");
        IfMibTest.assertNotNull((Object)ifMib);
        IfMibTest.assertEquals((int)2, (int)ifMib.getNotificationTypes().size());
        IfMibTest.assertEquals((int)3, (int)ifMib.getScalars().size());
        IfMibTest.assertEquals((int)53, (int)ifMib.getColumns().size());
        IfMibTest.assertNotNull((Object)ifMib.findScalar("ifNumber"));
        IfMibTest.assertNull((Object)ifMib.findColumn("ifNumber"));
        IfMibTest.assertNotNull((Object)ifMib.findColumn("ifName"));
        IfMibTest.assertNull((Object)ifMib.findScalar("ifName"));
        IfMibTest.assertNotNull((Object)ifMib.findTable("ifTable"));
        IfMibTest.assertNull((Object)ifMib.findVariable("ifTable"));
        IfMibTest.assertNotNull((Object)ifMib.findRow("ifEntry"));
        IfMibTest.assertNull((Object)ifMib.findVariable("ifEntry"));
    }

    public void testInterfaceIndex() {
        IfMibTest.assertEquals((int)7, (int)this.getMib().getModules().size());
        SmiTextualConvention interfaceIndex = (SmiTextualConvention)this.getMib().getTextualConventions().find("InterfaceIndex");
        IfMibTest.assertNotNull((Object)interfaceIndex);
        IfMibTest.assertEquals((String)"InterfaceIndex", (String)interfaceIndex.getId());
        IfMibTest.assertEquals((String)"IF-MIB", (String)interfaceIndex.getModule().getId());
        String source = interfaceIndex.getModule().getIdToken().getLocation().getSource();
        IfMibTest.assertTrue((boolean)source.contains("IF-MIB"));
        IfMibTest.assertEquals(SmiTextualConvention.class, interfaceIndex.getClass());
        IfMibTest.assertNotNull((Object)interfaceIndex.getRangeConstraints());
        IfMibTest.assertEquals((int)1, (int)interfaceIndex.getRangeConstraints().size());
        IfMibTest.assertSame((Object)this.getInteger32(), (Object)interfaceIndex.getBaseType());
        IfMibTest.assertEquals((Object)SmiPrimitiveType.INTEGER_32, (Object)interfaceIndex.getPrimitiveType());
        IfMibTest.assertEquals((Object)SmiConstants.INTEGER_TYPE, (Object)interfaceIndex.getBaseType().getBaseType());
        IfMibTest.assertNull((Object)interfaceIndex.getBaseType().getBaseType().getBaseType());
        IfMibTest.assertEquals((String)"d", (String)interfaceIndex.getDisplayHint());
        IfMibTest.assertEquals((Object)StatusV2.CURRENT, (Object)interfaceIndex.getStatusV2());
        IfMibTest.assertTrue((boolean)interfaceIndex.getDescription().startsWith("A unique value"));
        IfMibTest.assertFalse((boolean)interfaceIndex.getDescription().endsWith("\""));
        IfMibTest.assertNull((Object)interfaceIndex.getReference());
        IfMibTest.assertNull((Object)interfaceIndex.getEnumValues());
        IfMibTest.assertNull((Object)interfaceIndex.getBitFields());
        IfMibTest.assertNull((Object)interfaceIndex.getFields());
        IfMibTest.assertNull((Object)interfaceIndex.getSizeConstraints());
    }

    public void testIfTable() throws URISyntaxException {
        SmiMib mib = this.getMib();
        SmiTable ifTable = (SmiTable)mib.getTables().find("ifTable");
        IfMibTest.assertNotNull((Object)ifTable);
        IfMibTest.assertEquals((String)"1.3.6.1.2.1.2.2", (String)ifTable.getOidStr());
        SmiRow ifEntry = (SmiRow)mib.getRows().find("ifEntry");
        IfMibTest.assertNotNull((Object)ifEntry);
        IfMibTest.assertSame((Object)ifTable.getNode(), (Object)ifEntry.getNode().getParent());
        IfMibTest.assertSame((Object)ifTable, (Object)ifEntry.getTable());
        IfMibTest.assertSame((Object)ifEntry, (Object)ifTable.getRow());
        IfMibTest.assertEquals((String)"1.3.6.1.2.1.2.2.1", (String)ifEntry.getOidStr());
        IfMibTest.assertSame((Object)ifTable, (Object)ifEntry.getTable());
        SmiVariable ifIndex = (SmiVariable)mib.getVariables().find("ifIndex");
        IfMibTest.assertNotNull((Object)ifIndex);
        IfMibTest.assertSame((Object)ifEntry.getNode(), (Object)ifIndex.getNode().getParent());
        IfMibTest.assertSame((Object)ifTable.getNode(), (Object)ifIndex.getNode().getParent().getParent());
        IfMibTest.assertEquals((String)"1.3.6.1.2.1.2.2.1.1", (String)ifIndex.getOidStr());
        SmiTextualConvention interfaceIndex = (SmiTextualConvention)this.getMib().getTextualConventions().find("InterfaceIndex");
        IfMibTest.assertNotNull((Object)interfaceIndex);
        IfMibTest.assertSame((Object)interfaceIndex, (Object)ifIndex.getType());
        List ifIndexes = ifEntry.getIndexes();
        IfMibTest.assertEquals((int)1, (int)ifIndexes.size());
        SmiIndex index = (SmiIndex)ifIndexes.get(0);
        IfMibTest.assertSame((Object)ifIndex, (Object)index.getColumn());
        IfMibTest.assertSame((Object)ifEntry, (Object)index.getRow());
        IfMibTest.assertEquals((boolean)false, (boolean)index.isImplied());
        SmiVariable ifAdminStatus = (SmiVariable)mib.getVariables().find("ifAdminStatus");
        IfMibTest.assertNotNull((Object)ifAdminStatus);
        IfMibTest.assertEquals((Object)ifEntry, (Object)ifAdminStatus.getRow());
        IfMibTest.assertEquals((Object)ifTable, (Object)ifAdminStatus.getTable());
        IfMibTest.assertEquals((String)"1.3.6.1.2.1.2.2.1.7", (String)ifAdminStatus.getOidStr());
        IfMibTest.assertSame((Object)ifEntry.getNode(), (Object)ifAdminStatus.getNode().getParent());
        SmiType ifAdminStatusType = ifAdminStatus.getType();
        IfMibTest.assertSame((Object)SmiPrimitiveType.ENUM, (Object)ifAdminStatusType.getPrimitiveType());
        IfMibTest.assertEquals((Object)SmiConstants.INTEGER_TYPE, (Object)ifAdminStatusType.getBaseType());
        IfMibTest.assertNull((Object)ifAdminStatusType.getBaseType().getBaseType());
        IfMibTest.assertEquals((int)3, (int)ifAdminStatusType.getEnumValues().size());
        IfMibTest.assertEquals((String)"up", (String)((SmiNamedNumber)ifAdminStatusType.getEnumValues().get(0)).getId());
        IfMibTest.assertEquals((int)1, (int)((SmiNamedNumber)ifAdminStatusType.getEnumValues().get(0)).getValue().intValue());
        IfMibTest.assertEquals((String)"down", (String)((SmiNamedNumber)ifAdminStatusType.getEnumValues().get(1)).getId());
        IfMibTest.assertEquals((int)2, (int)((SmiNamedNumber)ifAdminStatusType.getEnumValues().get(1)).getValue().intValue());
        IfMibTest.assertEquals((String)"testing", (String)((SmiNamedNumber)ifAdminStatusType.getEnumValues().get(2)).getId());
        IfMibTest.assertEquals((int)3, (int)((SmiNamedNumber)ifAdminStatusType.getEnumValues().get(2)).getValue().intValue());
        List columns = ifTable.getRow().getColumns();
        IfMibTest.assertEquals((int)22, (int)columns.size());
        IfMibTest.assertTrue((boolean)columns.contains(ifIndex));
        IfMibTest.assertTrue((boolean)columns.contains(ifAdminStatus));
        SmiModule ifMib = mib.findModule("IF-MIB");
        IfMibTest.assertNotNull((Object)ifMib);
        System.out.println(mib.getVariables().size() + mib.getTables().size() + mib.getRows().size());
        this.checkOidTree(mib);
    }

    public void testFindByOidPrefix() {
        SmiMib mib = this.getMib();
        SmiVariable ifAdminStatus = (SmiVariable)mib.getVariables().find("ifAdminStatus");
        IfMibTest.assertNotNull((Object)ifAdminStatus);
        IfMibTest.assertEquals((String)"1.3.6.1.2.1.2.2.1.7", (String)ifAdminStatus.getOidStr());
        int[] adminStatusOfInterface0x1101 = new int[]{1, 3, 6, 1, 2, 1, 2, 2, 1, 7, 4353};
        SmiOidNode result = mib.findByOidPrefix(adminStatusOfInterface0x1101);
        IfMibTest.assertSame((Object)ifAdminStatus.getNode(), (Object)result);
        IfMibTest.assertEquals((int)adminStatusOfInterface0x1101.length, (int)(result.getOid().length + 1));
    }

    public void testFindByOid() {
        SmiMib mib = this.getMib();
        SmiVariable ifAdminStatus = (SmiVariable)mib.getVariables().find("ifAdminStatus");
        IfMibTest.assertNotNull((Object)ifAdminStatus);
        IfMibTest.assertEquals((String)"1.3.6.1.2.1.2.2.1.7", (String)ifAdminStatus.getOidStr());
        SmiOidNode result = mib.findByOid(new int[]{1, 3, 6, 1, 2, 1, 2, 2, 1, 7});
        IfMibTest.assertNotNull((Object)result);
        IfMibTest.assertSame((Object)ifAdminStatus.getNode(), (Object)result);
        result = mib.findByOid(new int[]{1, 3});
        IfMibTest.assertNotNull((Object)result);
        IfMibTest.assertEquals((int)1, (int)result.getValues().size());
        IfMibTest.assertEquals((String)"org", (String)((SmiOidValue)result.getValues().get(0)).getId());
    }

    public void testNotificationTypes() {
        SmiModule ifMib = this.getMib().findModule("IF-MIB");
        IfMibTest.assertNotNull((Object)ifMib);
        SmiNotificationType linkUp = ifMib.findNotificationType("linkUp");
        IfMibTest.assertNotNull((Object)linkUp);
        SmiNotificationType linkDown = ifMib.findNotificationType("linkDown");
        IfMibTest.assertNotNull((Object)linkDown);
        SmiVariable ifIndex = ifMib.findVariable("ifIndex");
        IfMibTest.assertNotNull((Object)ifIndex);
        SmiVariable ifAdminStatus = ifMib.findVariable("ifAdminStatus");
        IfMibTest.assertNotNull((Object)ifAdminStatus);
        SmiVariable ifOperStatus = ifMib.findVariable("ifOperStatus");
        IfMibTest.assertNotNull((Object)ifOperStatus);
        SmiNotificationType coldStart = ifMib.findNotificationType("coldStart");
        IfMibTest.assertNull((Object)coldStart);
        IfMibTest.assertEquals((String)"1.3.6.1.6.3.1.1.5.4", (String)linkUp.getOidStr());
        IfMibTest.assertEquals((String)"A linkUp trap signifies that the SNMP entity, acting in an\n            agent role, has detected that the ifOperStatus object for\n            one of its communication links left the down state and\n            transitioned into some other state (but not into the\n            notPresent state).  This other state is indicated by the\n            included value of ifOperStatus.", (String)linkUp.getDescription());
        IfMibTest.assertNull((Object)linkUp.getReference());
        IfMibTest.assertNotNull((Object)linkUp.getObjectTokens());
        IfMibTest.assertEquals((int)3, (int)linkUp.getObjectTokens().size());
        IfMibTest.assertEquals((String)"ifIndex", (String)((String)((IdToken)linkUp.getObjectTokens().get(0)).getValue()));
        IfMibTest.assertEquals((String)"ifAdminStatus", (String)((String)((IdToken)linkUp.getObjectTokens().get(1)).getValue()));
        IfMibTest.assertEquals((String)"ifOperStatus", (String)((String)((IdToken)linkUp.getObjectTokens().get(2)).getValue()));
        IfMibTest.assertEquals((Object)StatusV2.CURRENT, (Object)linkUp.getStatusV2());
        IfMibTest.assertEquals((String)"linkUp", (String)((String)linkUp.getIdToken().getValue()));
        IfMibTest.assertNotNull((Object)linkUp.getObjects());
        IfMibTest.assertEquals((int)3, (int)linkUp.getObjects().size());
        IfMibTest.assertSame((Object)ifIndex, linkUp.getObjects().get(0));
        IfMibTest.assertSame((Object)ifAdminStatus, linkUp.getObjects().get(1));
        IfMibTest.assertSame((Object)ifOperStatus, linkUp.getObjects().get(2));
        IfMibTest.assertEquals((String)"1.3.6.1.6.3.1.1.5.3", (String)linkDown.getOidStr());
        IfMibTest.assertEquals((String)"A linkDown trap signifies that the SNMP entity, acting in\n            an agent role, has detected that the ifOperStatus object for\n            one of its communication links is about to enter the down\n            state from some other state (but not from the notPresent\n            state).  This other state is indicated by the included value\n            of ifOperStatus.", (String)linkDown.getDescription());
        IfMibTest.assertNull((Object)linkDown.getReference());
        IfMibTest.assertNotNull((Object)linkDown.getObjectTokens());
        IfMibTest.assertEquals((int)3, (int)linkDown.getObjectTokens().size());
        IfMibTest.assertEquals((String)"ifIndex", (String)((String)((IdToken)linkDown.getObjectTokens().get(0)).getValue()));
        IfMibTest.assertEquals((String)"ifAdminStatus", (String)((String)((IdToken)linkDown.getObjectTokens().get(1)).getValue()));
        IfMibTest.assertEquals((String)"ifOperStatus", (String)((String)((IdToken)linkDown.getObjectTokens().get(2)).getValue()));
        IfMibTest.assertEquals((Object)StatusV2.CURRENT, (Object)linkDown.getStatusV2());
        IfMibTest.assertEquals((String)"linkDown", (String)((String)linkDown.getIdToken().getValue()));
        IfMibTest.assertNotNull((Object)linkDown.getObjects());
        IfMibTest.assertEquals((int)3, (int)linkDown.getObjects().size());
        IfMibTest.assertSame((Object)ifIndex, linkDown.getObjects().get(0));
        IfMibTest.assertSame((Object)ifAdminStatus, linkDown.getObjects().get(1));
        IfMibTest.assertSame((Object)ifOperStatus, linkDown.getObjects().get(2));
    }

    public void testModuleIdentity() {
        SmiModule ifMib = this.getMib().findModule("IF-MIB");
        IfMibTest.assertNotNull((Object)ifMib);
        SmiModuleIdentity moduleIdentity = ifMib.getModuleIdentity();
        IfMibTest.assertNotNull((String)"ModuleIdentity must not be null", (Object)moduleIdentity);
        IfMibTest.assertEquals((String)"IETF Interfaces MIB Working Group", (String)moduleIdentity.getOrganization());
        IfMibTest.assertEquals((String)"200006140000Z", (String)moduleIdentity.getLastUpdated());
        List revisions = moduleIdentity.getRevisions();
        IfMibTest.assertEquals((int)3, (int)revisions.size());
        SmiModuleRevision lastRevision = (SmiModuleRevision)revisions.get(2);
        IfMibTest.assertEquals((String)"199311082155Z", (String)lastRevision.getRevision());
        IfMibTest.assertEquals((String)"Initial revision, published as part of RFC 1573.", (String)lastRevision.getDescription());
    }
}

