/*
 * Decompiled with CFR 0.152.
 */
package org.jsmiparser.parser;

import java.io.File;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import org.jsmiparser.AbstractMibTestCase;
import org.jsmiparser.parser.LibSmiParserFactory;
import org.jsmiparser.parser.SmiDefaultParser;
import org.jsmiparser.smi.SmiConstants;
import org.jsmiparser.smi.SmiIndex;
import org.jsmiparser.smi.SmiMib;
import org.jsmiparser.smi.SmiModule;
import org.jsmiparser.smi.SmiNamedNumber;
import org.jsmiparser.smi.SmiOidValue;
import org.jsmiparser.smi.SmiPrimitiveType;
import org.jsmiparser.smi.SmiProtocolType;
import org.jsmiparser.smi.SmiRange;
import org.jsmiparser.smi.SmiReferencedType;
import org.jsmiparser.smi.SmiRow;
import org.jsmiparser.smi.SmiTable;
import org.jsmiparser.smi.SmiTextualConvention;
import org.jsmiparser.smi.SmiType;
import org.jsmiparser.smi.SmiVarBindField;
import org.jsmiparser.smi.SmiVariable;
import org.jsmiparser.util.token.HexStringToken;

public class SmiDefaultParserTest
extends AbstractMibTestCase {
    public SmiDefaultParserTest() {
        super(null, new String[0]);
    }

    protected SmiDefaultParser createParser() throws Exception {
        URL mibsURL = ((Object)((Object)this)).getClass().getClassLoader().getResource("libsmi-0.4.8/mibs");
        if (mibsURL == null) {
            throw new IllegalStateException("Could not find resource: libsmi-0.4.8/mibs");
        }
        File mibsDir = new File(mibsURL.toURI());
        return new LibSmiParserFactory(mibsDir).create();
    }

    public void testLibSmi() throws URISyntaxException {
        SmiMib mib = this.getMib();
        SmiDefaultParserTest.assertNotNull((Object)mib);
        this.checkOidTree(mib);
        SmiDefaultParserTest.assertEquals((int)298, (int)mib.getModules().size());
        SmiDefaultParserTest.assertEquals((int)2227, (int)mib.getTypes().size());
        SmiDefaultParserTest.assertEquals((int)661, (int)mib.getTextualConventions().size());
        SmiDefaultParserTest.assertEquals((int)1502, (int)mib.getTables().size());
        SmiDefaultParserTest.assertEquals((int)1502, (int)mib.getRows().size());
        SmiDefaultParserTest.assertEquals((int)14909, (int)mib.getVariables().size());
        SmiDefaultParserTest.assertEquals((int)1689, (int)mib.getScalars().size());
        SmiDefaultParserTest.assertEquals((int)13220, (int)mib.getColumns().size());
        SmiDefaultParserTest.assertEquals((int)mib.getVariables().size(), (int)(mib.getScalars().size() + mib.getColumns().size()));
        SmiDefaultParserTest.assertEquals((int)22576, (int)mib.getOidValues().size());
        SmiDefaultParserTest.assertEquals((int)(mib.getTables().size() + mib.getRows().size() + mib.getVariables().size()), (int)mib.getObjectTypes().size());
        this.checkObjectTypeAccessAll(mib);
    }

    public void testNoCycleInStandards() {
        SmiModule rfc1155Smi = this.getMib().findModule("RFC1155-SMI");
        SmiDefaultParserTest.assertNotNull((Object)rfc1155Smi);
        SmiDefaultParserTest.assertEquals((int)0, (int)rfc1155Smi.getImports().size());
        SmiModule rfc1212 = this.getMib().findModule("RFC-1212");
        SmiDefaultParserTest.assertNotNull((Object)rfc1212);
        SmiDefaultParserTest.assertEquals((int)1, (int)rfc1212.getImports().size());
    }

    public void testBitsDefVal() {
        SmiVariable var = (SmiVariable)this.getMib().getColumns().find("acctngSelectionType");
        SmiDefaultParserTest.assertNotNull((Object)var);
        SmiDefaultParserTest.assertEquals((Object)SmiPrimitiveType.BITS, (Object)var.getPrimitiveType());
        List defaultValue = var.getDefaultValue().getBitsValue();
        SmiDefaultParserTest.assertEquals((int)4, (int)defaultValue.size());
        for (SmiNamedNumber nn : defaultValue) {
            SmiDefaultParserTest.assertNotNull((Object)nn);
        }
    }

    public void testDefaultValueOid() {
        SmiMib mib = this.getMib();
        SmiOidValue zeroDotZero = (SmiOidValue)mib.getOidValues().find("zeroDotZero");
        SmiDefaultParserTest.assertNotNull((Object)zeroDotZero);
        SmiDefaultParserTest.assertEquals((Object)mib.getRootNode(), (Object)zeroDotZero.getNode().getParent().getParent());
        SmiDefaultParserTest.assertEquals((int)2, (int)zeroDotZero.getOid().length);
        SmiDefaultParserTest.assertEquals((int)0, (int)zeroDotZero.getOid()[0]);
        SmiDefaultParserTest.assertEquals((int)0, (int)zeroDotZero.getOid()[1]);
        SmiVariable mioxPeerX25CallParamId = (SmiVariable)mib.getVariables().find("mioxPeerX25CallParamId");
        SmiDefaultParserTest.assertNotNull((Object)mioxPeerX25CallParamId);
        SmiDefaultParserTest.assertNotNull((Object)mioxPeerX25CallParamId.getDefaultValue());
        SmiDefaultParserTest.assertNotNull((Object)mioxPeerX25CallParamId.getDefaultValue().getOidNode());
        SmiDefaultParserTest.assertSame((Object)zeroDotZero.getNode(), (Object)mioxPeerX25CallParamId.getDefaultValue().getOidNode());
    }

    public void testIntegerHexStringRange() {
        SmiMib mib = this.getMib();
        SmiTextualConvention refreshIntervalTC = (SmiTextualConvention)mib.getTextualConventions().find("RefreshInterval");
        SmiDefaultParserTest.assertNotNull((Object)refreshIntervalTC);
        SmiDefaultParserTest.assertEquals((int)1, (int)refreshIntervalTC.getRangeConstraints().size());
        SmiRange range = (SmiRange)refreshIntervalTC.getRangeConstraints().get(0);
        SmiDefaultParserTest.assertEquals((Object)new BigInteger("0"), (Object)range.getMinValue());
        SmiDefaultParserTest.assertNotNull((Object)range.getEndToken());
        SmiDefaultParserTest.assertTrue((boolean)(range.getEndToken() instanceof HexStringToken));
        SmiDefaultParserTest.assertEquals((Object)new BigInteger("7FFFFFFF", 16), (Object)range.getMaxValue());
    }

    public void testNetworkAddressChoice() {
        SmiMib mib = this.getMib();
        SmiType ipAddress = (SmiType)mib.getTypes().find("RFC1155-SMI", "IpAddress");
        SmiDefaultParserTest.assertNotNull((Object)ipAddress);
        SmiType networkAddress = (SmiType)mib.getTypes().find("RFC1155-SMI", "NetworkAddress");
        SmiDefaultParserTest.assertNotNull((Object)networkAddress);
        SmiDefaultParserTest.assertEquals(SmiType.class, networkAddress.getClass());
        SmiDefaultParserTest.assertSame((Object)ipAddress, (Object)networkAddress.getBaseType());
        SmiVariable atNetAddress = (SmiVariable)mib.getVariables().find("RFC1213-MIB", "atNetAddress");
        SmiDefaultParserTest.assertNotNull((Object)atNetAddress);
        SmiDefaultParserTest.assertSame((Object)networkAddress, (Object)atNetAddress.getType());
        SmiDefaultParserTest.assertEquals((Object)SmiPrimitiveType.IP_ADDRESS, (Object)atNetAddress.getPrimitiveType());
    }

    public void testTypes() {
        for (SmiType type : this.getMib().getTypes()) {
            SmiDefaultParserTest.assertFalse((boolean)(type instanceof SmiReferencedType));
            if (!(type instanceof SmiProtocolType) && type.getFields() == null) {
                SmiDefaultParserTest.assertNotNull((String)type.getId(), (Object)type.getPrimitiveType());
            }
            this.checkType(type);
        }
        for (SmiVariable variable : this.getMib().getVariables()) {
            SmiDefaultParserTest.assertNotNull((String)variable.getId(), (Object)variable.getType());
            SmiDefaultParserTest.assertFalse((String)variable.getId(), (boolean)(variable.getType() instanceof SmiReferencedType));
            SmiDefaultParserTest.assertFalse((String)variable.getId(), (boolean)(variable.getType() instanceof SmiProtocolType));
            SmiDefaultParserTest.assertNotNull((String)variable.getId(), (Object)variable.getType().getPrimitiveType());
            this.checkType(variable.getType());
        }
    }

    private void checkType(SmiType type) {
        if (type.getBaseType() != null) {
            this.checkType(type.getBaseType());
        } else if (type.getFields() == null && !(type instanceof SmiProtocolType)) {
            SmiDefaultParserTest.assertTrue((String)type.getId(), (type == SmiConstants.BITS_TYPE || type == SmiConstants.INTEGER_TYPE || type == SmiConstants.OBJECT_IDENTIFIER_TYPE || type == SmiConstants.OCTET_STRING_TYPE ? 1 : 0) != 0);
        }
    }

    public void testIpNetToMediaNetAddress() {
        SmiVariable var = (SmiVariable)this.getMib().getVariables().find("IP-MIB", "ipNetToMediaNetAddress");
        SmiDefaultParserTest.assertNotNull((Object)var);
        SmiDefaultParserTest.assertEquals((Object)SmiPrimitiveType.IP_ADDRESS, (Object)var.getPrimitiveType());
    }

    public void testAtmAcctngRecordCrc16() {
        SmiVariable var = (SmiVariable)this.getMib().getVariables().find("atmAcctngRecordCrc16");
        SmiDefaultParserTest.assertNotNull((Object)var);
        SmiDefaultParserTest.assertEquals((Object)SmiPrimitiveType.OCTET_STRING, (Object)var.getPrimitiveType());
        SmiDefaultParserTest.assertNotNull((Object)var.getSizeConstraints());
    }

    public void testFindMethods() {
        SmiMib mib = this.getMib();
        List pingMibs = mib.getSymbols().findAll("pingMIB");
        SmiDefaultParserTest.assertEquals((int)2, (int)pingMibs.size());
        try {
            mib.getSymbols().find("pingMIB");
            SmiDefaultParserTest.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            mib.getSymbols().find(null, "pingMIB");
            SmiDefaultParserTest.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            mib.getSymbols().find("IF-MIBBBBB", "pingMIB");
            SmiDefaultParserTest.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        SmiDefaultParserTest.assertNull((Object)mib.getSymbols().find("IF-MIB", "pingMIB"));
        SmiOidValue dismanPingMIB = (SmiOidValue)mib.getOidValues().find("DISMAN-PING-MIB", "pingMIB");
        SmiDefaultParserTest.assertNotNull((Object)dismanPingMIB);
        SmiDefaultParserTest.assertEquals((String)"DISMAN-PING-MIB", (String)dismanPingMIB.getModule().getId());
        SmiDefaultParserTest.assertEquals((int)80, (int)dismanPingMIB.getLastOidComponent().getValueToken().getValue());
        SmiOidValue tubsIbrPingMIB = (SmiOidValue)mib.getOidValues().find("TUBS-IBR-PING-MIB", "pingMIB");
        SmiDefaultParserTest.assertNotNull((Object)tubsIbrPingMIB);
        SmiDefaultParserTest.assertEquals((String)"TUBS-IBR-PING-MIB", (String)tubsIbrPingMIB.getModule().getId());
        SmiDefaultParserTest.assertEquals((int)8, (int)tubsIbrPingMIB.getLastOidComponent().getValueToken().getValue());
    }

    public void testUnits() {
        SmiModule ipModule = this.getMib().findModule("IP-MIB");
        SmiVariable ipReasmTimeout = ipModule.findVariable("ipReasmTimeout");
        SmiDefaultParserTest.assertNotNull((Object)ipReasmTimeout);
        SmiDefaultParserTest.assertNotNull((Object)ipReasmTimeout.getUnitsToken());
        SmiDefaultParserTest.assertEquals((String)"seconds", (String)ipReasmTimeout.getUnits());
    }

    public void testIfMib() {
        SmiMib mib = this.getMib();
        SmiModule ifModule = mib.findModule("IF-MIB");
        SmiDefaultParserTest.assertNotNull((Object)ifModule);
        SmiType interfaceIndex = ifModule.findType("InterfaceIndex");
        SmiDefaultParserTest.assertNotNull((Object)interfaceIndex);
        List interfaceIndexes = mib.getTypes().findAll("InterfaceIndex");
        SmiDefaultParserTest.assertEquals((int)2, (int)interfaceIndexes.size());
        SmiDefaultParserTest.assertTrue((boolean)interfaceIndexes.contains(interfaceIndex));
        SmiDefaultParserTest.assertEquals((String)"InterfaceIndex", (String)interfaceIndex.getId());
        SmiDefaultParserTest.assertEquals((String)"IF-MIB", (String)interfaceIndex.getModule().getId());
        String source = interfaceIndex.getModule().getIdToken().getLocation().getSource();
        SmiDefaultParserTest.assertTrue((boolean)source.contains("IF-MIB"));
        SmiDefaultParserTest.assertEquals(SmiTextualConvention.class, interfaceIndex.getClass());
        SmiDefaultParserTest.assertNotNull((Object)interfaceIndex.getRangeConstraints());
        SmiDefaultParserTest.assertEquals((int)1, (int)interfaceIndex.getRangeConstraints().size());
        SmiDefaultParserTest.assertEquals((Object)SmiVarBindField.INTEGER_VALUE, (Object)interfaceIndex.getVarBindField());
        SmiTable ifTable = ifModule.findTable("ifTable");
        SmiDefaultParserTest.assertNotNull((Object)ifTable);
        SmiDefaultParserTest.assertEquals((String)"1.3.6.1.2.1.2.2", (String)ifTable.getOidStr());
        List ifTables = mib.getTables().findAll("ifTable");
        SmiDefaultParserTest.assertEquals((int)2, (int)ifTables.size());
        SmiDefaultParserTest.assertTrue((boolean)ifTables.contains(ifTable));
        SmiRow ifEntry = ifModule.findRow("ifEntry");
        SmiDefaultParserTest.assertNotNull((Object)ifEntry);
        SmiDefaultParserTest.assertEquals((String)"1.3.6.1.2.1.2.2.1", (String)ifEntry.getOidStr());
        SmiDefaultParserTest.assertSame((Object)ifEntry.getTable(), (Object)ifTable);
        SmiVariable ifAdminStatus = ifModule.findVariable("ifAdminStatus");
        SmiDefaultParserTest.assertNotNull((Object)ifAdminStatus);
        SmiDefaultParserTest.assertEquals((String)"1.3.6.1.2.1.2.2.1.7", (String)ifAdminStatus.getOidStr());
    }

    public void testJobMonitoringMib() {
        SmiOidValue jobmonMIB = (SmiOidValue)this.getMib().getOidValues().find("jobmonMIB");
        SmiDefaultParserTest.assertNotNull((Object)jobmonMIB);
        SmiDefaultParserTest.assertEquals((String)"1.3.6.1.4.1.2699.1.1", (String)jobmonMIB.getOidStr());
    }

    public void testDlswMib() {
        SmiOidValue nullSymbol = (SmiOidValue)this.getMib().getOidValues().find("null");
        SmiDefaultParserTest.assertNotNull((Object)nullSymbol);
        SmiDefaultParserTest.assertEquals((String)"0.0", (String)nullSymbol.getOidStr());
    }

    public void testDismanPingMib() {
        SmiMib mib = this.getMib();
        List pingMIBs = mib.getSymbols().findAll("pingMIB");
        SmiDefaultParserTest.assertEquals((int)2, (int)pingMIBs.size());
        SmiModule dismanPingModule = mib.findModule("DISMAN-PING-MIB");
        SmiOidValue dismanPingMIB = dismanPingModule.findOidValue("pingMIB");
        SmiDefaultParserTest.assertNotNull((Object)dismanPingMIB);
        SmiDefaultParserTest.assertNotNull((Object)dismanPingMIB.getNode().getParent());
        SmiDefaultParserTest.assertEquals((Object)mib.getRootNode(), (Object)dismanPingMIB.getNode().getRootNode());
        SmiDefaultParserTest.assertEquals((int)4, (int)dismanPingMIB.getNode().getChildren().size());
        SmiDefaultParserTest.assertTrue((boolean)pingMIBs.contains(dismanPingMIB));
        SmiModule tubsPingModule = mib.findModule("TUBS-IBR-PING-MIB");
        SmiOidValue tubsPingMIB = tubsPingModule.findOidValue("pingMIB");
        SmiDefaultParserTest.assertNotNull((Object)tubsPingMIB);
        SmiDefaultParserTest.assertNotNull((Object)tubsPingMIB.getNode().getParent());
        SmiDefaultParserTest.assertEquals((Object)mib.getRootNode(), (Object)tubsPingMIB.getNode().getRootNode());
        SmiDefaultParserTest.assertEquals((int)2, (int)tubsPingMIB.getNode().getChildren().size());
        SmiDefaultParserTest.assertTrue((boolean)pingMIBs.contains(tubsPingMIB));
    }

    public void testComplexIndex() {
        SmiMib mib = this.getMib();
        for (SmiRow row : mib.getRows()) {
            if (row.getAugments() != null) continue;
            SmiDefaultParserTest.assertNotNull((Object)row.getIndexes());
            SmiDefaultParserTest.assertTrue((String)row.getId(), (!row.getIndexes().isEmpty() ? 1 : 0) != 0);
        }
        SmiRow row = (SmiRow)mib.getRows().find("mallocScopeNameEntry");
        SmiDefaultParserTest.assertNotNull((Object)row);
        SmiDefaultParserTest.assertEquals((int)3, (int)row.getIndexes().size());
        SmiIndex index1 = (SmiIndex)row.getIndexes().get(0);
        SmiIndex index2 = (SmiIndex)row.getIndexes().get(1);
        SmiIndex index3 = (SmiIndex)row.getIndexes().get(2);
        SmiDefaultParserTest.assertEquals((String)"mallocScopeAddressType", (String)index1.getColumn().getId());
        SmiDefaultParserTest.assertFalse((boolean)index1.isImplied());
        SmiDefaultParserTest.assertNotNull((Object)index1.getColumn().getRow());
        SmiDefaultParserTest.assertNotSame((Object)row, (Object)index1.getColumn().getRow());
        SmiDefaultParserTest.assertEquals((String)"mallocScopeFirstAddress", (String)index2.getColumn().getId());
        SmiDefaultParserTest.assertFalse((boolean)index2.isImplied());
        SmiDefaultParserTest.assertNotNull((Object)index2.getColumn().getRow());
        SmiDefaultParserTest.assertNotSame((Object)row, (Object)index2.getColumn().getRow());
        SmiDefaultParserTest.assertEquals((String)"mallocScopeNameLangName", (String)index3.getColumn().getId());
        SmiDefaultParserTest.assertTrue((boolean)index3.isImplied());
        SmiDefaultParserTest.assertNotNull((Object)index3.getColumn().getRow());
        SmiDefaultParserTest.assertSame((Object)row, (Object)index3.getColumn().getRow());
    }

    public void testAllVariables() {
        for (SmiVariable v : this.getMib().getVariables()) {
            SmiDefaultParserTest.assertTrue((String)v.getId(), (v.isColumn() || v.isScalar() ? 1 : 0) != 0);
            SmiDefaultParserTest.assertFalse((String)v.getId(), (v.isColumn() && v.isScalar() ? 1 : 0) != 0);
            SmiDefaultParserTest.assertFalse((boolean)v.getId().endsWith("Entry"));
            SmiDefaultParserTest.assertNotNull((Object)v.getPrimitiveType());
        }
    }
}

