/*
 * Decompiled with CFR 0.152.
 */
package org.jsmiparser.codegen;

import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JEnumConstant;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import org.jsmiparser.codegen.CodeBuilderSettings;
import org.jsmiparser.smi.SmiModule;
import org.jsmiparser.smi.SmiObjectType;
import org.jsmiparser.smi.SmiOidValue;
import org.jsmiparser.smi.SmiPrimitiveType;
import org.jsmiparser.smi.SmiVariable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleBuilder {
    private static final Logger logger = LoggerFactory.getLogger(ModuleBuilder.class);
    private final CodeBuilderSettings settings;
    private final SmiModule module;
    private final JCodeModel codeModel;
    private JDefinedClass definedClass;
    private JFieldVar nameField;
    private JFieldVar oidStrField;
    private JFieldVar berTagValueField;

    public ModuleBuilder(CodeBuilderSettings settings, SmiModule module, JCodeModel codeModel) {
        this.settings = settings;
        this.module = module;
        this.codeModel = codeModel;
    }

    public JDefinedClass build() {
        JPackage _package = this.determinePackage();
        if (this.module.getVariables().isEmpty()) {
            return null;
        }
        try {
            this.definedClass = _package._enum(this.module.getCodeId());
        }
        catch (JClassAlreadyExistsException e) {
            throw new RuntimeException(e.getExistingClass().fullName() + " is already defined in the code model.", e);
        }
        this.addJavadocs();
        this.addInterfaces();
        this.addEnumConstants();
        this.addFields();
        this.addConstructor();
        this.addGetters();
        this.addToString();
        return this.definedClass;
    }

    protected JPackage determinePackage() {
        return this.codeModel._package(this.settings.getPackageName() + "." + this.module.getCodeId().toLowerCase());
    }

    protected void addJavadocs() {
    }

    protected void addInterfaces() {
    }

    protected void addEnumConstants() {
        for (SmiOidValue v : this.module.getOidValues()) {
            if (v.getId() == null) continue;
            this.addOidValue(v);
        }
    }

    private void addOidValue(SmiOidValue v) {
        SmiPrimitiveType primitiveType = this.determinePrimitiveType(v);
        int berValue = primitiveType != null ? (int)primitiveType.getVarBindField().getBerTagValue() : -1;
        JEnumConstant ec = this.definedClass.enumConstant(v.getCodeId()).arg(JExpr.lit((String)v.getId())).arg(JExpr.lit((String)v.getOidStr())).arg(JExpr.lit((int)berValue));
        ec.javadoc().append((Object)("<pre>" + v.getId() + ": " + v.getOidStr() + "</pre>\n\n"));
        if (primitiveType != null) {
            ec.javadoc().append((Object)("<pre>Type:" + primitiveType + "<pre>\n\n"));
        }
        if (v instanceof SmiObjectType) {
            SmiObjectType objectType = (SmiObjectType)v;
            ec.javadoc().append((Object)("<pre>" + objectType.getDescription() + "</pre>"));
        }
    }

    protected SmiPrimitiveType determinePrimitiveType(SmiOidValue v) {
        if (v instanceof SmiVariable) {
            SmiVariable var = (SmiVariable)v;
            return var.getPrimitiveType();
        }
        return null;
    }

    protected void addFields() {
        this.nameField = this.definedClass.field(12, String.class, "name");
        this.oidStrField = this.definedClass.field(12, String.class, "oidStr");
        this.berTagValueField = this.definedClass.field(12, Byte.TYPE, "berTagValue");
    }

    protected void addConstructor() {
        JMethod constructor = this.definedClass.constructor(4);
        JVar nameParam = constructor.param(String.class, "n");
        JVar oidStrParam = constructor.param(String.class, "os");
        JVar berTagValueParam = constructor.param(Integer.TYPE, "btv");
        constructor.body().assign((JAssignmentTarget)this.nameField, (JExpression)nameParam).assign((JAssignmentTarget)this.oidStrField, (JExpression)oidStrParam).assign((JAssignmentTarget)this.berTagValueField, (JExpression)JExpr.cast((JType)this.definedClass.owner().BYTE, (JExpression)berTagValueParam));
    }

    protected void addGetters() {
        this.addNameGetter();
        this.addOidStrGetter();
        this.addBerTagValueGetter();
    }

    protected void addNameGetter() {
        this.definedClass.method(1, String.class, "getName").body()._return((JExpression)this.nameField);
    }

    protected void addOidStrGetter() {
        this.definedClass.method(1, String.class, "getOidStr").body()._return((JExpression)this.oidStrField);
    }

    protected void addBerTagValueGetter() {
        this.definedClass.method(1, Byte.TYPE, "getBerTagValue").body()._return((JExpression)this.berTagValueField);
    }

    protected void addToString() {
        this.definedClass.method(1, String.class, "toString").body()._return(this.nameField.plus(JExpr.lit((String)": ")).plus((JExpression)this.oidStrField));
    }
}

