/*
 * Decompiled with CFR 0.152.
 */
package org.jsmiparser.codegen;

import com.sun.codemodel.JCodeModel;
import org.jsmiparser.codegen.CodeBuilder;
import org.jsmiparser.codegen.CodeBuilderSettings;
import org.jsmiparser.codegen.EnumBuilder;
import org.jsmiparser.codegen.ModuleBuilder;
import org.jsmiparser.codegen.StraightNamingStrategy;
import org.jsmiparser.smi.SmiCodeNamingStrategy;
import org.jsmiparser.smi.SmiMib;
import org.jsmiparser.smi.SmiModule;
import org.jsmiparser.smi.SmiType;

public class BuilderFactory {
    private final CodeBuilderSettings settings;
    private JCodeModel codeModel;

    public BuilderFactory(CodeBuilderSettings settings) {
        this.settings = settings;
    }

    public CodeBuilder createCodeBuilder(SmiMib mib) {
        mib.setCodeNamingStrategy(this.createNamingStrategy());
        this.codeModel = new JCodeModel();
        return new CodeBuilder(mib, this.settings, this, this.codeModel);
    }

    public SmiCodeNamingStrategy createNamingStrategy() {
        return new StraightNamingStrategy(this.settings.getPackageName());
    }

    public EnumBuilder createEnumBuilder(SmiType type, String typeName) {
        return new EnumBuilder(this.settings, type, typeName, this.codeModel);
    }

    public ModuleBuilder createModuleBuilder(SmiModule module) {
        return new ModuleBuilder(this.settings, module, this.codeModel);
    }
}

