/*
 * Decompiled with CFR 0.152.
 */
package org.jsmiparser.codegen;

import com.sun.codemodel.JCodeModel;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import org.jsmiparser.codegen.BuilderFactory;
import org.jsmiparser.codegen.CodeBuilderSettings;
import org.jsmiparser.smi.SmiMib;
import org.jsmiparser.smi.SmiModule;
import org.jsmiparser.smi.SmiType;
import org.jsmiparser.smi.SmiUtil;
import org.jsmiparser.smi.SmiVariable;

public class CodeBuilder {
    private final SmiMib mib;
    private final CodeBuilderSettings settings;
    private final BuilderFactory builderFactory;
    private final JCodeModel codeModel;

    public CodeBuilder(SmiMib mib, CodeBuilderSettings settings, BuilderFactory builderFactory, JCodeModel codeModel) {
        this.mib = mib;
        this.settings = settings;
        this.builderFactory = builderFactory;
        this.codeModel = codeModel;
    }

    public void build() {
        this.buildOids();
        this.buildEnums();
    }

    protected void buildOids() {
        for (SmiModule m : this.mib.getModules()) {
            this.buildModule(m);
        }
    }

    protected void buildModule(SmiModule module) {
        this.builderFactory.createModuleBuilder(module).build();
    }

    protected void buildEnums() {
        for (SmiType type : this.mib.getTypes()) {
            if (type.getNamedNumbers() == null) continue;
            String typeName = type.getCodeId();
            if (type.getBitFields() != null) {
                typeName = typeName + this.settings.getBitsEnumTypeNameSuffix();
            }
            this.buildEnum(type, typeName);
        }
        for (SmiVariable variable : this.mib.getVariables()) {
            SmiType type = variable.getType();
            if (type.getId() != null || type.getNamedNumbers() == null) continue;
            String typeName = SmiUtil.ucFirst((String)variable.getCodeId());
            if (type.getBitFields() != null) {
                typeName = typeName + this.settings.getBitsEnumTypeNameSuffix();
            }
            this.buildEnum(type, typeName);
        }
    }

    protected void buildEnum(SmiType type, String typeName) {
        this.builderFactory.createEnumBuilder(type, typeName).build();
    }

    public void write(PrintStream status) throws IOException {
        this.build();
        File outputDir = this.settings.getOutputDir();
        if (outputDir.exists()) {
            if (!outputDir.isDirectory()) {
                throw new IllegalStateException("The path of the output directory " + outputDir + " exists, but is not a directory.");
            }
        } else {
            boolean isCreated = outputDir.mkdirs();
            if (!isCreated) {
                throw new IllegalStateException("Output directory " + outputDir + " could not be created.");
            }
        }
        this.codeModel.build(outputDir, status);
    }
}

