/*
 * Decompiled with CFR 0.152.
 */
package org.jsmiparser.codegen;

import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocComment;
import com.sun.codemodel.JEnumConstant;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JVar;
import java.util.Iterator;
import org.jsmiparser.codegen.CodeBuilderSettings;
import org.jsmiparser.smi.SmiNamedNumber;
import org.jsmiparser.smi.SmiType;

public class EnumBuilder {
    protected final CodeBuilderSettings settings;
    protected final SmiType type;
    protected final String typeName;
    protected final JCodeModel codeModel;
    protected JDefinedClass definedClass;
    protected JFieldVar nameField;
    protected JFieldVar valueField;

    public EnumBuilder(CodeBuilderSettings settings, SmiType type, JCodeModel codeModel) {
        this(settings, type, type.getId(), codeModel);
    }

    public EnumBuilder(CodeBuilderSettings settings, SmiType type, String typeName, JCodeModel codeModel) {
        this.settings = settings;
        this.type = type;
        this.typeName = typeName;
        this.codeModel = codeModel;
    }

    public JDefinedClass build() {
        JPackage _package = this.determinePackage();
        try {
            this.definedClass = _package._enum(this.typeName);
        }
        catch (JClassAlreadyExistsException e) {
            throw new RuntimeException(e.getExistingClass().fullName() + " is already defined in the code model.", e);
        }
        this.addJavadocs();
        this.addInterfaces();
        this.addEnumConstants();
        this.addFields();
        this.addConstructor();
        this.addNameGetter();
        this.addValueGetter();
        this.addToString();
        return this.definedClass;
    }

    protected JPackage determinePackage() {
        return this.codeModel._package(this.settings.getPackageName() + "." + this.type.getModule().getCodeId().toLowerCase());
    }

    protected void addJavadocs() {
        JDocComment c = this.definedClass.javadoc();
        c.add((Object)"<pre>\n");
        Iterator iterator = this.type.getNamedNumbers().iterator();
        while (iterator.hasNext()) {
            SmiNamedNumber namedNumber = (SmiNamedNumber)iterator.next();
            c.add((Object)namedNumber.toString());
            if (iterator.hasNext()) {
                c.add((Object)",");
            }
            c.add((Object)"\n");
        }
        c.add((Object)"</pre>\n");
    }

    protected void addInterfaces() {
        if (this.settings.getEnumInterface() != null) {
            this.definedClass._implements(this.codeModel.ref(this.settings.getEnumInterface()));
        }
    }

    protected void addEnumConstants() {
        for (SmiNamedNumber namedNumber : this.type.getNamedNumbers()) {
            JEnumConstant ec = this.definedClass.enumConstant(namedNumber.getCodeId());
            ec.arg(JExpr.lit((String)namedNumber.getId()));
            ec.arg(JExpr.lit((int)namedNumber.getValue().intValue()));
            ec.javadoc().add((Object)("<pre>" + namedNumber.toString() + "</pre>"));
        }
    }

    protected void addFields() {
        this.nameField = this.definedClass.field(12, String.class, "name");
        this.valueField = this.definedClass.field(12, Integer.TYPE, "value");
    }

    protected void addConstructor() {
        JMethod constructor = this.definedClass.constructor(4);
        JVar nameParam = constructor.param(String.class, "n");
        JVar valueParam = constructor.param(Integer.TYPE, "v");
        constructor.body().assign((JAssignmentTarget)this.nameField, (JExpression)nameParam).assign((JAssignmentTarget)this.valueField, (JExpression)valueParam);
    }

    protected void addNameGetter() {
        this.definedClass.method(1, String.class, "getName").body()._return((JExpression)this.nameField);
    }

    protected void addValueGetter() {
        this.definedClass.method(1, Integer.TYPE, "getValue").body()._return((JExpression)this.valueField);
    }

    protected void addToString() {
        this.definedClass.method(1, String.class, "toString").body()._return(this.nameField.plus(JExpr.lit((String)"(")).plus((JExpression)this.valueField).plus(JExpr.lit((String)")")));
    }
}

