/*
 * Decompiled with CFR 0.152.
 */
package org.jsmiparser.codegen;

import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JEnumConstant;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Map;
import org.jsmiparser.codegen.CodeBuilderSettings;
import org.jsmiparser.codegen.DefaultCodeBuilderSettings;
import org.jsmiparser.codegen.EnumBuilder;
import org.jsmiparser.codegen.StraightNamingStrategy;
import org.jsmiparser.smi.SmiCodeNamingStrategy;
import org.jsmiparser.smi.SmiMib;
import org.jsmiparser.smi.SmiModule;
import org.jsmiparser.smi.SmiNamedNumber;
import org.jsmiparser.smi.SmiPrimitiveType;
import org.jsmiparser.smi.SmiType;
import org.jsmiparser.util.FileTestUtil;
import org.jsmiparser.util.token.BigIntegerToken;
import org.jsmiparser.util.token.IdToken;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumBuilderTest {
    private JCodeModel codeModel;
    private DefaultCodeBuilderSettings settings;

    @Before
    public void before() {
        this.codeModel = new JCodeModel();
        this.settings = new DefaultCodeBuilderSettings();
        this.settings.setPackageName("mytest");
    }

    @After
    public void after() throws IOException {
        File dir = FileTestUtil.makeBuildSubDir(EnumBuilderTest.class, (String[])new String[]{"jsmiparser-codegen-test"});
        this.codeModel.build(dir, (PrintStream)null);
        this.codeModel = null;
    }

    @Test
    public void testMyEnum() throws JClassAlreadyExistsException {
        StraightNamingStrategy namingStrategy = new StraightNamingStrategy("");
        SmiType type = new SmiType(new IdToken(null, "MyEnum"), new SmiModule(new SmiMib(null, null), new IdToken(null, "MyModule")), SmiPrimitiveType.ENUM);
        type.getModule().getMib().setCodeNamingStrategy((SmiCodeNamingStrategy)new StraightNamingStrategy(this.settings.getPackageName()));
        type.setEnumValues(Arrays.asList(new SmiNamedNumber(new IdToken(null, "enum1"), new BigIntegerToken(1)), new SmiNamedNumber(new IdToken(null, "enum2"), new BigIntegerToken(2))));
        JDefinedClass ec = new EnumBuilder((CodeBuilderSettings)this.settings, type, this.codeModel).build();
        Assert.assertEquals((Object)"MyEnum", (Object)ec.name());
        Assert.assertEquals((long)2L, (long)this.getEnumConstantsByName(ec).size());
    }

    private Map<String, JEnumConstant> getEnumConstantsByName(JDefinedClass dc) {
        try {
            Field field = JDefinedClass.class.getDeclaredField("enumConstantsByName");
            field.setAccessible(true);
            return (Map)field.get(dc);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

