/*
 * Decompiled with CFR 0.152.
 */
package org.jsmiparser.gradle;

import java.io.File;
import java.io.PrintStream;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.tooling.BuildException;
import org.jsmiparser.codegen.BuilderFactory;
import org.jsmiparser.codegen.CodeBuilder;
import org.jsmiparser.codegen.CodeBuilderSettings;
import org.jsmiparser.codegen.DefaultCodeBuilderSettings;
import org.jsmiparser.gradle.FileCollectionURLListFactory;
import org.jsmiparser.parser.SmiDefaultParser;
import org.jsmiparser.smi.SmiMib;
import org.jsmiparser.smi.SmiModule;

public class CodegenTask
extends DefaultTask {
    private final DefaultCodeBuilderSettings settings = new DefaultCodeBuilderSettings();
    private SmiMib mib;
    private FileCollection inputFiles;
    private File statusFile;
    private boolean failOnMibError = true;
    private BuilderFactory builderFactory;

    public DefaultCodeBuilderSettings getSettings() {
        return this.settings;
    }

    public SmiMib getMib() {
        return this.mib;
    }

    public void setMib(SmiMib mib) {
        this.mib = mib;
    }

    @InputFiles
    public FileCollection getInputFiles() {
        return this.inputFiles;
    }

    public void setInputFiles(FileCollection inputFiles) {
        this.inputFiles = inputFiles;
    }

    public File getOutputDir() {
        if (this.settings.getOutputDir() == null) {
            this.settings.setOutputDir(new File(new File(this.getProject().getBuildDir(), "generated-src"), "java"));
        }
        return this.settings.getOutputDir();
    }

    public void setOutputDir(File outputDir) {
        this.settings.setOutputDir(outputDir);
    }

    @OutputFile
    public File getStatusFile() {
        if (this.statusFile != null) {
            return this.statusFile;
        }
        return new File(this.getOutputDir(), "." + CodegenTask.class.getName() + "." + this.getName());
    }

    public void setStatusFile(File statusFile) {
        this.statusFile = statusFile;
    }

    public boolean isFailOnMibError() {
        return this.failOnMibError;
    }

    public void setFailOnMibError(boolean failOnMibError) {
        this.failOnMibError = failOnMibError;
    }

    public BuilderFactory getBuilderFactory() {
        return this.builderFactory;
    }

    public void setBuilderFactory(BuilderFactory builderFactory) {
        this.builderFactory = builderFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public void build() throws Exception {
        SmiMib mib = this.determineMib();
        this.getLogger().debug("Compiling {} mibs to package {} in {}", new Object[]{mib.getModules().size(), this.settings.getPackageName(), this.settings.getOutputDir()});
        for (SmiModule module : mib.getModules()) {
            this.getLogger().debug(module.getId());
        }
        PrintStream status = new PrintStream(this.getStatusFile());
        try {
            CodeBuilder codeBuilder = this.determineBuilderFactory().createCodeBuilder(mib);
            codeBuilder.write(status);
        }
        finally {
            status.close();
        }
    }

    protected BuilderFactory determineBuilderFactory() {
        if (this.builderFactory != null) {
            return this.builderFactory;
        }
        return new BuilderFactory((CodeBuilderSettings)this.getSettings());
    }

    protected SmiMib determineMib() throws Exception {
        if (this.mib != null) {
            return this.mib;
        }
        if (this.inputFiles != null) {
            return this.parseMib();
        }
        throw new BuildException("Either mib or inputFiles should be set.", null);
    }

    protected SmiMib parseMib() throws Exception {
        SmiDefaultParser parser = this.createParser();
        SmiMib result = parser.parse();
        if (parser.getProblemEventHandler().isNotOk()) {
            int problemCount = parser.getProblemEventHandler().getTotalCount();
            if (this.failOnMibError) {
                throw new BuildException("Found " + problemCount + " problems.", null);
            }
            this.getLogger().quiet("Found {} problems, but continuing anyway, because failOnMibError is set to false.", new Object[]{problemCount});
        }
        return result;
    }

    protected SmiDefaultParser createParser() throws Exception {
        SmiDefaultParser parser = new SmiDefaultParser();
        parser.getFileParserPhase().setInputUrls(new FileCollectionURLListFactory(this.inputFiles).create());
        return parser;
    }
}

