/*
 * Decompiled with CFR 0.152.
 */
package org.jsmiparser.util.token;

import org.jsmiparser.util.location.Location;
import org.jsmiparser.util.token.StringToken;

public class QuotedStringToken
extends StringToken {
    private char m_quoteChar;

    public QuotedStringToken(Location location, String value, char quoteChar) {
        super(location, QuotedStringToken.strip(value, quoteChar));
        this.m_quoteChar = quoteChar;
    }

    private static String strip(String str, char quoteChar) {
        if (str.charAt(0) == quoteChar && str.charAt(str.length() - 1) == quoteChar) {
            return str.substring(1, str.length() - 1);
        }
        throw new IllegalArgumentException(str + " is not a valid " + quoteChar + "-quoted string ");
    }

    public char getQuoteChar() {
        return this.m_quoteChar;
    }

    public String toString() {
        return this.m_quoteChar + (String)this.m_value + this.m_quoteChar;
    }
}

