/*
 * Decompiled with CFR 0.152.
 */
package org.jsmiparser.util.url;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.jsmiparser.util.url.AbstractURLListFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileURLListFactory
extends AbstractURLListFactory {
    public FileURLListFactory() {
    }

    public FileURLListFactory(File rootDir) {
        this(rootDir.getAbsolutePath());
    }

    public FileURLListFactory(String rootPath) {
        super(rootPath);
    }

    public FileURLListFactory(File rootDir, List<String> children) {
        super(rootDir.getAbsolutePath(), children);
    }

    public FileURLListFactory(String rootPath, List<String> children) {
        super(rootPath, children);
    }

    @Override
    public List<URL> create() throws Exception {
        ArrayList<URL> result = new ArrayList<URL>();
        File dir = new File(this.m_rootPath);
        for (String child : this.m_children) {
            File file = new File(dir, child);
            if (!file.exists()) {
                throw new IllegalStateException("File doesn't exist: " + file);
            }
            result.add(file.toURI().toURL());
        }
        return result;
    }
}

