/*
 * Decompiled with CFR 0.152.
 */
package org.jsmiparser.util;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import org.junit.Assert;

public abstract class FileTestUtil {
    public static File getBuildDir(Class testClass) {
        File classFile;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        URL url = cl.getResource(testClass.getName().replace('.', '/') + ".class");
        if (url == null) {
            throw new IllegalArgumentException("class file not found for: " + testClass);
        }
        try {
            classFile = new File(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        if (!classFile.exists()) {
            throw new IllegalStateException(classFile + " does not exist.");
        }
        for (File dir = classFile.getParentFile(); dir != null; dir = dir.getParentFile()) {
            if (!dir.getName().equals("build")) continue;
            return dir;
        }
        throw new IllegalStateException("Could not find 'build' dir as a parent of " + classFile);
    }

    public static File makeBuildSubDir(Class testClass, String ... subDirs) {
        File result = FileTestUtil.getBuildDir(testClass);
        for (String subDir : subDirs) {
            result = new File(result, subDir);
        }
        return FileTestUtil.createDir(result);
    }

    public static File createDir(File dir) {
        if (dir.exists()) {
            Assert.assertTrue((String)(dir + " already exists, but it is not a directory."), (boolean)dir.isDirectory());
        } else {
            boolean isCreated = dir.mkdirs();
            Assert.assertTrue((String)(dir + " does not exist, but cannot be created."), (boolean)isCreated);
        }
        return dir;
    }

    public static void assertExistsAndNotEmpty(File file) {
        Assert.assertTrue((String)("File not created:" + file), (boolean)file.exists());
        Assert.assertTrue((String)(file + " size is " + file.length()), (file.length() > 0L ? 1 : 0) != 0);
    }
}

