/*
 * Decompiled with CFR 0.152.
 */
package org.jsmiparser.util.problem;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.jsmiparser.util.location.Location;
import org.jsmiparser.util.problem.DefaultProblemReporterFactory;
import org.jsmiparser.util.problem.ExampleProblemReporter;
import org.jsmiparser.util.problem.ProblemEventHandler;
import org.jsmiparser.util.problem.TestProblemEventHandler;

public class ProblemHandlerTest
extends TestCase {
    private TestProblemEventHandler m_teh;
    private ExampleProblemReporter m_eh;

    protected void setUp() throws Exception {
        this.m_teh = new TestProblemEventHandler();
        DefaultProblemReporterFactory factory = new DefaultProblemReporterFactory(((Object)((Object)this)).getClass().getClassLoader(), (ProblemEventHandler)this.m_teh);
        this.m_eh = (ExampleProblemReporter)factory.create(ExampleProblemReporter.class);
    }

    public void testSimpleMessage() {
        this.m_eh.simpleMessage();
        ProblemHandlerTest.assertNotNull((Object)this.m_teh.getLastProblemEvent());
        ProblemHandlerTest.assertEquals((String)"Simple message", (String)this.m_teh.getLastProblemEvent().getLocalizedMessage());
        ProblemHandlerTest.assertNull((Object)this.m_teh.getLastProblemEvent().getLocation());
    }

    public void testListSize() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("bla");
        this.m_eh.reportListSize(l);
        ProblemHandlerTest.assertEquals((String)"List size = 1", (String)this.m_teh.getLastProblemEvent().getLocalizedMessage());
        ProblemHandlerTest.assertNull((Object)this.m_teh.getLastProblemEvent().getLocation());
    }

    public void testLocation() {
        Location location = new Location("/tmp/test", 77, 20);
        this.m_eh.simpleLocation(location);
        ProblemHandlerTest.assertEquals((String)"Simple location message", (String)this.m_teh.getLastProblemEvent().getLocalizedMessage());
        ProblemHandlerTest.assertSame((Object)location, (Object)this.m_teh.getLastProblemEvent().getLocation());
    }
}

